/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

import java.io.IOException;
import org.apache.catalina.connector.RequestStream;
import org.apache.catalina.connector.http.HttpRequestImpl;
import org.apache.catalina.connector.http.HttpResponseImpl;

public class HttpRequestStream
extends RequestStream {
    protected boolean chunk = false;
    protected boolean endChunk = false;
    protected byte[] chunkBuffer = null;
    protected int chunkLength = 0;
    protected int chunkPos = 0;
    protected boolean http11 = false;

    public HttpRequestStream(HttpRequestImpl httpRequestImpl, HttpResponseImpl httpResponseImpl) {
        super(httpRequestImpl);
        String string = httpRequestImpl.getHeader("Transfer-Encoding");
        this.http11 = httpRequestImpl.getProtocol().equals("HTTP/1.1");
        boolean bl = this.chunk = string != null && string.indexOf("chunked") != -1;
        if (!this.chunk && this.length == -1) {
            httpResponseImpl.addHeader("Connection", "close");
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("requestStream.close.closed"));
        }
        if (this.chunk) {
            int n;
            while (!this.endChunk && (n = this.read()) >= 0) {
            }
        } else if (this.http11 && this.length > 0) {
            int n;
            while (this.count < this.length && (n = this.read()) >= 0) {
            }
        }
        this.closed = true;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("requestStream.read.closed"));
        }
        if (this.chunk) {
            if (this.endChunk) {
                return -1;
            }
            if (!(this.chunkBuffer != null && this.chunkPos < this.chunkLength || this.fillChunkBuffer())) {
                return -1;
            }
            return this.chunkBuffer[this.chunkPos++] & 0xFF;
        }
        return super.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.chunk) {
            int n3 = this.chunkLength - this.chunkPos;
            if (n3 == 0) {
                this.fillChunkBuffer();
            }
            if ((n3 = this.chunkLength - this.chunkPos) == 0) {
                return -1;
            }
            int n4 = n3;
            if (n3 > n2) {
                n4 = n2;
            }
            System.arraycopy(this.chunkBuffer, this.chunkPos, byArray, n, n4);
            this.chunkPos += n4;
            return n4;
        }
        return super.read(byArray, n, n2);
    }

    private synchronized boolean fillChunkBuffer() throws IOException {
        String string;
        this.chunkPos = 0;
        try {
            string = this.readLineFromStream();
            if (string != null) {
                string = string.trim();
            }
            this.chunkLength = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            this.chunkLength = 0;
            this.chunk = false;
            this.close();
            return false;
        }
        if (this.chunkLength == 0) {
            string = this.readLineFromStream();
            while (!string.equals("")) {
                string = this.readLineFromStream();
            }
            this.endChunk = true;
            return false;
        }
        if (this.chunkBuffer == null || this.chunkLength > this.chunkBuffer.length) {
            this.chunkBuffer = new byte[this.chunkLength];
        }
        int n = 0;
        for (int i = 0; i < this.chunkLength; i += n) {
            try {
                n = this.stream.read(this.chunkBuffer, i, this.chunkLength - i);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new IOException();
            }
            if (n >= 0) continue;
            throw new IOException(sm.getString("requestStream.read.error"));
        }
        String string2 = this.readLineFromStream();
        return true;
    }

    private String readLineFromStream() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = super.read()) < 0) {
                if (stringBuffer.length() != 0) break;
                return null;
            }
            if (n == 13) continue;
            if (n == 10) break;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }
}

