/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

final class HttpRequestLine {
    public static final int INITIAL_METHOD_SIZE = 8;
    public static final int INITIAL_URI_SIZE = 64;
    public static final int INITIAL_PROTOCOL_SIZE = 8;
    public static final int MAX_METHOD_SIZE = 1024;
    public static final int MAX_URI_SIZE = 32768;
    public static final int MAX_PROTOCOL_SIZE = 1024;
    public char[] method;
    public int methodEnd;
    public char[] uri;
    public int uriEnd;
    public char[] protocol;
    public int protocolEnd;

    public HttpRequestLine() {
        this(new char[8], 0, new char[64], 0, new char[8], 0);
    }

    public HttpRequestLine(char[] cArray, int n, char[] cArray2, int n2, char[] cArray3, int n3) {
        this.method = cArray;
        this.methodEnd = n;
        this.uri = cArray2;
        this.uriEnd = n2;
        this.protocol = cArray3;
        this.protocolEnd = n3;
    }

    public void recycle() {
        this.methodEnd = 0;
        this.uriEnd = 0;
        this.protocolEnd = 0;
    }

    public int indexOf(char[] cArray) {
        return this.indexOf(cArray, cArray.length);
    }

    public int indexOf(char[] cArray, int n) {
        char c = cArray[0];
        for (int i = 0; i < this.uriEnd; ++i) {
            if ((i = this.indexOf(c, i)) == -1) {
                return -1;
            }
            if (this.uriEnd - i < n) {
                return -1;
            }
            for (int j = 0; j < n && this.uri[j + i] == cArray[j]; ++j) {
                if (j != n - 1) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string.toCharArray(), string.length());
    }

    public int indexOf(char c, int n) {
        for (int i = n; i < this.uriEnd; ++i) {
            if (this.uri[i] != c) continue;
            return i;
        }
        return -1;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object object) {
        return false;
    }
}

