/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.connector.http.DefaultHeaders;
import org.apache.catalina.connector.http.HttpConnector;
import org.apache.catalina.connector.http.HttpHeader;
import org.apache.catalina.connector.http.HttpRequestImpl;
import org.apache.catalina.connector.http.HttpRequestLine;
import org.apache.catalina.connector.http.HttpResponseImpl;
import org.apache.catalina.connector.http.SocketInputStream;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.util.StringParser;

final class HttpProcessor
implements Lifecycle,
Runnable {
    private boolean available = false;
    private HttpConnector connector = null;
    private int debug = 0;
    private int id = 0;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private static final String match = ";jsessionid=";
    private static final char[] SESSION_ID = ";jsessionid=".toCharArray();
    private StringParser parser = new StringParser();
    private String proxyName = null;
    private int proxyPort = 0;
    private HttpRequestImpl request = null;
    private HttpResponseImpl response = null;
    private int serverPort = 0;
    protected StringManager sm = StringManager.getManager("org.apache.catalina.connector.http");
    private Socket socket = null;
    private boolean started = false;
    private boolean stopped = false;
    private Thread thread = null;
    private String threadName = null;
    private Object threadSync = new Object();
    private boolean keepAlive = false;
    private boolean http11 = true;
    private boolean sendAck = false;
    private static final byte[] ack = new String("HTTP/1.1 100 Continue\r\n\r\n").getBytes();
    private static final byte[] CRLF = new String("\r\n").getBytes();
    private HttpRequestLine requestLine = new HttpRequestLine();
    private int status = 0;

    public HttpProcessor(HttpConnector httpConnector, int n) {
        this.connector = httpConnector;
        this.debug = httpConnector.getDebug();
        this.id = n;
        this.proxyName = httpConnector.getProxyName();
        this.proxyPort = httpConnector.getProxyPort();
        this.request = (HttpRequestImpl)httpConnector.createRequest();
        this.response = (HttpResponseImpl)httpConnector.createResponse();
        this.serverPort = httpConnector.getPort();
        this.threadName = "HttpProcessor[" + httpConnector.getPort() + "][" + n + "]";
    }

    public String toString() {
        return this.threadName;
    }

    synchronized void assign(Socket socket) {
        while (this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.socket = socket;
        this.available = true;
        this.notifyAll();
        if (this.debug >= 1 && socket != null) {
            this.log(" An incoming request is being assigned");
        }
    }

    private synchronized Socket await() {
        while (!this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        Socket socket = this.socket;
        this.available = false;
        this.notifyAll();
        if (this.debug >= 1 && socket != null) {
            this.log("  The incoming request has been awaited");
        }
        return socket;
    }

    private void log(String string) {
        Logger logger = this.connector.getContainer().getLogger();
        if (logger != null) {
            logger.log(this.threadName + " " + string);
        }
    }

    private void log(String string, Throwable throwable) {
        Logger logger = this.connector.getContainer().getLogger();
        if (logger != null) {
            logger.log(this.threadName + " " + string, throwable);
        }
    }

    private void parseAcceptLanguage(String string) {
        int n;
        int n2;
        TreeMap<Object, ArrayList<Locale>> treeMap = new TreeMap<Object, ArrayList<Locale>>();
        int n3 = string.indexOf(32);
        if (n3 < 0) {
            n3 = string.indexOf(9);
        }
        if (n3 >= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            n2 = string.length();
            for (n = 0; n < n2; ++n) {
                char c = string.charAt(n);
                if (c == ' ' || c == '\t') continue;
                stringBuffer.append(c);
            }
            string = stringBuffer.toString();
        }
        this.parser.setString(string);
        int n4 = this.parser.getLength();
        while ((n2 = this.parser.getIndex()) < n4) {
            Object object;
            n = this.parser.findChar(',');
            String string2 = this.parser.extract(n2, n).trim();
            this.parser.advance();
            double d = 1.0;
            int n5 = string2.indexOf(";q=");
            if (n5 >= 0) {
                try {
                    d = Double.parseDouble(string2.substring(n5 + 3));
                }
                catch (NumberFormatException numberFormatException) {
                    d = 0.0;
                }
                string2 = string2.substring(0, n5);
            }
            if (d < 5.0E-5 || "*".equals(string2)) continue;
            String string3 = null;
            Object object2 = null;
            String string4 = null;
            int n6 = string2.indexOf(45);
            if (n6 < 0) {
                string3 = string2;
                object2 = "";
                string4 = "";
            } else {
                string3 = string2.substring(0, n6);
                object2 = string2.substring(n6 + 1);
                int n7 = ((String)object2).indexOf(45);
                if (n7 > 0) {
                    object = ((String)object2).substring(0, n7);
                    string4 = ((String)object2).substring(n7 + 1);
                    object2 = object;
                } else {
                    string4 = "";
                }
            }
            Locale locale = new Locale(string3, (String)object2, string4);
            object = new Double(-d);
            ArrayList<Locale> arrayList = (ArrayList<Locale>)treeMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<Locale>();
                treeMap.put(object, arrayList);
            }
            arrayList.add(locale);
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            Double d = (Double)iterator.next();
            ArrayList arrayList = (ArrayList)treeMap.get(d);
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                Locale locale = (Locale)iterator2.next();
                if (this.debug >= 1) {
                    this.log(" Adding locale '" + locale + "'");
                }
                this.request.addLocale(locale);
            }
        }
    }

    private void parseConnection(Socket socket) throws IOException, ServletException {
        if (this.debug >= 2) {
            this.log("  parseConnection: address=" + socket.getInetAddress() + ", port=" + this.connector.getPort());
        }
        this.request.setInet(socket.getInetAddress());
        if (this.proxyPort != 0) {
            this.request.setServerPort(this.proxyPort);
        } else {
            this.request.setServerPort(this.serverPort);
        }
        this.request.setSocket(socket);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseHeaders(SocketInputStream socketInputStream) throws IOException, ServletException {
        while (true) {
            int n;
            HttpHeader httpHeader = this.request.allocateHeader();
            socketInputStream.readHeader(httpHeader);
            if (httpHeader.nameEnd == 0) {
                if (httpHeader.valueEnd != 0) throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.colon"));
                return;
            }
            String string = new String(httpHeader.value, 0, httpHeader.valueEnd);
            if (this.debug >= 1) {
                this.log(" Header " + new String(httpHeader.name, 0, httpHeader.nameEnd) + " = " + string);
            }
            if (httpHeader.equals(DefaultHeaders.AUTHORIZATION_NAME)) {
                this.request.setAuthorization(string);
            } else if (httpHeader.equals(DefaultHeaders.ACCEPT_LANGUAGE_NAME)) {
                this.parseAcceptLanguage(string);
            } else if (httpHeader.equals(DefaultHeaders.COOKIE_NAME)) {
                Cookie[] cookieArray = RequestUtil.parseCookieHeader(string);
                for (n = 0; n < cookieArray.length; ++n) {
                    if (cookieArray[n].getName().equals("JSESSIONID") && !this.request.isRequestedSessionIdFromCookie()) {
                        this.request.setRequestedSessionId(cookieArray[n].getValue());
                        this.request.setRequestedSessionCookie(true);
                        this.request.setRequestedSessionURL(false);
                        if (this.debug >= 1) {
                            this.log(" Requested cookie session id is " + ((HttpServletRequest)this.request.getRequest()).getRequestedSessionId());
                        }
                    }
                    if (this.debug >= 1) {
                        this.log(" Adding cookie " + cookieArray[n].getName() + "=" + cookieArray[n].getValue());
                    }
                    this.request.addCookie(cookieArray[n]);
                }
            } else if (httpHeader.equals(DefaultHeaders.CONTENT_LENGTH_NAME)) {
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.contentLength"));
                }
                this.request.setContentLength(n2);
            } else if (httpHeader.equals(DefaultHeaders.CONTENT_TYPE_NAME)) {
                this.request.setContentType(string);
            } else if (httpHeader.equals(DefaultHeaders.HOST_NAME)) {
                int n3 = string.indexOf(58);
                if (n3 < 0) {
                    if (this.connector.getScheme().equals("http")) {
                        this.request.setServerPort(80);
                    } else if (this.connector.getScheme().equals("https")) {
                        this.request.setServerPort(443);
                    }
                    if (this.proxyName != null) {
                        this.request.setServerName(this.proxyName);
                    } else {
                        this.request.setServerName(string);
                    }
                } else {
                    if (this.proxyName != null) {
                        this.request.setServerName(this.proxyName);
                    } else {
                        this.request.setServerName(string.substring(0, n3).trim());
                    }
                    if (this.proxyPort != 0) {
                        this.request.setServerPort(this.proxyPort);
                    } else {
                        n = 80;
                        try {
                            n = Integer.parseInt(string.substring(n3 + 1).trim());
                        }
                        catch (Exception exception) {
                            throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.portNumber"));
                        }
                        this.request.setServerPort(n);
                    }
                }
            } else if (httpHeader.equals(DefaultHeaders.CONNECTION_NAME)) {
                if (httpHeader.valueEquals(DefaultHeaders.CONNECTION_CLOSE_VALUE)) {
                    this.keepAlive = false;
                    this.response.setHeader("Connection", "close");
                }
            } else if (httpHeader.equals(DefaultHeaders.EXPECT_NAME)) {
                if (!httpHeader.valueEquals(DefaultHeaders.EXPECT_100_VALUE)) throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.unknownExpectation"));
                this.sendAck = true;
            } else if (httpHeader.equals(DefaultHeaders.TRANSFER_ENCODING_NAME)) {
                // empty if block
            }
            this.request.nextHeader();
        }
    }

    private void parseRequest(SocketInputStream socketInputStream, OutputStream outputStream) throws IOException, ServletException {
        String string;
        int n;
        socketInputStream.readRequestLine(this.requestLine);
        this.status = 1;
        String string2 = new String(this.requestLine.method, 0, this.requestLine.methodEnd);
        String string3 = null;
        String string4 = new String(this.requestLine.protocol, 0, this.requestLine.protocolEnd);
        if (string4.length() == 0) {
            string4 = "HTTP/0.9";
        }
        if (string4.equals("HTTP/1.1")) {
            this.http11 = true;
            this.sendAck = false;
        } else {
            this.http11 = false;
            this.sendAck = false;
            this.keepAlive = false;
        }
        if (string2.length() < 1) {
            throw new ServletException(this.sm.getString("httpProcessor.parseRequest.method"));
        }
        if (this.requestLine.uriEnd < 1) {
            throw new ServletException(this.sm.getString("httpProcessor.parseRequest.uri"));
        }
        int n2 = this.requestLine.indexOf("?");
        if (n2 >= 0) {
            this.request.setQueryString(new String(this.requestLine.uri, n2 + 1, this.requestLine.uriEnd - n2 - 1));
            if (this.debug >= 1) {
                this.log(" Query string is " + ((HttpServletRequest)this.request.getRequest()).getQueryString());
            }
            string3 = new String(this.requestLine.uri, 0, n2);
        } else {
            this.request.setQueryString(null);
            string3 = new String(this.requestLine.uri, 0, this.requestLine.uriEnd);
        }
        if (!string3.startsWith("/") && (n = string3.indexOf("://")) != -1) {
            string3 = (n = string3.indexOf(47, n + 3)) == -1 ? "" : string3.substring(n);
        }
        if ((n = string3.indexOf(match)) >= 0) {
            string = string3.substring(n + match.length());
            int n3 = string.indexOf(59);
            if (n3 >= 0) {
                this.request.setRequestedSessionId(string.substring(0, n3));
                string = string.substring(n3);
            } else {
                this.request.setRequestedSessionId(string);
                string = "";
            }
            this.request.setRequestedSessionURL(true);
            string3 = string3.substring(0, n) + string;
            if (this.debug >= 1) {
                this.log(" Requested URL session id is " + ((HttpServletRequest)this.request.getRequest()).getRequestedSessionId());
            }
        } else {
            this.request.setRequestedSessionId(null);
            this.request.setRequestedSessionURL(false);
        }
        string = this.normalize(string3);
        if (this.debug >= 1) {
            this.log("Normalized: '" + string3 + "' to '" + string + "'");
        }
        this.request.setMethod(string2);
        this.request.setProtocol(string4);
        if (string != null) {
            this.request.setRequestURI(string);
        } else {
            this.request.setRequestURI(string3);
        }
        this.request.setSecure(this.connector.getSecure());
        this.request.setScheme(this.connector.getScheme());
        if (string == null) {
            this.log(" Invalid request URI: '" + string3 + "'");
            throw new ServletException("Invalid URI: " + string3 + "'");
        }
        if (this.debug >= 1) {
            this.log(" Request is '" + string2 + "' for '" + string3 + "' with protocol '" + string4 + "'");
        }
    }

    protected String normalize(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2.startsWith("/%7E") || string2.startsWith("/%7e")) {
            string2 = "/~" + string2.substring(4);
        }
        if (string2.indexOf("%25") >= 0 || string2.indexOf("%2F") >= 0 || string2.indexOf("%2E") >= 0 || string2.indexOf("%5C") >= 0 || string2.indexOf("%2f") >= 0 || string2.indexOf("%2e") >= 0 || string2.indexOf("%5c") >= 0) {
            return null;
        }
        if (string2.equals("/.")) {
            return "/";
        }
        if (string2.indexOf(92) >= 0) {
            string2 = string2.replace('\\', '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 2);
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = string2.lastIndexOf(47, n - 1);
            string2 = string2.substring(0, n2) + string2.substring(n + 3);
        }
        if (string2.indexOf("/...") >= 0) {
            return null;
        }
        return string2;
    }

    private void ackRequest(OutputStream outputStream) throws IOException {
        if (this.sendAck) {
            outputStream.write(ack);
        }
    }

    private void process(Socket socket) {
        boolean bl = true;
        boolean bl2 = true;
        SocketInputStream socketInputStream = null;
        OutputStream outputStream = null;
        try {
            socketInputStream = new SocketInputStream(socket.getInputStream(), this.connector.getBufferSize());
        }
        catch (Exception exception) {
            this.log("process.create", exception);
            bl = false;
        }
        this.keepAlive = true;
        while (!this.stopped && bl && this.keepAlive) {
            bl2 = true;
            try {
                this.request.setStream(socketInputStream);
                this.request.setResponse(this.response);
                outputStream = socket.getOutputStream();
                this.response.setStream(outputStream);
                this.response.setRequest(this.request);
                ((HttpServletResponse)this.response.getResponse()).setHeader("Server", "Sun Java System Application Server (HTTP/1.1 Connector)");
            }
            catch (Exception exception) {
                this.log("process.create", exception);
                bl = false;
            }
            try {
                if (bl) {
                    this.parseConnection(socket);
                    this.parseRequest(socketInputStream, outputStream);
                    if (!this.request.getRequest().getProtocol().startsWith("HTTP/0")) {
                        this.parseHeaders(socketInputStream);
                    }
                    if (this.http11) {
                        this.ackRequest(outputStream);
                        if (this.connector.isChunkingAllowed()) {
                            this.response.setAllowChunking(true);
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
                bl = false;
                bl2 = false;
            }
            catch (ServletException servletException) {
                bl = false;
                try {
                    ((HttpServletResponse)this.response.getResponse()).sendError(400);
                }
                catch (Exception exception) {}
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.debug > 1) {
                    try {
                        this.log("process.parse", interruptedIOException);
                        ((HttpServletResponse)this.response.getResponse()).sendError(400);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                bl = false;
            }
            catch (Exception exception) {
                try {
                    this.log("process.parse", exception);
                    ((HttpServletResponse)this.response.getResponse()).sendError(400);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                bl = false;
            }
            try {
                this.response.addDateHeader("Date", System.currentTimeMillis());
                if (bl) {
                    this.connector.getContainer().invoke(this.request, this.response);
                }
            }
            catch (ServletException servletException) {
                this.log("process.invoke", servletException);
                try {
                    ((HttpServletResponse)this.response.getResponse()).sendError(500);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl = false;
            }
            catch (InterruptedIOException interruptedIOException) {
                bl = false;
            }
            catch (Throwable throwable) {
                this.log("process.invoke", throwable);
                try {
                    ((HttpServletResponse)this.response.getResponse()).sendError(500);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl = false;
            }
            try {
                if (bl2) {
                    this.response.finishResponse();
                    this.request.finishRequest();
                    if (outputStream != null) {
                        outputStream.flush();
                    }
                }
            }
            catch (IOException iOException) {
                bl = false;
            }
            catch (Exception exception) {
                this.log("process.finish", exception);
            }
            if ("close".equals(this.response.getHeader("Connection"))) {
                this.keepAlive = false;
            }
            this.status = 0;
            this.request.recycle();
            this.response.recycle();
        }
        try {
            this.shutdownInput(socketInputStream);
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        socket = null;
    }

    protected void shutdownInput(InputStream inputStream) throws IOException {
        try {
            int n = inputStream.available();
            if (n > 0) {
                inputStream.skip(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        while (!this.stopped) {
            object = this.await();
            if (object == null) continue;
            try {
                this.process((Socket)object);
            }
            catch (Throwable throwable) {
                this.log("process", throwable);
            }
            this.connector.recycle(this);
        }
        object = this.threadSync;
        synchronized (object) {
            this.threadSync.notifyAll();
        }
    }

    private void threadStart() {
        this.log(this.sm.getString("httpProcessor.starting"));
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
        if (this.debug >= 1) {
            this.log(" Background thread has been started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadStop() {
        this.log(this.sm.getString("httpProcessor.stopping"));
        this.stopped = true;
        this.assign(null);
        if (this.status != 0) {
            Object object = this.threadSync;
            synchronized (object) {
                try {
                    this.threadSync.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.thread = null;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("httpProcessor.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("httpProcessor.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.threadStop();
    }
}

