/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

final class HttpHeader {
    public static final int INITIAL_NAME_SIZE = 32;
    public static final int INITIAL_VALUE_SIZE = 64;
    public static final int MAX_NAME_SIZE = 128;
    public static final int MAX_VALUE_SIZE = 4096;
    public char[] name;
    public int nameEnd;
    public char[] value;
    public int valueEnd;
    protected int hashCode = 0;

    public HttpHeader() {
        this(new char[32], 0, new char[64], 0);
    }

    public HttpHeader(char[] cArray, int n, char[] cArray2, int n2) {
        this.name = cArray;
        this.nameEnd = n;
        this.value = cArray2;
        this.valueEnd = n2;
    }

    public HttpHeader(String string, String string2) {
        this.name = string.toLowerCase().toCharArray();
        this.nameEnd = string.length();
        this.value = string2.toCharArray();
        this.valueEnd = string2.length();
    }

    public void recycle() {
        this.nameEnd = 0;
        this.valueEnd = 0;
        this.hashCode = 0;
    }

    public boolean equals(char[] cArray) {
        return this.equals(cArray, cArray.length);
    }

    public boolean equals(char[] cArray, int n) {
        if (n != this.nameEnd) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == this.name[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(String string) {
        return this.equals(string.toCharArray(), string.length());
    }

    public boolean valueEquals(char[] cArray) {
        return this.valueEquals(cArray, cArray.length);
    }

    public boolean valueEquals(char[] cArray, int n) {
        if (n != this.valueEnd) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == this.value[i]) continue;
            return false;
        }
        return true;
    }

    public boolean valueEquals(String string) {
        return this.valueEquals(string.toCharArray(), string.length());
    }

    public boolean valueIncludes(char[] cArray) {
        return this.valueIncludes(cArray, cArray.length);
    }

    public boolean valueIncludes(char[] cArray, int n) {
        char c = cArray[0];
        for (int i = 0; i < this.valueEnd; ++i) {
            if ((i = this.valueIndexOf(c, i)) == -1) {
                return false;
            }
            if (this.valueEnd - i < n) {
                return false;
            }
            for (int j = 0; j < n && this.value[j + i] == cArray[j]; ++j) {
                if (j != n - 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean valueIncludes(String string) {
        return this.valueIncludes(string.toCharArray(), string.length());
    }

    public int valueIndexOf(char c, int n) {
        for (int i = n; i < this.valueEnd; ++i) {
            if (this.value[i] != c) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(HttpHeader httpHeader) {
        return this.equals(httpHeader.name, httpHeader.nameEnd);
    }

    public boolean headerEquals(HttpHeader httpHeader) {
        return this.equals(httpHeader.name, httpHeader.nameEnd) && this.valueEquals(httpHeader.value, httpHeader.valueEnd);
    }

    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            int n2 = 0;
            char[] cArray = this.name;
            int n3 = this.nameEnd;
            for (int i = 0; i < n3; ++i) {
                n = 31 * n + cArray[n2++];
            }
            this.hashCode = n;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof String) {
            return this.equals(((String)object).toLowerCase());
        }
        if (object instanceof HttpHeader) {
            return this.equals((HttpHeader)object);
        }
        return false;
    }
}

