/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.RequestStream;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

public abstract class RequestBase
implements ServletRequest,
Request {
    protected HashMap attributes = new HashMap();
    protected String authorization = null;
    protected String characterEncoding = null;
    protected Connector connector = null;
    protected int contentLength = -1;
    protected String contentType = null;
    protected Context context = null;
    protected static Locale defaultLocale = Locale.getDefault();
    protected RequestFacade facade = new RequestFacade(this);
    protected static final String info = "org.apache.catalina.connector.RequestBase/1.0";
    protected InputStream input = null;
    protected ArrayList locales = new ArrayList();
    private transient HashMap notes = new HashMap();
    protected String protocol = null;
    protected BufferedReader reader = null;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected Response response = null;
    protected String scheme = null;
    protected boolean secure = false;
    protected String serverName = null;
    protected int serverPort = -1;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected Socket socket = null;
    protected ServletInputStream stream = null;
    protected Wrapper wrapper = null;
    private int dispatchDepth = 0;
    private static int maxDispatchDepth = 30;

    public String getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(String string) {
        this.authorization = string;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getInfo() {
        return info;
    }

    public ServletRequest getRequest() {
        return this.facade;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public InputStream getStream() {
        return this.input;
    }

    public void setStream(InputStream inputStream) {
        this.input = inputStream;
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocale(Locale locale) {
        ArrayList arrayList = this.locales;
        synchronized (arrayList) {
            this.locales.add(locale);
        }
    }

    public ServletInputStream createInputStream() throws IOException {
        return new RequestStream(this);
    }

    public void finishRequest() throws IOException {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNote(String string) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            return this.notes.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getNoteNames() {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            return this.notes.keySet().iterator();
        }
    }

    public void recycle() {
        this.attributes.clear();
        this.authorization = null;
        this.characterEncoding = null;
        this.contentLength = -1;
        this.contentType = null;
        this.context = null;
        this.input = null;
        this.locales.clear();
        this.notes.clear();
        this.protocol = null;
        this.reader = null;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.response = null;
        this.scheme = null;
        this.secure = false;
        this.serverName = null;
        this.serverPort = -1;
        this.socket = null;
        this.stream = null;
        this.wrapper = null;
        this.dispatchDepth = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNote(String string) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            this.notes.remove(string);
        }
    }

    public void setContentLength(int n) {
        this.contentLength = n;
    }

    public void setContentType(String string) {
        this.contentType = string;
        if (string.indexOf(59) >= 0) {
            this.characterEncoding = RequestUtil.parseCharacterEncoding(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNote(String string, Object object) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            this.notes.put(string, object);
        }
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public void setRemoteAddr(String string) {
        this.remoteAddr = string;
    }

    public void setRemoteHost(String string) {
        this.remoteHost = string;
    }

    public void setScheme(String string) {
        this.scheme = string;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setServerPort(int n) {
        this.serverPort = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String string) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return new Enumerator(new ArrayList(this.attributes.keySet()));
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.reader != null) {
            throw new IllegalStateException(sm.getString("requestBase.getInputStream.ise"));
        }
        if (this.stream == null) {
            this.stream = this.createInputStream();
        }
        return this.stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getLocale() {
        ArrayList arrayList = this.locales;
        synchronized (arrayList) {
            if (this.locales.size() > 0) {
                return (Locale)this.locales.get(0);
            }
            return defaultLocale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getLocales() {
        ArrayList<Locale> arrayList = this.locales;
        synchronized (arrayList) {
            if (this.locales.size() > 0) {
                return new Enumerator(this.locales);
            }
        }
        arrayList = new ArrayList<Locale>();
        arrayList.add(defaultLocale);
        return new Enumerator(arrayList);
    }

    public abstract String getParameter(String var1);

    public abstract Map getParameterMap();

    public abstract Enumeration getParameterNames();

    public abstract String[] getParameterValues(String var1);

    public String getProtocol() {
        return this.protocol;
    }

    public BufferedReader getReader() throws IOException {
        if (this.stream != null) {
            throw new IllegalStateException(sm.getString("requestBase.getReader.ise"));
        }
        if (this.reader == null) {
            String string = this.getCharacterEncoding();
            if (string == null) {
                string = "ISO-8859-1";
            }
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this.createInputStream(), string);
            this.reader = new BufferedReader(inputStreamReader);
        }
        return this.reader;
    }

    public String getRealPath(String string) {
        if (this.context == null) {
            return null;
        }
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext == null) {
            return null;
        }
        try {
            return servletContext.getRealPath(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public abstract RequestDispatcher getRequestDispatcher(String var1);

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isSecure() {
        return this.secure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String string) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("requestBase.setAttribute.namenull"));
        }
        if (object == null) {
            this.removeAttribute(string);
            return;
        }
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.put(string, object);
        }
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        byte[] byArray = new byte[]{97};
        String string2 = new String(byArray, string);
        this.characterEncoding = string;
    }

    public static void setMaxDispatchDepth(int n) {
        maxDispatchDepth = n;
    }

    public int incrementDispatchDepth() {
        return ++this.dispatchDepth;
    }

    public int decrementDispatchDepth() {
        return --this.dispatchDepth;
    }

    public boolean isMaxDispatchDepthReached() {
        return this.dispatchDepth > maxDispatchDepth;
    }
}

