/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.connector.HttpResponseFacade;
import org.apache.catalina.connector.ResponseBase;
import org.apache.catalina.util.CookieTools;
import org.apache.catalina.util.URL;

public class HttpResponseBase
extends ResponseBase
implements HttpResponse,
HttpServletResponse {
    protected ArrayList cookies = new ArrayList();
    protected SimpleDateFormat format = null;
    protected HttpResponseFacade facade = new HttpResponseFacade(this);
    protected HashMap headers = new HashMap();
    protected static final String info = "org.apache.catalina.connector.HttpResponseBase/1.0";
    protected String message = this.getStatusMessage(200);
    protected int status = 200;
    protected static final TimeZone zone = TimeZone.getTimeZone("GMT");

    public ServletResponse getResponse() {
        return this.facade;
    }

    public void finishResponse() throws IOException {
        if (!this.isCommitted() && this.stream == null && this.writer == null && this.status >= 400 && this.contentType == null && this.contentCount == 0) {
            try {
                this.setContentType("text/html");
                PrintWriter printWriter = this.getWriter();
                printWriter.println("<html>");
                printWriter.println("<head>");
                printWriter.println("<title>Tomcat Error Report</title>");
                printWriter.println("<br><br>");
                printWriter.println("<h1>HTTP Status ");
                printWriter.print(this.status);
                printWriter.print(" - ");
                if (this.message != null) {
                    printWriter.print(this.message);
                } else {
                    printWriter.print(this.getStatusMessage(this.status));
                }
                printWriter.println("</h1>");
                printWriter.println("</body>");
                printWriter.println("</html>");
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.sendHeaders();
        super.finishResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookie[] getCookies() {
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            return this.cookies.toArray(new Cookie[this.cookies.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeader(String string) {
        ArrayList arrayList = null;
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            arrayList = (ArrayList)this.headers.get(string);
        }
        if (arrayList != null) {
            return (String)arrayList.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHeaderNames() {
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            String[] stringArray = new String[this.headers.size()];
            return this.headers.keySet().toArray(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHeaderValues(String string) {
        ArrayList arrayList = null;
        String[] stringArray = this.headers;
        synchronized (this.headers) {
            arrayList = (ArrayList)this.headers.get(string);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (arrayList == null) {
                return new String[0];
            }
            stringArray = new String[arrayList.size()];
            return arrayList.toArray(stringArray);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatus() {
        return this.status;
    }

    public void recycle() {
        super.recycle();
        this.cookies.clear();
        this.headers.clear();
        this.message = this.getStatusMessage(200);
        this.status = 200;
    }

    public void reset(int n, String string) {
        this.reset();
        this.setStatus(n, string);
    }

    protected String getStatusMessage(int n) {
        switch (n) {
            case 200: {
                return "OK";
            }
            case 202: {
                return "Accepted";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 400: {
                return "Bad Request";
            }
            case 409: {
                return "Conflict";
            }
            case 100: {
                return "Continue";
            }
            case 201: {
                return "Created";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 403: {
                return "Forbidden";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 410: {
                return "Gone";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 411: {
                return "Length Required";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 204: {
                return "No Content";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 404: {
                return "Not Found";
            }
            case 501: {
                return "Not Implemented";
            }
            case 304: {
                return "Not Modified";
            }
            case 206: {
                return "Partial Content";
            }
            case 402: {
                return "Payment Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 408: {
                return "Request Timeout";
            }
            case 414: {
                return "Request URI Too Long";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 205: {
                return "Reset Content";
            }
            case 303: {
                return "See Other";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 401: {
                return "Unauthorized";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 305: {
                return "Use Proxy";
            }
            case 207: {
                return "Multi-Status";
            }
            case 422: {
                return "Unprocessable Entity";
            }
            case 423: {
                return "Locked";
            }
            case 507: {
                return "Insufficient Storage";
            }
        }
        return "HTTP Response Status " + n;
    }

    private boolean isEncodeable(String string) {
        int n;
        if (string == null) {
            return false;
        }
        if (string.startsWith("#")) {
            return false;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.request.getRequest();
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return false;
        }
        if (httpServletRequest.isRequestedSessionIdFromCookie()) {
            return false;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        if (!httpServletRequest.getScheme().equalsIgnoreCase(uRL.getProtocol())) {
            return false;
        }
        if (!httpServletRequest.getServerName().equalsIgnoreCase(uRL.getHost())) {
            return false;
        }
        int n2 = httpServletRequest.getServerPort();
        if (n2 == -1) {
            n2 = "https".equals(httpServletRequest.getScheme()) ? 443 : 80;
        }
        if ((n = uRL.getPort()) == -1) {
            n = "https".equals(uRL.getProtocol()) ? 443 : 80;
        }
        if (n2 != n) {
            return false;
        }
        String string2 = this.getContext().getPath();
        if (string2 != null && string2.length() > 0) {
            String string3 = uRL.getFile();
            if (string3 == null || !string3.startsWith(string2)) {
                return false;
            }
            if (string3.indexOf(";jsessionid=" + httpSession.getId()) >= 0) {
                return false;
            }
        }
        return true;
    }

    private void log(String string) {
        Logger logger = this.context.getLogger();
        logger.log(string);
    }

    private void log(String string, Throwable throwable) {
        Logger logger = this.context.getLogger();
        logger.log(string, throwable);
    }

    protected String getProtocol() {
        return this.request.getRequest().getProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendHeaders() throws IOException {
        Cookie cookie;
        Object object;
        Object object2;
        HttpSession httpSession;
        if (this.isCommitted()) {
            return;
        }
        if ("HTTP/0.9".equals(this.request.getRequest().getProtocol())) {
            this.committed = true;
            return;
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(this.getStream(), this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            outputStreamWriter = new OutputStreamWriter(this.getStream());
        }
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.print(this.getProtocol());
        printWriter.print(" ");
        printWriter.print(this.status);
        if (this.message != null) {
            printWriter.print(" ");
            printWriter.print(this.message);
        }
        printWriter.print("\r\n");
        if (this.getContentType() != null) {
            printWriter.print("Content-Type: " + this.getContentType() + "\r\n");
        }
        if (this.getContentLength() >= 0) {
            printWriter.print("Content-Length: " + this.getContentLength() + "\r\n");
        }
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            httpSession = this.headers.keySet().iterator();
            while (httpSession.hasNext()) {
                object2 = (String)httpSession.next();
                object = (ArrayList)this.headers.get(object2);
                cookie = ((ArrayList)object).iterator();
                while (cookie.hasNext()) {
                    String string = (String)cookie.next();
                    printWriter.print((String)object2);
                    printWriter.print(": ");
                    printWriter.print(string);
                    printWriter.print("\r\n");
                }
            }
        }
        hashMap = (HttpServletRequest)this.request.getRequest();
        httpSession = hashMap.getSession(false);
        if (httpSession != null && httpSession.isNew() && this.getContext() != null && this.getContext().getCookies()) {
            object2 = new Cookie("JSESSIONID", httpSession.getId());
            object2.setMaxAge(-1);
            object = null;
            if (this.context != null) {
                object = this.context.getPath();
            }
            if (object != null && ((String)object).length() > 0) {
                object2.setPath((String)object);
            } else {
                object2.setPath("/");
            }
            if (hashMap.isSecure()) {
                object2.setSecure(true);
            }
            this.addCookie((Cookie)object2);
        }
        object2 = this.cookies;
        synchronized (object2) {
            object = this.cookies.iterator();
            while (object.hasNext()) {
                cookie = (Cookie)object.next();
                printWriter.print(CookieTools.getCookieHeaderName(cookie));
                printWriter.print(": ");
                printWriter.print(CookieTools.getCookieHeaderValue(cookie));
                printWriter.print("\r\n");
            }
        }
        printWriter.print("\r\n");
        printWriter.flush();
        this.committed = true;
    }

    private String toAbsolute(String string) {
        if (string == null) {
            return string;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.request.getRequest();
            String string2 = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString();
            try {
                uRL = new URL(new URL(string2), string);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new IllegalArgumentException(string);
            }
        }
        return uRL.toExternalForm();
    }

    private String toEncoded(String string, String string2) {
        StringBuffer stringBuffer;
        int n;
        if (string == null || string2 == null) {
            return string;
        }
        String string3 = string;
        String string4 = "";
        String string5 = "";
        int n2 = string.indexOf(63);
        if (n2 >= 0) {
            string3 = string.substring(0, n2);
            string4 = string.substring(n2);
        }
        if ((n = string3.indexOf(35)) >= 0) {
            string5 = string3.substring(n);
            string3 = string3.substring(0, n);
        }
        if ((stringBuffer = new StringBuffer(string3)).length() > 0) {
            stringBuffer.append(";jsessionid=");
            stringBuffer.append(string2);
        }
        stringBuffer.append(string5);
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }

    public void flushBuffer() throws IOException {
        if (!this.isCommitted()) {
            this.sendHeaders();
        }
        super.flushBuffer();
    }

    public void reset() {
        if (this.included) {
            return;
        }
        super.reset();
        this.cookies.clear();
        this.headers.clear();
        this.message = null;
        this.status = 200;
    }

    public void setContentLength(int n) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        super.setContentLength(n);
    }

    public void setContentType(String string) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        super.setContentType(string);
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        super.setLocale(locale);
        String string = locale.getLanguage();
        if (string != null && string.length() > 0) {
            String string2 = locale.getCountry();
            StringBuffer stringBuffer = new StringBuffer(string);
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append('-');
                stringBuffer.append(string2);
            }
            this.setHeader("Content-Language", stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            this.cookies.add(cookie);
        }
    }

    public void addDateHeader(String string, long l) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.addHeader(string, this.format.format(new Date(l)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String string, String string2) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList<String> arrayList = (ArrayList<String>)this.headers.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                this.headers.put(string, arrayList);
            }
            arrayList.add(string2);
        }
    }

    public void addIntHeader(String string, int n) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(string, "" + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsHeader(String string) {
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            return this.headers.get(string) != null;
        }
    }

    public String encodeRedirectURL(String string) {
        if (this.isEncodeable(this.toAbsolute(string))) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.request.getRequest();
            return this.toEncoded(string, httpServletRequest.getSession().getId());
        }
        return string;
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }

    public String encodeURL(String string) {
        if (this.isEncodeable(this.toAbsolute(string))) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.request.getRequest();
            return this.toEncoded(string, httpServletRequest.getSession().getId());
        }
        return string;
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public void sendError(int n) throws IOException {
        this.sendError(n, this.getStatusMessage(n));
    }

    public void sendError(int n, String string) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("httpResponseBase.sendError.ise"));
        }
        if (this.included) {
            return;
        }
        this.setError();
        this.status = n;
        this.message = string;
        this.resetBuffer();
        this.setSuspended(true);
    }

    public void sendRedirect(String string) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("httpResponseBase.sendRedirect.ise"));
        }
        if (this.included) {
            return;
        }
        this.resetBuffer();
        try {
            String string2 = this.getContext().getAllowRelativeRedirect() ? string : this.toAbsolute(string);
            this.setStatus(302);
            this.setHeader("Location", string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setStatus(404);
        }
        this.setSuspended(true);
    }

    public void setDateHeader(String string, long l) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.setHeader(string, this.format.format(new Date(l)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String string, String string2) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        Object object = this.headers;
        synchronized (object) {
            this.headers.put(string, arrayList);
        }
        object = string.toLowerCase();
        if (((String)object).equals("content-length")) {
            int n = -1;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n >= 0) {
                this.setContentLength(n);
            }
        } else if (((String)object).equals("content-type")) {
            this.setContentType(string2);
        }
    }

    public void setIntHeader(String string, int n) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(string, "" + n);
    }

    public void setStatus(int n) {
        this.setStatus(n, this.getStatusMessage(n));
    }

    public void setStatus(int n, String string) {
        if (this.included) {
            return;
        }
        this.status = n;
        this.message = string;
    }
}

