/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.SecurityPermission;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.session.StandardSessionFacade;

public final class HttpRequestFacade
extends RequestFacade
implements HttpServletRequest {
    public HttpRequestFacade(HttpRequest httpRequest) {
        super(httpRequest);
    }

    public String getAuthType() {
        return ((HttpServletRequest)this.request).getAuthType();
    }

    public Cookie[] getCookies() {
        return ((HttpServletRequest)this.request).getCookies();
    }

    public long getDateHeader(String string) {
        return ((HttpServletRequest)this.request).getDateHeader(string);
    }

    public String getHeader(String string) {
        return ((HttpServletRequest)this.request).getHeader(string);
    }

    public Enumeration getHeaders(String string) {
        return ((HttpServletRequest)this.request).getHeaders(string);
    }

    public Enumeration getHeaderNames() {
        return ((HttpServletRequest)this.request).getHeaderNames();
    }

    public int getIntHeader(String string) {
        return ((HttpServletRequest)this.request).getIntHeader(string);
    }

    public String getMethod() {
        return ((HttpServletRequest)this.request).getMethod();
    }

    public String getPathInfo() {
        return ((HttpServletRequest)this.request).getPathInfo();
    }

    public String getPathTranslated() {
        return ((HttpServletRequest)this.request).getPathTranslated();
    }

    public String getContextPath() {
        return ((HttpServletRequest)this.request).getContextPath();
    }

    public String getQueryString() {
        return ((HttpServletRequest)this.request).getQueryString();
    }

    public String getRemoteUser() {
        return ((HttpServletRequest)this.request).getRemoteUser();
    }

    public boolean isUserInRole(String string) {
        return ((HttpServletRequest)this.request).isUserInRole(string);
    }

    public Principal getUserPrincipal() {
        return ((HttpServletRequest)this.request).getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return ((HttpServletRequest)this.request).getRequestedSessionId();
    }

    public String getRequestURI() {
        return ((HttpServletRequest)this.request).getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return ((HttpServletRequest)this.request).getRequestURL();
    }

    public String getServletPath() {
        return ((HttpServletRequest)this.request).getServletPath();
    }

    public HttpSession getSession(boolean bl) {
        HttpSession httpSession = ((HttpServletRequest)this.request).getSession(bl);
        if (httpSession == null) {
            return null;
        }
        return new StandardSessionFacade(httpSession);
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        return ((HttpServletRequest)this.request).isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return ((HttpServletRequest)this.request).isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return ((HttpServletRequest)this.request).isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return ((HttpServletRequest)this.request).isRequestedSessionIdFromURL();
    }

    public HttpRequestBase getHttpRequestBase() throws AccessControlException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            SecurityPermission securityPermission = new SecurityPermission("getHttpRequestBase");
            AccessController.checkPermission(securityPermission);
        }
        return (HttpRequestBase)this.request;
    }
}

