/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class SingleSignOn
extends ValveBase
implements Lifecycle,
SessionListener,
Runnable {
    protected HashMap cache = new HashMap();
    protected int debug = 0;
    protected static String info = "org.apache.catalina.authenticator.SingleSignOn";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected HashMap reverse = new HashMap();
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.authenticator");
    protected boolean started = false;
    private Thread thread = null;
    private boolean threadDone = false;
    private int ssoReapInterval = 60;
    private int ssoMaxInactive = 300;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public int getReapInterval() {
        return this.ssoReapInterval;
    }

    public void setReapInterval(int n) {
        this.ssoReapInterval = n;
    }

    public int getMaxInactive() {
        return this.ssoMaxInactive;
    }

    public void setMaxInactive(int n) {
        this.ssoMaxInactive = n;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
        if (this.debug >= 1) {
            this.log("Started");
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("authenticator.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.threadStop();
        if (this.debug >= 1) {
            this.log("Stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEvent(SessionEvent sessionEvent) {
        if (!"destroySession".equals(sessionEvent.getType())) {
            return;
        }
        Session session = sessionEvent.getSession();
        if (this.debug >= 1) {
            this.log("Process session destroyed on " + session);
        }
        String string = null;
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            string = (String)this.reverse.get(session);
        }
        if (string == null) {
            return;
        }
        this.deregister(string);
    }

    public String getInfo() {
        return info;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry singleSignOnEntry;
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            return 1;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        if (this.debug >= 1) {
            this.log("Process request for '" + httpServletRequest.getRequestURI() + "'");
        }
        if (httpServletRequest.getUserPrincipal() != null) {
            if (this.debug >= 1) {
                this.log(" Principal '" + httpServletRequest.getUserPrincipal().getName() + "' has already been authenticated");
            }
            return 1;
        }
        if (this.debug >= 1) {
            this.log(" Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null) {
            cookieArray = new Cookie[]{};
        }
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!"JSESSIONIDSSO".equals(cookieArray[i].getName())) continue;
            cookie = cookieArray[i];
            break;
        }
        if (cookie == null) {
            if (this.debug >= 1) {
                this.log(" SSO cookie is not present");
            }
            return 1;
        }
        if (this.debug >= 1) {
            this.log(" Checking for cached principal for " + cookie.getValue());
        }
        if ((singleSignOnEntry = this.lookup(cookie.getValue())) != null) {
            if (this.debug >= 1) {
                this.log(" Found cached principal '" + singleSignOnEntry.principal.getName() + "' with auth type '" + singleSignOnEntry.authType + "'");
            }
            request.setNote("org.apache.catalina.request.SSOID", cookie.getValue());
            ((HttpRequest)request).setAuthType(singleSignOnEntry.authType);
            ((HttpRequest)request).setUserPrincipal(singleSignOnEntry.principal);
            singleSignOnEntry.lastAccessTime = System.currentTimeMillis();
        } else {
            if (this.debug >= 1) {
                this.log(" No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            cookie.setPath("/");
            httpServletResponse.addCookie(cookie);
        }
        return 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SingleSignOn[");
        stringBuffer.append(this.container.getName());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associate(String string, Session session) {
        SingleSignOnEntry singleSignOnEntry;
        if (this.debug >= 1) {
            this.log("Associate sso id " + string + " with session " + session);
        }
        if ((singleSignOnEntry = this.lookup(string)) != null) {
            singleSignOnEntry.addSession(this, session);
        }
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            this.reverse.put(session, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String string) {
        if (this.debug >= 1) {
            this.log("Deregistering sso id '" + string + "'");
        }
        SingleSignOnEntry singleSignOnEntry = null;
        Session[] sessionArray = this.cache;
        synchronized (this.cache) {
            singleSignOnEntry = (SingleSignOnEntry)this.cache.remove(string);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (singleSignOnEntry == null) {
                return;
            }
            sessionArray = singleSignOnEntry.findSessions();
            for (int i = 0; i < sessionArray.length; ++i) {
                if (this.debug >= 2) {
                    this.log(" Invalidating session " + sessionArray[i]);
                }
                HashMap hashMap = this.reverse;
                synchronized (hashMap) {
                    this.reverse.remove(sessionArray[i]);
                }
                sessionArray[i].expire();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String string, Principal principal, String string2, String string3, String string4) {
        if (this.debug >= 1) {
            this.log("Registering sso id '" + string + "' for user '" + principal.getName() + "' with auth type '" + string2 + "'");
        }
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(string, new SingleSignOnEntry(principal, string2, string3, string4));
        }
    }

    protected void log(String string) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + string);
        } else {
            System.out.println(this.toString() + ": " + string);
        }
    }

    protected void log(String string, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + string, throwable);
        } else {
            System.out.println(this.toString() + ": " + string);
            throwable.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry lookup(String string) {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            return (SingleSignOnEntry)this.cache.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpires() {
        long l = System.currentTimeMillis() - (long)(this.ssoMaxInactive * 1000);
        if (this.debug >= 1) {
            this.log("SSO expiration started. Current entries: " + this.cache.size());
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.cache.size() / 2);
        try {
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                Iterator iterator = this.cache.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    SingleSignOnEntry singleSignOnEntry = (SingleSignOnEntry)this.cache.get(string);
                    if (singleSignOnEntry.sessions.length != 0 || singleSignOnEntry.lastAccessTime >= l) continue;
                    arrayList.add(string);
                }
            }
            int n = arrayList.size();
            if (this.debug >= 1) {
                this.log("SSO cache will expire " + n + " entries.");
            }
            for (int i = 0; i < n; ++i) {
                if (this.debug >= 3) {
                    this.log("SSO expiration removing entry: " + arrayList.get(i));
                }
                this.deregister((String)arrayList.get(i));
            }
        }
        catch (Throwable throwable) {
            Logger logger = this.container.getLogger();
            String string = sm.getString("sso.error");
            if (logger != null) {
                logger.log(string, throwable, 2);
            }
            System.out.println(string);
        }
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.ssoReapInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        String string = "SingleSignOnExpiration";
        this.thread = new Thread((Runnable)this, string);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
        }
    }
}

