/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.MD5Encoder;

public class DigestAuthenticator
extends AuthenticatorBase {
    private static final int USE_ONCE = 1;
    private static final int USE_NEVER_EXPIRES = Integer.MAX_VALUE;
    private static final int TIMEOUT_INFINITE = Integer.MAX_VALUE;
    private static final MD5Encoder md5Encoder = new MD5Encoder();
    private static final String info = "org.apache.catalina.authenticator.DigestAuthenticator/1.0";
    private static MessageDigest md5Helper;
    private Hashtable nOnceTokens = new Hashtable();
    private long nOnceTimeout = Integer.MAX_VALUE;
    private int nOnceUses = 1;
    private String key = "Catalina";

    public DigestAuthenticator() {
        try {
            if (md5Helper == null) {
                md5Helper = MessageDigest.getInstance("MD5");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public String getInfo() {
        return info;
    }

    public boolean authenticate(HttpRequest httpRequest, HttpResponse httpResponse, LoginConfig loginConfig) throws IOException {
        Principal principal = ((HttpServletRequest)httpRequest.getRequest()).getUserPrincipal();
        if (principal != null) {
            return true;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpRequest.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)httpResponse.getResponse();
        String string = httpRequest.getAuthorization();
        if (string != null && (principal = DigestAuthenticator.findPrincipal(httpServletRequest, string, this.context.getRealm())) != null) {
            String string2 = this.parseUsername(string);
            this.register(httpRequest, httpResponse, principal, "DIGEST", string2, null);
            return true;
        }
        String string3 = this.generateNOnce(httpServletRequest);
        this.setAuthenticateHeader(httpServletRequest, httpServletResponse, loginConfig, string3);
        httpServletResponse.setStatus(401);
        return false;
    }

    private static Principal findPrincipal(HttpServletRequest httpServletRequest, String string, Realm realm) {
        String string2;
        if (string == null) {
            return null;
        }
        if (!string.startsWith("Digest ")) {
            return null;
        }
        string = string.substring(7).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        Object var12_12 = null;
        String string11 = httpServletRequest.getMethod();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n < 0) {
                return null;
            }
            String string12 = string2.substring(0, n).trim();
            String string13 = string2.substring(n + 1).trim();
            if ("username".equals(string12)) {
                string3 = DigestAuthenticator.removeQuotes(string13);
            }
            if ("realm".equals(string12)) {
                string4 = DigestAuthenticator.removeQuotes(string13);
            }
            if ("nonce".equals(string12)) {
                string5 = DigestAuthenticator.removeQuotes(string13);
            }
            if ("nc".equals(string12)) {
                string6 = string13;
            }
            if ("cnonce".equals(string12)) {
                string7 = DigestAuthenticator.removeQuotes(string13);
            }
            if ("qop".equals(string12)) {
                string8 = DigestAuthenticator.removeQuotes(string13);
            }
            if ("uri".equals(string12)) {
                string9 = DigestAuthenticator.removeQuotes(string13);
            }
            if (!"response".equals(string12)) continue;
            string10 = DigestAuthenticator.removeQuotes(string13);
        }
        if (string3 == null || string4 == null || string5 == null || string9 == null || string10 == null) {
            return null;
        }
        string2 = string11 + ":" + string9;
        String string14 = md5Encoder.encode(md5Helper.digest(string2.getBytes()));
        return realm.authenticate(string3, string10, string5, string6, string7, string8, string4, string14);
    }

    private String parseUsername(String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("Digest ")) {
            return null;
        }
        string = string.substring(7).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n < 0) {
                return null;
            }
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (!"username".equals(string3)) continue;
            return DigestAuthenticator.removeQuotes(string4);
        }
        return null;
    }

    private static String removeQuotes(String string) {
        if (string.length() > 2) {
            return string.substring(1, string.length() - 1);
        }
        return new String();
    }

    private String generateNOnce(HttpServletRequest httpServletRequest) {
        long l = System.currentTimeMillis();
        String string = httpServletRequest.getRemoteAddr() + ":" + l + ":" + this.key;
        byte[] byArray = md5Helper.digest(string.getBytes());
        string = md5Encoder.encode(byArray);
        this.nOnceTokens.put(string, new Long(l + this.nOnceTimeout));
        return string;
    }

    private void setAuthenticateHeader(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, LoginConfig loginConfig, String string) {
        String string2 = loginConfig.getRealmName();
        if (string2 == null) {
            string2 = httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort();
        }
        byte[] byArray = md5Helper.digest(string.getBytes());
        String string3 = "Digest realm=\"" + string2 + "\", " + "qop=\"auth\", nonce=\"" + string + "\", " + "opaque=\"" + md5Encoder.encode(byArray) + "\"";
        httpServletResponse.setHeader("WWW-Authenticate", string3);
    }
}

