/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.security.SecurityContext;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import com.sun.web.security.WebPrincipal;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transaction;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;

public final class J2EEInstanceListener
implements InstanceListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private InvocationManager im = Switch.getSwitch().getInvocationManager();
    private J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
    private static boolean debug = false;

    public void instanceEvent(InstanceEvent instanceEvent) {
        String string = instanceEvent.getType();
        if (debug && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "*** InstanceEvent: " + string);
        }
        if (string.equals("beforeService") || string.equals("beforeFilter") || string.equals("beforeInit") || string.equals("beforeDestroy") || string.equals("beforeDispatch")) {
            this.handleBeforeEvent(instanceEvent, string);
        } else if (string.equals("afterService") || string.equals("afterFilter") || string.equals("afterInit") || string.equals("afterDestroy") || string.equals("afterDispatch")) {
            this.handleAfterEvent(instanceEvent, string);
        }
    }

    private void handleBeforeEvent(InstanceEvent instanceEvent, String string) {
        HttpServletRequest httpServletRequest;
        Object object;
        Object object2 = null;
        object2 = string.equals("beforeFilter") ? instanceEvent.getFilter() : instanceEvent.getServlet();
        Context context = (Context)instanceEvent.getWrapper().getParent();
        final ClassLoader classLoader = context.getLoader().getClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            }
        });
        RealmAdapter realmAdapter = (RealmAdapter)context.getRealm();
        if (realmAdapter != null && (object = instanceEvent.getRequest()) != null && object instanceof HttpServletRequest && (httpServletRequest = (HttpServletRequest)object).getUserPrincipal() != null) {
            if (httpServletRequest.getUserPrincipal() instanceof WebPrincipal) {
                WebPrincipal webPrincipal = (WebPrincipal)httpServletRequest.getUserPrincipal();
                SecurityContext.setCurrent(webPrincipal.getSecurityContext());
            } else {
                String string2 = System.getProperty("principalOverride");
                if (string2 == null) {
                    _logger.log(Level.INFO, "web_server.info_detect_principal_override");
                }
                string2 = null;
                Principal principal = httpServletRequest.getUserPrincipal();
                SecurityContext.setCurrent(new SecurityContext(principal.getName(), null, null));
            }
        }
        object = new ComponentInvocation(object2, context);
        try {
            this.im.preInvoke((ComponentInvocation)object);
            if (string.equals("beforeDispatch")) {
                httpServletRequest = null;
                httpServletRequest = this.tm.getTransaction();
                if (httpServletRequest != null) {
                    ((ComponentInvocation)object).setTransaction((Transaction)httpServletRequest);
                }
                this.tm.enlistComponentResources();
            }
            if (string.equals("beforeService")) {
                this.tm.enlistComponentResources();
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "web_server.excep_handle_before_event", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleAfterEvent(InstanceEvent instanceEvent, String string) {
        block23: {
            Object object3222;
            if (AppVerification.doInstrument() && (string.equals("afterService") || string.equals("afterDispatch"))) {
                AppVerification.getInstrumentLogger().doInstrumentForWeb(instanceEvent);
            }
            Object object2 = null;
            object2 = string.equals("afterFilter") ? instanceEvent.getFilter() : instanceEvent.getServlet();
            Context context = (Context)instanceEvent.getWrapper().getParent();
            ComponentInvocation componentInvocation = new ComponentInvocation(object2, context);
            this.im.postInvoke(componentInvocation);
            Object var8_6 = null;
            if (string.equals("afterDestroy")) {
                this.tm.componentDestroyed(object2);
            }
            if (!string.equals("afterFilter") && !string.equals("afterService") || this.im.getCurrentInvocation() != null) break block23;
            try {
                object3222 = (RealmAdapter)context.getRealm();
                if (object3222 != null) {
                    ((RealmAdapter)object3222).logout();
                }
            }
            catch (Exception object3222) {
                _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", (Throwable)object3222);
            }
            try {
                if (this.tm.getTransaction() != null) {
                    this.tm.rollback();
                }
                break block23;
            }
            catch (Exception object3222) {}
            break block23;
            {
                catch (Exception exception) {
                    Object object42222;
                    _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", exception);
                    Object var8_7 = null;
                    if (string.equals("afterDestroy")) {
                        this.tm.componentDestroyed(object2);
                    }
                    if (!string.equals("afterFilter") && !string.equals("afterService") || this.im.getCurrentInvocation() != null) break block23;
                    try {
                        object42222 = (RealmAdapter)context.getRealm();
                        if (object42222 != null) {
                            ((RealmAdapter)object42222).logout();
                        }
                    }
                    catch (Exception object42222) {
                        _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", (Throwable)object42222);
                    }
                    try {
                        if (this.tm.getTransaction() != null) {
                            this.tm.rollback();
                        }
                        break block23;
                    }
                    catch (Exception object42222) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (string.equals("afterDestroy")) {
                    this.tm.componentDestroyed(object2);
                }
                if ((string.equals("afterFilter") || string.equals("afterService")) && this.im.getCurrentInvocation() == null) {
                    Object object52222;
                    try {
                        object52222 = (RealmAdapter)context.getRealm();
                        if (object52222 != null) {
                            ((RealmAdapter)object52222).logout();
                        }
                    }
                    catch (Exception object52222) {
                        _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", (Throwable)object52222);
                    }
                    try {
                        if (this.tm.getTransaction() != null) {
                            this.tm.rollback();
                        }
                    }
                    catch (Exception object52222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

