/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.server.J2EEServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManagerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.catalina.net.ServerSocketFactory;

public class SSLSocketFactory
implements ServerSocketFactory {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private static final boolean clientAuth = false;
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SSLSocketFactory.class);
    private SSLContext context = null;
    private SSLServerSocketFactory factory = null;
    private String[] cipherSuites;
    private static SecureRandom sr = J2EEServer.secureRandom;
    private static KeyManagerFactory keyManagerFactory = null;
    private static TrustManagerFactory trustManagerFactory = null;

    public SSLSocketFactory() {
        try {
            if (keyManagerFactory == null || trustManagerFactory == null) {
                SSLUtils.initKeyStore();
            }
            this.context = SSLContext.getInstance((String)"TLS");
            KeyManagerFactory keyManagerFactory = SSLSocketFactory.keyManagerFactory;
            TrustManagerFactory trustManagerFactory = SSLSocketFactory.trustManagerFactory;
            this.context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), sr);
            this.factory = this.context.getServerSocketFactory();
            this.cipherSuites = this.factory.getSupportedCipherSuites();
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "web_security.excep_sslsockfact", exception.getMessage());
        }
    }

    public ServerSocket createSocket(int n) throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n);
        this.init(sSLServerSocket);
        return sSLServerSocket;
    }

    private void init(SSLServerSocket sSLServerSocket) {
        sSLServerSocket.setNeedClientAuth(false);
    }

    public ServerSocket createSocket(int n, int n2) throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n, n2);
        this.init(sSLServerSocket);
        return sSLServerSocket;
    }

    public ServerSocket createSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n, n2, inetAddress);
        this.init(sSLServerSocket);
        return sSLServerSocket;
    }

    public static void setFactories(KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory) {
        SSLSocketFactory.keyManagerFactory = keyManagerFactory;
        SSLSocketFactory.trustManagerFactory = trustManagerFactory;
    }
}

