/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.utils.RecoveryHooks;

import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.jtsxa.Utility;
import com.sun.jts.otsidl.JCoordinator;
import com.sun.jts.otsidl.JCoordinatorHelper;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CosTransactions.Coordinator;

public class FailureInducer {
    public static final Integer ACTIVE = new Integer(0);
    public static final Integer PREPARING = new Integer(1);
    public static final Integer PREPARED = new Integer(2);
    public static final Integer COMPLETING = new Integer(3);
    public static final Integer COMPLETED = new Integer(4);
    private static boolean failureInducerIsActive = false;
    private static boolean crash = false;
    private static int waitPeriod = 0;
    private static int waitCount = 0;
    private static Hashtable crashList = new Hashtable();
    private static Hashtable waitList = new Hashtable();
    private static Hashtable waitTime = new Hashtable();
    private static ResourceBundle messages = ResourceBundle.getBundle("com.sun.jts.utils.RecoveryHooks.Messages");
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");

    public static void activateFailureInducer() {
        failureInducerIsActive = true;
    }

    public static void deactivateFailureInducer() {
        failureInducerIsActive = false;
    }

    public static boolean isFailureInducerActive() {
        return failureInducerIsActive;
    }

    public static void setCrashPoint(Integer n) {
        if (n == null) {
            _logger.log(Level.SEVERE, "jts.invalid_crash_point");
            return;
        }
        Coordinator coordinator = Utility.getCoordinator(Utility.getControl());
        JCoordinator jCoordinator = JCoordinatorHelper.narrow(coordinator);
        if (jCoordinator != null) {
            GlobalTID globalTID = new GlobalTID(jCoordinator.getGlobalTID());
            crashList.put(globalTID, n);
        }
    }

    public static void setWaitPoint(Integer n, int n2) {
        if (n == null) {
            _logger.log(Level.SEVERE, "jts.invalid_wait_point");
            return;
        }
        Coordinator coordinator = Utility.getCoordinator(Utility.getControl());
        JCoordinator jCoordinator = JCoordinatorHelper.narrow(coordinator);
        if (jCoordinator != null) {
            GlobalTID globalTID = new GlobalTID(jCoordinator.getGlobalTID());
            waitList.put(globalTID, n);
            waitTime.put(globalTID, new Integer(n2));
        }
    }

    public static void crash() {
        crash = true;
    }

    private static void incrementWaitCount() {
        ++waitCount;
    }

    public static int getWaitCount() {
        return waitCount;
    }

    public static void waitForFailure(GlobalTID globalTID, Integer n) {
        if (globalTID == null) {
            return;
        }
        Integer n2 = (Integer)crashList.get(globalTID);
        Integer n3 = (Integer)waitList.get(globalTID);
        if (n2 == null && n3 == null) {
            return;
        }
        _logger.log(Level.WARNING, "jts.failpoint", n);
        if (n2 != null && n2.equals(n)) {
            FailureInducer.incrementWaitCount();
            while (!crash) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {}
            }
            System.exit(0);
        }
        if (n3 != null && n3.equals(n)) {
            Integer n4 = (Integer)waitTime.get(globalTID);
            if (n4 == null || n4 < 0) {
                return;
            }
            try {
                Thread.sleep(n4 * 1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String getMessage(String string) {
        return FailureInducer.getMessage(string, null);
    }

    private static String getMessage(String string, Object[] objectArray) {
        if (messages == null || string == null) {
            return null;
        }
        String string2 = messages.getString(string);
        if (string2 == null) {
            return null;
        }
        if (objectArray == null) {
            return string2;
        }
        return MessageFormat.format(string2, objectArray);
    }
}

