/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.utils;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.Xid;

public class LogFormatter {
    public static String convertToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(byArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String convertXidArrayToString(Xid[] xidArray) {
        if (xidArray.length != 0) {
            StringBuffer stringBuffer = new StringBuffer("[ ");
            for (int i = 0; i < xidArray.length - 1; ++i) {
                stringBuffer.append(xidArray[i].getGlobalTransactionId()).append(", ");
            }
            stringBuffer.append(xidArray[xidArray.length - 1]).append(" ]");
            return stringBuffer.toString();
        }
        return " null ";
    }

    public static String convertPropsToString(Properties properties) {
        if (properties == null) {
            return "{null}";
        }
        StringBuffer stringBuffer = new StringBuffer("{ ");
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            stringBuffer.append("[ ").append(obj).append("->");
            String string = properties.getProperty((String)obj);
            if (string == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(" ] ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String getLocalizedMessage(Logger logger, String string) {
        try {
            ResourceBundle resourceBundle = logger.getResourceBundle();
            String string2 = resourceBundle.getString(string);
            return string2;
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "JTS:Error while localizing the log message");
            return string;
        }
    }

    public static String getLocalizedMessage(Logger logger, String string, Object[] objectArray) {
        try {
            ResourceBundle resourceBundle = logger.getResourceBundle();
            String string2 = resourceBundle.getString(string);
            return MessageFormat.format(string2, objectArray);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "JTS:Error while localizing the log message");
            return string;
        }
    }
}

