/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.trace;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CurrentTransaction;
import com.sun.jts.CosTransactions.TopCoordinator;
import com.sun.jts.trace.InvalidTraceLevelException;
import com.sun.jts.trace.TraceRecordFormatter;
import java.io.PrintWriter;

public class TraceUtil {
    private static int m_currentTraceLevel = 0;
    private static char m_fieldDelimiter = (char)58;
    private static String m_traceRecordTag = "iAS_JTS_Trace> ";
    private static PrintWriter m_traceWriter = null;

    public static void init(PrintWriter printWriter) {
        TraceUtil.setTraceWriter(printWriter);
    }

    public static void setTraceWriter(PrintWriter printWriter) {
        m_traceWriter = printWriter;
    }

    public static PrintWriter getTraceWriter() {
        return m_traceWriter;
    }

    public static int getCurrentTraceLevel() {
        return m_currentTraceLevel;
    }

    public static void setCurrentTraceLevel(int n) throws InvalidTraceLevelException {
        if (Configuration.traceOn) {
            boolean bl = false;
            for (int i = 0; i <= 6; ++i) {
                if (n != i) continue;
                m_currentTraceLevel = n;
                bl = true;
                break;
            }
            if (!bl) {
                throw new InvalidTraceLevelException();
            }
        }
    }

    public static void print(int n, PrintWriter printWriter, Object object, Object object2, String string) {
        if (n <= m_currentTraceLevel) {
            String string2 = TraceRecordFormatter.createTraceRecord(object, object2, string);
            printWriter.println(string2);
        }
    }

    public static void print(int n, Object object, String string) {
        try {
            TraceUtil.print(n, ((TopCoordinator)CurrentTransaction.getCurrent().get_localCoordinator()).get_transaction_name(), object, string);
        }
        catch (Exception exception) {
            TraceUtil.print(n, null, object, string);
        }
    }

    public static void print(int n, Object object, Object object2, String string) {
        TraceUtil.print(n, m_traceWriter, object, object2, string);
    }

    public static char getFieldDelimiter() {
        return m_fieldDelimiter;
    }

    public static void setFieldDelimiter(char c) {
        m_fieldDelimiter = c;
    }

    public static String getTraceRecordTag() {
        return m_traceRecordTag;
    }

    public static void setTraceRecordTag(String string) {
        m_traceRecordTag = string;
    }

    static {
        m_traceWriter = new PrintWriter(System.out);
    }
}

