/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.trace;

import com.sun.jts.trace.TraceUtil;
import java.util.Enumeration;
import java.util.Properties;
import javax.transaction.xa.Xid;
import org.omg.CosTransactions.otid_t;

public class TraceRecordFormatter {
    public static String createTraceRecord(Object object, Object object2, String string) {
        StringBuffer stringBuffer = new StringBuffer(TraceUtil.getTraceRecordTag());
        stringBuffer.append(TraceUtil.getCurrentTraceLevel()).append(TraceUtil.getFieldDelimiter());
        if (object == null) {
            stringBuffer.append("<unknown-tid>");
        } else if (object instanceof String) {
            stringBuffer.append(object);
        } else if (object instanceof otid_t) {
            stringBuffer.append(TraceRecordFormatter.convertToString(((otid_t)object).tid));
        }
        stringBuffer.append(TraceUtil.getFieldDelimiter()).append(System.currentTimeMillis()).append(TraceUtil.getFieldDelimiter());
        if (object2 == null) {
            stringBuffer.append("<unknown-origin>");
        } else {
            stringBuffer.append(object2);
        }
        stringBuffer.append(TraceUtil.getFieldDelimiter()).append(string).append("\n");
        return stringBuffer.toString();
    }

    public static String getTraceRecordScheme() {
        String string = "<trace-record-tag><level><separator><omg-tid><separator><current-time-in-milliseconds><separator><originator><separator><message>";
        return string;
    }

    public static String convertToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(byArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String convertXidArrayToString(Xid[] xidArray) {
        if (xidArray.length != 0) {
            StringBuffer stringBuffer = new StringBuffer("[ ");
            for (int i = 0; i < xidArray.length - 1; ++i) {
                stringBuffer.append(xidArray[i].getGlobalTransactionId()).append(", ");
            }
            stringBuffer.append(xidArray[xidArray.length - 1]).append(" ]");
            return stringBuffer.toString();
        }
        return " null ";
    }

    public static String convertPropsToString(Properties properties) {
        if (properties == null) {
            return "{null}";
        }
        StringBuffer stringBuffer = new StringBuffer("{ ");
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            stringBuffer.append("[ ").append(obj).append("->");
            String string = properties.getProperty((String)obj);
            if (string == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(" ] ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

