/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jtsxa;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.jta.TransactionState;
import com.sun.jts.jtsxa.OTSResource;
import com.sun.jts.jtsxa.OTSResourceHelper;
import com.sun.jts.jtsxa.OTSResourcePOA;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Request;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Vote;
import org.omg.CosTransactions.otid_t;
import org.omg.PortableServer.POA;

public class OTSResourceImpl
extends OTSResourcePOA
implements OTSResource {
    private static POA poa = null;
    private OTSResource thisRef = null;
    private XAResource xaRes = null;
    private Xid xid = null;
    private TransactionState tranState = null;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");
    private NO_IMPLEMENT no_implement = new NO_IMPLEMENT("This is a locally constrained object.");

    public OTSResourceImpl(Xid xid, XAResource xAResource, TransactionState transactionState) {
        this.xaRes = xAResource;
        this.xid = xid;
        this.tranState = transactionState;
    }

    public void commit() throws NotPrepared, HeuristicRollback, HeuristicHazard, HeuristicMixed, SystemException {
        try {
            this.xaRes.commit(this.xid, false);
        }
        catch (Exception exception) {
            this.destroy();
            if (!(exception instanceof XAException)) {
                throw new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
            }
            XAException xAException = (XAException)exception;
            if (xAException.errorCode == 6) {
                throw new HeuristicRollback();
            }
            if (xAException.errorCode == 8) {
                throw new HeuristicHazard();
            }
            if (xAException.errorCode == 5) {
                throw new HeuristicMixed();
            }
            if (xAException.errorCode == 105) {
                throw new NotPrepared();
            }
            throw new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
        }
        this.destroy();
    }

    public void commit_one_phase() throws HeuristicHazard, SystemException {
        try {
            this.xaRes.commit(this.xid, true);
        }
        catch (Exception exception) {
            this.destroy();
            if (!(exception instanceof XAException)) {
                throw new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
            }
            XAException xAException = (XAException)exception;
            if (xAException.errorCode == 6) {
                throw new HeuristicHazard();
            }
            if (xAException.errorCode == 8) {
                throw new HeuristicHazard();
            }
            if (xAException.errorCode == 5) {
                throw new HeuristicHazard();
            }
            if (xAException.errorCode == 7) {
                return;
            }
            if (xAException.errorCode == 4 || xAException.errorCode == 107 || xAException.errorCode == 101) {
                throw new TRANSIENT();
            }
            if (xAException.errorCode >= 100 && xAException.errorCode <= 107) {
                HeuristicHazard heuristicHazard = new HeuristicHazard();
                heuristicHazard.initCause(exception);
                throw heuristicHazard;
            }
            throw new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
        }
        this.destroy();
    }

    public void forget() {
        try {
            this.xaRes.forget(this.xid);
        }
        catch (XAException xAException) {
            // empty catch block
        }
        this.destroy();
    }

    public Vote prepare() throws HeuristicHazard, HeuristicMixed {
        int n = -6;
        try {
            n = this.xaRes.prepare(this.xid);
        }
        catch (XAException xAException) {
            // empty catch block
        }
        if (n == 0) {
            return Vote.VoteCommit;
        }
        if (n == 3) {
            this.destroy();
            return Vote.VoteReadOnly;
        }
        this.destroy();
        return Vote.VoteRollback;
    }

    public void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard, SystemException {
        try {
            if (this.tranState == null) {
                this.xaRes.rollback(this.xid);
            } else {
                this.tranState.rollback(this.xaRes);
            }
        }
        catch (Exception exception) {
            this.destroy();
            if (!(exception instanceof XAException)) {
                throw new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
            }
            XAException xAException = (XAException)exception;
            if (xAException.errorCode == 7) {
                throw new HeuristicCommit();
            }
            if (xAException.errorCode == 8) {
                throw new HeuristicHazard();
            }
            if (xAException.errorCode == 5) {
                throw new HeuristicMixed();
            }
            throw new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
        }
        this.destroy();
    }

    public otid_t getGlobalTID() {
        byte[] byArray = this.xid.getGlobalTransactionId();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        otid_t otid_t2 = new otid_t(this.xid.getFormatId(), 0, byArray2);
        return otid_t2;
    }

    public OTSResource getCORBAObjReference() {
        if (this.thisRef == null) {
            if (poa == null) {
                poa = Configuration.getPOA("transient");
            }
            try {
                poa.activate_object(this);
                this.thisRef = OTSResourceHelper.narrow(poa.servant_to_reference(this));
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "jts.create_xaresource_object_error");
                String string = LogFormatter.getLocalizedMessage(_logger, "jts.create_xaresource_object_error");
                throw new INTERNAL(string);
            }
        }
        return this.thisRef;
    }

    private void destroy() {
        if (poa != null && this.thisRef != null) {
            try {
                poa.deactivate_object(poa.reference_to_id(this.thisRef));
                this.thisRef = null;
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "jts.object_destroy_error", "OTSResource");
            }
        }
    }

    private void ensureInitialized() {
    }

    public Object _duplicate() {
        throw this.no_implement;
    }

    public void _release() {
        throw this.no_implement;
    }

    public boolean _is_a(String string) {
        throw this.no_implement;
    }

    public boolean _is_equivalent(Object object) {
        throw this.no_implement;
    }

    public boolean _non_existent() {
        throw this.no_implement;
    }

    public int _hash(int n) {
        throw this.no_implement;
    }

    public Request _request(String string) {
        throw this.no_implement;
    }

    public Request _create_request(Context context, String string, NVList nVList, NamedValue namedValue) {
        throw this.no_implement;
    }

    public Request _create_request(Context context, String string, NVList nVList, NamedValue namedValue, ExceptionList exceptionList, ContextList contextList) {
        throw this.no_implement;
    }

    public Object _get_interface_def() {
        throw this.no_implement;
    }

    public Policy _get_policy(int n) {
        throw this.no_implement;
    }

    public DomainManager[] _get_domain_managers() {
        throw this.no_implement;
    }

    public Object _set_policy_override(Policy[] policyArray, SetOverrideType setOverrideType) {
        throw this.no_implement;
    }
}

