/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jta;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.CurrentImpl;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.jta.TransactionImpl;
import com.sun.jts.jta.TransactionState;
import com.sun.jts.otsidl.JControlHelper;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.CurrentHelper;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Unavailable;

public class TransactionManagerImpl
implements TransactionManager {
    private static TransactionManagerImpl tm = null;
    private Current current;
    private Hashtable transactionStates;
    private static Hashtable statusMap;
    static Logger _logger;
    private static int xaTimeOut;
    private static Status[] CosTransactionStatus;
    private static int[] JTAStatus;

    public static synchronized TransactionManagerImpl getTransactionManagerImpl() {
        if (tm == null) {
            tm = new TransactionManagerImpl();
        }
        return tm;
    }

    private TransactionManagerImpl() {
        try {
            ORB oRB = Configuration.getORB();
            this.current = CurrentHelper.narrow(oRB.resolve_initial_references("TransactionCurrent"));
            this.transactionStates = new Hashtable();
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "jts.unexpected_error_in_create_transaction_manager", exception);
        }
    }

    public static void initJTSProperties(Properties properties, String string, boolean bl, String string2) {
        if (string2 == null) {
            string2 = ".";
        }
        if (string == null) {
            string = ".";
        }
        properties.put("com.sun.corba.ee.CosTransactions.ORBJTSClass", "com.sun.jts.CosTransactions.DefaultTransactionService");
        properties.put("com.sun.jts.traceDirectory", string2);
        properties.put("com.sun.jts.logDirectory", string);
        if (bl) {
            properties.put("com.sun.jts.trace", "true");
        }
    }

    public static int mapStatus(Status status) {
        Integer n = (Integer)statusMap.get(status);
        if (n == null) {
            TransactionManagerImpl.assertit(false);
            return 5;
        }
        return n;
    }

    public void begin() throws NotSupportedException, SystemException {
        try {
            if (this.current.get_control() != null) {
                throw new NotSupportedException();
            }
            this.current.begin();
        }
        catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
            throw new NotSupportedException();
        }
        catch (SubtransactionsUnavailable subtransactionsUnavailable) {
            throw new SystemException();
        }
    }

    public void begin(int n) throws NotSupportedException, SystemException {
        try {
            if (this.current.get_control() != null) {
                throw new NotSupportedException();
            }
            ((CurrentImpl)this.current).begin(n);
        }
        catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
            throw new NotSupportedException();
        }
        catch (SubtransactionsUnavailable subtransactionsUnavailable) {
            throw new SystemException();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            this.current.commit(true);
        }
        catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
            throw new RollbackException();
        }
        catch (NoTransaction noTransaction) {
            throw new IllegalStateException();
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            throw new SecurityException();
        }
        catch (HeuristicMixed heuristicMixed) {
            throw new HeuristicMixedException();
        }
        catch (HeuristicHazard heuristicHazard) {
            throw new HeuristicRollbackException();
        }
        catch (Exception exception) {
            throw new SystemException(exception.toString());
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            this.current.rollback();
        }
        catch (NoTransaction noTransaction) {
            throw new IllegalStateException();
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            throw new SecurityException();
        }
        catch (Exception exception) {
            throw new SystemException(exception.toString());
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        try {
            this.current.rollback_only();
        }
        catch (NoTransaction noTransaction) {
            throw new IllegalStateException();
        }
        catch (Exception exception) {
            throw new SystemException(exception.toString());
        }
    }

    public int getStatus() throws SystemException {
        try {
            Status status = this.current.get_status();
            return TransactionManagerImpl.mapStatus(status);
        }
        catch (Exception exception) {
            throw new SystemException(exception.toString());
        }
    }

    public synchronized void setTransactionTimeout(int n) throws SystemException {
        try {
            if (n < 0) {
                String string = LogFormatter.getLocalizedMessage(_logger, "jts.invalid_timeout");
                throw new SystemException(string);
            }
            this.current.set_timeout(n);
        }
        catch (Exception exception) {
            throw new SystemException(exception.toString());
        }
    }

    public Transaction getTransaction() throws SystemException {
        try {
            Control control = this.current.get_control();
            if (control == null) {
                return null;
            }
            return this.createTransactionImpl(control);
        }
        catch (Exception exception) {
            throw new SystemException(exception.toString());
        }
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (this.getTransaction() != null) {
            throw new IllegalStateException();
        }
        if (transaction == null) {
            throw new InvalidTransactionException();
        }
        if (!(transaction instanceof TransactionImpl)) {
            throw new InvalidTransactionException();
        }
        Control control = ((TransactionImpl)transaction).getControl();
        try {
            this.current.resume(control);
        }
        catch (InvalidControl invalidControl) {
            throw new InvalidTransactionException();
        }
        catch (Exception exception) {
            throw new SystemException(exception.toString());
        }
    }

    public Transaction suspend() throws SystemException {
        try {
            Control control = this.current.suspend();
            if (control == null) {
                return null;
            }
            return this.createTransactionImpl(control);
        }
        catch (Exception exception) {
            throw new SystemException(exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionState getOrCreateTransactionState(GlobalTID globalTID, Transaction transaction) throws SystemException {
        Hashtable hashtable = this.transactionStates;
        synchronized (hashtable) {
            TransactionState transactionState = (TransactionState)this.transactionStates.get(globalTID);
            if (transactionState == null) {
                transactionState = new TransactionState(globalTID);
                this.transactionStates.put(globalTID, transactionState);
                try {
                    SynchronizationListener synchronizationListener = new SynchronizationListener(globalTID, transactionState);
                    transaction.registerSynchronization((Synchronization)synchronizationListener);
                }
                catch (Exception exception) {
                    _logger.log(Level.WARNING, "jts.unexpected_error_in_get_or_create_transaction_state", exception);
                    throw new SystemException();
                }
            }
            return transactionState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionState getTransactionState(GlobalTID globalTID, Transaction transaction) throws SystemException {
        Hashtable hashtable = this.transactionStates;
        synchronized (hashtable) {
            return (TransactionState)this.transactionStates.get(globalTID);
        }
    }

    private Transaction createTransactionImpl(Control control) throws Unavailable, SystemException {
        GlobalTID globalTID = null;
        if (Configuration.isLocalFactory()) {
            globalTID = ((ControlImpl)control).getGlobalTID();
        } else {
            ControlImpl controlImpl = ControlImpl.servant(JControlHelper.narrow(control));
            globalTID = controlImpl.getGlobalTID();
        }
        return new TransactionImpl(this, control, globalTID);
    }

    public static void recover(Enumeration enumeration) {
        RecoveryManager.recoverXAResources(enumeration);
    }

    private static void assertit(boolean bl) {
        if (!bl) {
            Exception exception = new Exception();
            _logger.log(Level.WARNING, "jts.assert", exception);
        }
    }

    public static void setXAResourceTimeOut(int n) {
        xaTimeOut = n;
    }

    public static int getXAResourceTimeOut() {
        return xaTimeOut;
    }

    void cleanupTransactionState(GlobalTID globalTID) {
        this.transactionStates.remove(globalTID);
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");
        xaTimeOut = 0;
        CosTransactionStatus = new Status[]{Status.StatusActive, Status.StatusMarkedRollback, Status.StatusPrepared, Status.StatusCommitted, Status.StatusRolledBack, Status.StatusUnknown, Status.StatusNoTransaction, Status.StatusPreparing, Status.StatusCommitting, Status.StatusRollingBack};
        JTAStatus = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        statusMap = new Hashtable();
        for (int i = 0; i < CosTransactionStatus.length; ++i) {
            statusMap.put(CosTransactionStatus[i], new Integer(JTAStatus[i]));
        }
    }

    class SynchronizationListener
    implements Synchronization {
        private GlobalTID gtid;
        private TransactionState tranState;

        SynchronizationListener(GlobalTID globalTID, TransactionState transactionState) {
            this.gtid = globalTID;
            this.tranState = transactionState;
        }

        public void afterCompletion(int n) {
            this.tranState.cleanupTransactionStateMapping();
        }

        public void beforeCompletion() {
            try {
                this.tranState.beforeCompletion();
            }
            catch (XAException xAException) {
                _logger.log(Level.WARNING, "jts.unexpected_xa_error_in_beforecompletion", new Object[]{new Integer(xAException.errorCode), xAException.getMessage()});
                _logger.log(Level.WARNING, "", xAException);
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "jts.unexpected_error_in_beforecompletion", exception);
            }
        }
    }
}

