/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.AdminUtil;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.RWLock;
import com.sun.jts.utils.LogFormatter;
import com.sun.jts.utils.RecoveryHooks.FailureInducer;
import com.sun.logging.LogDomains;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.INTERNAL;

class TransactionState {
    static final int STATE_NONE = 0;
    static final int STATE_ACTIVE = 1;
    static final int STATE_PREPARING = 2;
    static final int STATE_PREPARED_SUCCESS = 3;
    static final int STATE_PREPARED_FAIL = 4;
    static final int STATE_PREPARED_READONLY = 5;
    static final int STATE_COMMITTING = 6;
    static final int STATE_COMMITTED = 7;
    static final int STATE_ROLLING_BACK = 8;
    static final int STATE_ROLLED_BACK = 9;
    static final int STATE_COMMITTING_ONE_PHASE = 10;
    static final int STATE_COMMITTED_ONE_PHASE_OK = 11;
    static final int STATE_COMMIT_ONE_PHASE_ROLLED_BACK = 12;
    static final int STATE_COMMIT_ONE_PHASE_HEURISTIC_HAZARD = 13;
    static final int STATE_COMMIT_ONE_PHASE_HEURISTIC_MIXED = 14;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");
    static RWLock freezeLock = new RWLock();
    GlobalTID globalTID = null;
    Long localTID = null;
    int state = 0;
    boolean subordinate = false;
    CoordinatorLog logRecord = null;
    Object logSection = null;
    static long sequenceNumber = 1L;
    static boolean inDoubt = false;
    static byte[] TIDTemplate = null;
    static final boolean[][] validStateChange = new boolean[][]{{false, true, false, false, false, false, false, false, true, false, false, false, false, false, false}, {false, false, true, false, false, false, false, false, true, false, true, false, false, false, false}, {false, false, false, true, true, true, false, false, true, true, false, false, false, false, false}, {false, false, false, false, false, false, true, false, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false}, {true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, false, true, true, true, true, true}, {false, false, false, false, false, false, false, true, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, false, false, false, false, false}, {false, false, false, false, false, false, false, true, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, true, false, false, false, false, false, false, false}};
    static final int XID_FORMAT_ID = 4871251;
    private static final String LOG_SECTION_NAME = "TS";

    TransactionState() {
    }

    TransactionState(CoordinatorLog coordinatorLog) {
        this.localTID = new Long(TransactionState.getSequenceNumber());
        this.globalTID = new GlobalTID(4871251, 0, TransactionState.generateTID(this.localTID));
        this.state = 0;
        this.subordinate = false;
        if (coordinatorLog != null) {
            this.logRecord = coordinatorLog;
            this.logRecord.setLocalTID(this.localTID);
            this.logSection = this.logRecord.createSection(LOG_SECTION_NAME);
        }
    }

    TransactionState(GlobalTID globalTID, CoordinatorLog coordinatorLog) {
        this.globalTID = globalTID;
        this.localTID = new Long(TransactionState.getSequenceNumber());
        this.state = 0;
        this.subordinate = true;
        if (coordinatorLog != null) {
            this.logRecord = coordinatorLog;
            this.logRecord.setLocalTID(this.localTID);
            this.logSection = this.logRecord.createSection(LOG_SECTION_NAME);
        }
    }

    TransactionState(Long l, GlobalTID globalTID) {
        this.localTID = new Long(TransactionState.getSequenceNumber());
        this.globalTID = new GlobalTID(4871251, 0, TransactionState.generateTID(this.localTID));
        this.state = 0;
        this.subordinate = false;
    }

    int reconstruct(CoordinatorLog coordinatorLog) {
        int n = 0;
        this.logSection = coordinatorLog.createSection(LOG_SECTION_NAME);
        byte[][] byArray = coordinatorLog.getData(this.logSection);
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i].length > 1) {
                n2 |= ((byArray[i][0] & 0xFF) << 8) + (byArray[i][1] & 0xFF);
                continue;
            }
            _logger.log(Level.SEVERE, "jts.invalid_log_record_data", LOG_SECTION_NAME);
            String string = LogFormatter.getLocalizedMessage(_logger, "jts.invalid_log_record_data", new Object[]{LOG_SECTION_NAME});
            throw new INTERNAL(string);
        }
        if ((n2 & 0x200) != 0) {
            n = 9;
        } else if ((n2 & 0x80) != 0) {
            n = 7;
        } else if ((n2 & 0x40) != 0) {
            n = 6;
        } else if ((n2 & 0x100) != 0) {
            n = 8;
        } else if ((n2 & 0x20) != 0) {
            n = 5;
        } else if ((n2 & 0x10) != 0) {
            n = 4;
        } else if ((n2 & 8) != 0) {
            n = 3;
        } else if ((n2 & 0x400) != 0) {
            n = 10;
        } else if ((n2 & 0x800) != 0) {
            n = 11;
        } else if ((n2 & 0x1000) != 0) {
            n = 12;
        } else if ((n2 & 0x2000) != 0) {
            n = 13;
        } else if ((n2 & 0x4000) != 0) {
            n = 14;
        }
        this.state = n;
        this.subordinate = false;
        this.logRecord = coordinatorLog;
        return n;
    }

    public void finalize() {
        this.state = 0;
        this.globalTID = null;
        this.localTID = null;
        this.logRecord = null;
        this.logSection = null;
    }

    boolean setState(int n) {
        boolean bl = false;
        if (validStateChange[this.state][n]) {
            Object object;
            if (AdminUtil.bSampling) {
                switch (n) {
                    case 3: {
                        AdminUtil.incrementPendingTransactionCount();
                        break;
                    }
                    case 5: {
                        AdminUtil.incrementPendingTransactionCount();
                        break;
                    }
                    case 7: {
                        AdminUtil.incrementCommitedTransactionCount();
                        break;
                    }
                    case 9: {
                        AdminUtil.incrementAbortedTransactionCount();
                        break;
                    }
                    case 8: {
                        AdminUtil.incrementUnpreparedAbortedTransactionCount();
                    }
                }
            }
            switch (this.state) {
                case 2: 
                case 6: 
                case 10: {
                    if (_logger.isLoggable(Level.FINEST)) {
                        object = null;
                        switch (n) {
                            case 2: {
                                object = "PREPARING";
                                break;
                            }
                            case 6: {
                                object = "COMMITTING";
                                break;
                            }
                            case 10: {
                                object = "COMMITTING_ONE_PHASE";
                                break;
                            }
                            default: {
                                object = "Illegal state ";
                            }
                        }
                        _logger.logp(Level.FINEST, "TransactionState", "setState()", "Releasing read lock on freeze : state " + (String)object);
                    }
                    freezeLock.releaseReadLock();
                    if (!_logger.isLoggable(Level.FINEST)) break;
                    object = null;
                    _logger.logp(Level.FINEST, "TransactionState", "setState()", "Released read lock on freeze");
                    switch (n) {
                        case 2: {
                            object = "PREPARING";
                            break;
                        }
                        case 6: {
                            object = "COMMITTING";
                            break;
                        }
                        case 10: {
                            object = "COMMITTING_ONE_PHASE";
                            break;
                        }
                        default: {
                            object = "Illegal state ";
                        }
                    }
                    _logger.logp(Level.FINEST, "TransactionState", "setState()", "Released read lock on freeze : state " + (String)object);
                }
            }
            switch (n) {
                case 2: 
                case 6: 
                case 10: {
                    if (_logger.isLoggable(Level.FINEST)) {
                        object = null;
                        switch (n) {
                            case 2: {
                                object = "PREPARING";
                                break;
                            }
                            case 6: {
                                object = "COMMITTING";
                                break;
                            }
                            case 10: {
                                object = "COMMITTING_ONE_PHASE";
                                break;
                            }
                            default: {
                                object = "Illegal state ";
                            }
                        }
                        _logger.logp(Level.FINEST, "TransactionState", "setState()", "Acquiring read lock on freeze : state " + (String)object);
                    }
                    freezeLock.acquireReadLock();
                    if (!_logger.isLoggable(Level.FINEST)) break;
                    object = null;
                    switch (n) {
                        case 2: {
                            object = "PREPARING";
                            break;
                        }
                        case 6: {
                            object = "COMMITTING";
                            break;
                        }
                        case 10: {
                            object = "COMMITTING_ONE_PHASE";
                            break;
                        }
                        default: {
                            object = "Illegal state ";
                        }
                    }
                    _logger.logp(Level.FINEST, "TransactionState", "setState()", "Acquired read lock on freeze : state " + (String)object);
                }
            }
            if (FailureInducer.isFailureInducerActive() && !Thread.currentThread().getName().equals("JTS Resync Thread")) {
                object = null;
                switch (n) {
                    case 2: {
                        object = FailureInducer.ACTIVE;
                        break;
                    }
                    case 3: {
                        object = FailureInducer.PREPARING;
                        break;
                    }
                    case 4: {
                        object = FailureInducer.PREPARING;
                        break;
                    }
                    case 5: {
                        object = FailureInducer.PREPARING;
                        break;
                    }
                    case 10: {
                        object = FailureInducer.ACTIVE;
                        break;
                    }
                    case 11: {
                        object = FailureInducer.COMPLETING;
                        break;
                    }
                    case 12: {
                        object = FailureInducer.COMPLETING;
                        break;
                    }
                    case 6: {
                        object = FailureInducer.PREPARED;
                        break;
                    }
                    case 7: {
                        object = FailureInducer.COMPLETING;
                        break;
                    }
                    case 8: {
                        if (this.state == 3) {
                            object = FailureInducer.PREPARED;
                            break;
                        }
                        if (this.state == 4) {
                            object = FailureInducer.PREPARED;
                            break;
                        }
                        if (this.state == 5) {
                            object = FailureInducer.PREPARED;
                            break;
                        }
                        if (this.state != 1) break;
                        object = FailureInducer.ACTIVE;
                        break;
                    }
                    case 9: {
                        object = FailureInducer.COMPLETING;
                    }
                }
                FailureInducer.waitForFailure(this.globalTID, (Integer)object);
            }
            this.state = n;
            bl = true;
            if (this.logRecord != null && (n == 3 || n == 4 || n == 6 && this.subordinate || n == 8 && this.subordinate || n == 7 || n == 9 || n == 10 || n == 11 || n == 12 || n == 13 || n == 14)) {
                object = new byte[2];
                object[0] = (byte)((1 << this.state & 0xFF00) >> 8);
                object[1] = (byte)(1 << this.state & 0xFF);
                bl = this.logRecord.addData(this.logSection, (byte[])object);
            }
            if (this.logRecord != null && (n == 3 || n == 13 || n == 14 || n == 6 && this.subordinate || n == 8 && this.subordinate)) {
                TransactionState.setInDoubt(true);
                bl = this.logRecord.write(true);
                if (!bl) {
                    // empty if block
                }
            }
            if (this.logRecord == null || n != 7 && n != 10 && n != 11 && n != 12 && n != 9 || !(bl = this.logRecord.write(false))) {
                // empty if block
            }
            if (FailureInducer.isFailureInducerActive() && !Thread.currentThread().getName().equals("JTS Resync Thread")) {
                object = null;
                switch (n) {
                    case 11: {
                        object = FailureInducer.COMPLETED;
                        break;
                    }
                    case 7: {
                        object = FailureInducer.COMPLETED;
                        break;
                    }
                    case 9: {
                        object = FailureInducer.COMPLETED;
                    }
                }
                FailureInducer.waitForFailure(this.globalTID, (Integer)object);
            }
        }
        return bl;
    }

    private static synchronized long getSequenceNumber() {
        return ++sequenceNumber;
    }

    static boolean inDoubt() {
        return inDoubt;
    }

    static void setInDoubt(boolean bl) {
        inDoubt = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static final byte[] generateTID(long l) {
        Object object;
        if (TIDTemplate == null) {
            Class clazz = TransactionState.class;
            object = clazz;
            // MONITORENTER : clazz
            if (TIDTemplate == null) {
                String string = Configuration.getServerName();
                int n = string == null ? 0 : string.length();
                TIDTemplate = new byte[n + 8];
                long l2 = new Date().getTime();
                TransactionState.TIDTemplate[4] = (byte)l2;
                TransactionState.TIDTemplate[5] = (byte)(l2 >> 8);
                TransactionState.TIDTemplate[6] = (byte)(l2 >> 16);
                TransactionState.TIDTemplate[7] = (byte)(l2 >> 24);
                for (int i = 0; i < n; ++i) {
                    TransactionState.TIDTemplate[i + 8] = (byte)string.charAt(i);
                }
            }
            // MONITOREXIT : object
        }
        object = new byte[TIDTemplate.length];
        System.arraycopy(TIDTemplate, 4, object, 4, TIDTemplate.length - 4);
        object[0] = (byte)l;
        object[1] = (byte)(l >> 8);
        object[2] = (byte)(l >> 16);
        object[3] = (byte)(l >> 24);
        return object;
    }
}

