/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.ProxyChecker;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.SubCoordinator;
import com.sun.jts.CosTransactions.TerminatorImpl;
import com.sun.jts.CosTransactions.TimeoutManager;
import com.sun.jts.CosTransactions.TopCoordinator;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Request;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.CosTransactions.TransactionFactoryPOA;
import org.omg.PortableServer.POA;

class TransactionFactoryImpl
extends TransactionFactoryPOA
implements TransactionFactory {
    private static POA poa = null;
    private TransactionFactory thisRef = null;
    static boolean active = true;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");

    TransactionFactoryImpl() {
        TimeoutManager.initialise();
        RecoveryManager.initialise();
    }

    public Control create(int n) throws SystemException {
        Control control = null;
        ControlImpl controlImpl = this.localCreate(n);
        if (controlImpl == null) {
            return control;
        }
        control = Configuration.isLocalFactory() ? controlImpl : controlImpl.object();
        return control;
    }

    public ControlImpl localCreate(int n) throws SystemException {
        if (!active) {
            NO_PERMISSION nO_PERMISSION = new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
            throw nO_PERMISSION;
        }
        RecoveryManager.waitForResync();
        TopCoordinator topCoordinator = null;
        TerminatorImpl terminatorImpl = null;
        ControlImpl controlImpl = null;
        try {
            topCoordinator = new TopCoordinator(n);
            terminatorImpl = new TerminatorImpl(topCoordinator, false);
            controlImpl = new ControlImpl(terminatorImpl, topCoordinator, new GlobalTID(topCoordinator.getGlobalTID()), new Long(topCoordinator.getLocalTID()));
            if (_logger.isLoggable(Level.FINE)) {
                _logger.logp(Level.FINE, "TransactionFactoryImpl", "localCreate()", "Control object :" + controlImpl + " corresponding to this transaction has been created" + "GTID is : " + topCoordinator.superInfo.globalTID.toString());
            }
        }
        catch (Throwable throwable) {
            if (topCoordinator != null) {
                topCoordinator.finalize();
            }
            if (terminatorImpl != null) {
                terminatorImpl.finalize();
            }
            if (controlImpl != null) {
                controlImpl.finalize();
            }
            controlImpl = null;
        }
        return controlImpl;
    }

    public Control recreate(PropagationContext propagationContext) throws SystemException {
        if (!active) {
            NO_PERMISSION nO_PERMISSION = new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
            throw nO_PERMISSION;
        }
        if (propagationContext.current == null || propagationContext.current.otid.formatID == -1) {
            return null;
        }
        GlobalTID globalTID = new GlobalTID(propagationContext.current.otid);
        CoordinatorImpl coordinatorImpl = RecoveryManager.getCoordinator(globalTID);
        Control control = null;
        ProxyChecker proxyChecker = Configuration.getProxyChecker();
        if (coordinatorImpl == null && !proxyChecker.isProxy(propagationContext.current.coord)) {
            TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw tRANSACTION_ROLLEDBACK;
        }
        if (coordinatorImpl == null) {
            RecoveryManager.waitForResync();
            coordinatorImpl = RecoveryManager.getCoordinator(globalTID);
        }
        try {
            if (coordinatorImpl == null) {
                if (propagationContext.parents.length > 0) {
                    CoordinatorImpl[] coordinatorImplArray = new CoordinatorImpl[propagationContext.parents.length];
                    for (int i = propagationContext.parents.length - 1; i >= 0; --i) {
                        GlobalTID globalTID2 = new GlobalTID(propagationContext.parents[i].otid);
                        coordinatorImpl = RecoveryManager.getCoordinator(globalTID2);
                        if (coordinatorImpl == null) {
                            if (i == propagationContext.parents.length - 1) {
                                coordinatorImpl = new TopCoordinator(propagationContext.timeout, globalTID2, (Coordinator)propagationContext.parents[i].coord._duplicate(), true);
                            } else {
                                CoordinatorImpl[] coordinatorImplArray2 = new CoordinatorImpl[propagationContext.parents.length - i - 1];
                                System.arraycopy(coordinatorImplArray, i + 1, coordinatorImplArray2, 0, propagationContext.parents.length - i - 1);
                                coordinatorImpl = new SubCoordinator(globalTID2, (Coordinator)propagationContext.parents[i].coord._duplicate(), true, coordinatorImplArray2);
                                coordinatorImplArray[i + 1].addChild(coordinatorImpl);
                            }
                        }
                        propagationContext.parents[i].coord._release();
                        coordinatorImplArray[i] = coordinatorImpl;
                    }
                    coordinatorImpl = new SubCoordinator(globalTID, (Coordinator)propagationContext.current.coord._duplicate(), true, coordinatorImplArray);
                    coordinatorImplArray[0].addChild(coordinatorImpl);
                } else {
                    coordinatorImpl = new TopCoordinator(propagationContext.timeout, globalTID, (Coordinator)propagationContext.current.coord._duplicate(), true);
                }
            } else {
                coordinatorImpl.setPermanent();
            }
            control = Configuration.isLocalFactory() ? new ControlImpl(null, coordinatorImpl, globalTID, new Long(coordinatorImpl.getLocalTID())) : new ControlImpl(null, coordinatorImpl, globalTID, new Long(coordinatorImpl.getLocalTID())).object();
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "jts.unable_to_create_subordinate_coordinator");
            String string = LogFormatter.getLocalizedMessage(_logger, "jts.unable_to_create_subordinate_coordinator");
            throw new INTERNAL(string);
        }
        return control;
    }

    static void deactivate() {
        active = false;
        TimeoutManager.shutdown(false);
        RecoveryManager.shutdown(false);
    }

    synchronized TransactionFactory object() {
        if (this.thisRef == null) {
            if (poa == null) {
                poa = Configuration.getPOA("transient");
            }
            try {
                poa.activate_object(this);
                this.thisRef = TransactionFactoryHelper.narrow(poa.servant_to_reference(this));
                NamingContext namingContext = null;
                try {
                    namingContext = NamingContextHelper.narrow(Configuration.getORB().resolve_initial_references("NameService"));
                }
                catch (Exception exception) {
                    _logger.log(Level.WARNING, "jts.orb_not_running");
                }
                try {
                    NameComponent nameComponent = new NameComponent(TransactionFactoryHelper.id(), "");
                    NameComponent[] nameComponentArray = new NameComponent[]{nameComponent};
                    namingContext.rebind(nameComponentArray, this.thisRef);
                }
                catch (Exception exception) {
                    _logger.log(Level.WARNING, "jts.cannot_register_with_orb", "TransactionFactory");
                }
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "jts.create_transactionfactory_object_error");
                String string = LogFormatter.getLocalizedMessage(_logger, "jts.create_transactionfactory_object_error");
                throw new INTERNAL(string);
            }
        }
        return this.thisRef;
    }

    static final synchronized TransactionFactoryImpl servant(TransactionFactory transactionFactory) {
        TransactionFactoryImpl transactionFactoryImpl = null;
        if (transactionFactory != null && Configuration.getProxyChecker().isProxy(transactionFactory)) {
            return transactionFactoryImpl;
        }
        if (transactionFactory instanceof TransactionFactoryImpl) {
            transactionFactoryImpl = (TransactionFactoryImpl)transactionFactory;
        } else if (poa != null) {
            try {
                transactionFactoryImpl = (TransactionFactoryImpl)poa.reference_to_servant(transactionFactory);
                if (transactionFactoryImpl.thisRef == null) {
                    transactionFactoryImpl.thisRef = transactionFactory;
                }
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "jts.cannot_locate_servant", "TransactionFactory");
            }
        }
        return transactionFactoryImpl;
    }

    public Object _duplicate() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public void _release() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public boolean _is_a(String string) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public boolean _is_equivalent(Object object) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public boolean _non_existent() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public int _hash(int n) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Request _request(String string) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Request _create_request(Context context, String string, NVList nVList, NamedValue namedValue) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Request _create_request(Context context, String string, NVList nVList, NamedValue namedValue, ExceptionList exceptionList, ContextList contextList) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Object _get_interface_def() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Policy _get_policy(int n) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public DomainManager[] _get_domain_managers() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Object _set_policy_override(Policy[] policyArray, SetOverrideType setOverrideType) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }
}

