/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.ProxyChecker;
import com.sun.jts.jtsxa.OTSResourceImpl;
import com.sun.jts.otsidl.ResourceStatus;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.ResourceHelper;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.Vote;

class RegisteredResources {
    private Vector resourceObjects = null;
    private Vector resourceStates = null;
    private CoordinatorLog logRecord = null;
    private java.lang.Object logSection = null;
    private java.lang.Object heuristicLogSection = null;
    private static int commitRetries = -1;
    private int nRes = 0;
    private static String commitRetryVar = Configuration.getPropertyValue("com.sun.jts.commitRetry");
    private static final long COMMIT_RETRY_WAIT = 60000L;
    private static final String LOG_SECTION_NAME = "RR";
    private static final String HEURISTIC_LOG_SECTION_NAME = "RRH";
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");

    RegisteredResources(CoordinatorLog coordinatorLog) {
        this.resourceObjects = new Vector();
        this.resourceStates = new Vector();
        this.logRecord = coordinatorLog;
        if (coordinatorLog != null) {
            this.logSection = coordinatorLog.createSection(LOG_SECTION_NAME);
            this.heuristicLogSection = coordinatorLog.createSection(HEURISTIC_LOG_SECTION_NAME);
        }
    }

    RegisteredResources() {
    }

    public void finalize() {
        if (this.resourceObjects != null) {
            this.empty();
        }
        this.resourceObjects = null;
        this.resourceStates = null;
        this.logRecord = null;
        this.logSection = null;
        this.heuristicLogSection = null;
    }

    void reconstruct(CoordinatorLog coordinatorLog) {
        Resource resource;
        int n;
        boolean bl;
        int n2;
        this.resourceObjects = new Vector();
        this.resourceStates = new Vector();
        boolean bl2 = true;
        if (commitRetries == -1 && commitRetryVar != null) {
            try {
                commitRetries = Integer.parseInt(commitRetryVar);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            bl2 = false;
        }
        this.heuristicLogSection = coordinatorLog.createSection(HEURISTIC_LOG_SECTION_NAME);
        java.lang.Object[] objectArray = coordinatorLog.getObjects(this.heuristicLogSection);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            bl = true;
            n = commitRetries;
            while (bl) {
                try {
                    resource = ResourceHelper.narrow((Object)objectArray[n2]);
                    if (resource != null) {
                        this.resourceObjects.addElement(resource);
                        ++this.nRes;
                        this.resourceStates.addElement(ResourceStatus.Heuristic);
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof TRANSIENT || throwable instanceof COMM_FAILURE) {
                        _logger.log(Level.WARNING, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "reconstruct"});
                        if (n > 0 || bl2) {
                            if (!bl2) {
                                --n;
                            }
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (Throwable throwable2) {}
                            continue;
                        }
                        _logger.log(Level.SEVERE, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commit"});
                        String string = LogFormatter.getLocalizedMessage(_logger, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commit"});
                        throw new INTERNAL(string);
                    }
                    bl = false;
                }
            }
        }
        this.logSection = coordinatorLog.createSection(LOG_SECTION_NAME);
        objectArray = coordinatorLog.getObjects(this.logSection);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            bl = true;
            n = commitRetries;
            while (bl) {
                try {
                    resource = ResourceHelper.narrow((Object)objectArray[n2]);
                    if (resource != null) {
                        this.resourceObjects.addElement(resource);
                        ++this.nRes;
                        this.resourceStates.addElement(ResourceStatus.Registered);
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof TRANSIENT || throwable instanceof COMM_FAILURE) {
                        _logger.log(Level.WARNING, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "reconstruct"});
                        if (n > 0 || bl2) {
                            if (!bl2) {
                                --n;
                            }
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (Throwable throwable3) {}
                            continue;
                        }
                        _logger.log(Level.SEVERE, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commit"});
                        String string = LogFormatter.getLocalizedMessage(_logger, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commit"});
                        throw new INTERNAL(string);
                    }
                    bl = false;
                }
            }
        }
        this.logRecord = coordinatorLog;
    }

    int addRes(Resource resource) {
        this.resourceObjects.addElement(resource);
        ++this.nRes;
        this.resourceStates.addElement(ResourceStatus.Registered);
        return this.nRes;
    }

    void empty() {
        this.resourceObjects.removeAllElements();
        this.nRes = 0;
        this.resourceStates.removeAllElements();
    }

    boolean involved() {
        boolean bl = this.nRes != 0;
        return bl;
    }

    int numRegistered() {
        return this.nRes;
    }

    Vote distributePrepare() throws HeuristicMixed, HeuristicHazard {
        boolean bl = false;
        java.lang.Object object = Vote.VoteReadOnly;
        for (int i = 0; i < this.nRes && object != Vote.VoteRollback; ++i) {
            java.lang.Object object2;
            Resource resource = (Resource)this.resourceObjects.elementAt(i);
            if (!(resource instanceof OTSResourceImpl)) {
                object2 = Configuration.getProxyChecker();
                bl = object2.isProxy(resource);
            }
            object2 = Vote.VoteRollback;
            try {
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.logp(Level.FINER, "RegisteredResources", "prepare()", "Before invoking prepare() on resource:" + resource);
                }
                object2 = resource.prepare();
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.logp(Level.FINER, "RegisteredResources", "prepare()", "After invoking prepare() on resource:" + resource + ";This resource voted : " + object2);
                }
            }
            catch (Throwable throwable) {
                boolean bl2 = throwable instanceof HeuristicHazard;
                if (throwable instanceof HeuristicMixed || bl2) {
                    block13: {
                        this.resourceStates.setElementAt(ResourceStatus.Heuristic, i);
                        try {
                            this.distributeRollback(true);
                        }
                        catch (Throwable throwable2) {
                            if (!(throwable2 instanceof HeuristicMixed) || !bl2) break block13;
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        HeuristicHazard heuristicHazard = new HeuristicHazard();
                        throw heuristicHazard;
                    }
                    HeuristicMixed heuristicMixed = new HeuristicMixed();
                    throw heuristicMixed;
                }
                _logger.log(Level.WARNING, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "prepare"});
            }
            if (object2 == Vote.VoteCommit) {
                if (this.logRecord != null) {
                    this.logRecord.addObject(this.logSection, resource);
                }
                if (object != Vote.VoteReadOnly) continue;
                object = Vote.VoteCommit;
                continue;
            }
            this.resourceStates.setElementAt(ResourceStatus.Completed, i);
            if (bl) {
                resource._release();
            }
            if (object2 != Vote.VoteRollback) continue;
            object = object2;
        }
        return object;
    }

    void distributeCommit() throws HeuristicMixed, HeuristicHazard {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (commitRetries == -1 && commitRetryVar != null) {
            try {
                commitRetries = Integer.parseInt(commitRetryVar);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            bl = false;
        }
        for (int i = 0; i < this.nRes; ++i) {
            Resource resource = (Resource)this.resourceObjects.elementAt(i);
            if ((ResourceStatus)this.resourceStates.elementAt(i) != ResourceStatus.Registered) continue;
            boolean bl5 = false;
            if (!(resource instanceof OTSResourceImpl)) {
                ProxyChecker proxyChecker = Configuration.getProxyChecker();
                bl2 = proxyChecker.isProxy(resource);
            }
            this.resourceStates.setElementAt(ResourceStatus.Completing, i);
            int n = commitRetries;
            boolean bl6 = true;
            while (bl6) {
                try {
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.logp(Level.FINER, "RegisteredResources", "distributeCommit()", "Before invoking commit on resource = " + resource);
                    }
                    resource.commit();
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.logp(Level.FINER, "RegisteredResources", "distributeCommit()", "After invoking commit on resource = " + resource);
                    }
                    bl6 = false;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof HeuristicCommit) {
                        bl3 = true;
                        bl5 = true;
                        bl6 = false;
                        continue;
                    }
                    if (throwable instanceof HeuristicRollback || throwable instanceof HeuristicHazard || throwable instanceof HeuristicMixed) {
                        bl3 = true;
                        bl4 = !(throwable instanceof HeuristicHazard);
                        bl5 = true;
                        bl6 = false;
                        continue;
                    }
                    if (throwable instanceof INV_OBJREF || throwable instanceof OBJECT_NOT_EXIST) {
                        bl6 = false;
                        continue;
                    }
                    if (throwable instanceof NotPrepared) {
                        _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "commit"});
                        String string = LogFormatter.getLocalizedMessage(_logger, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "commit"});
                        throw new INTERNAL(string);
                    }
                    if (!(throwable instanceof TRANSIENT) && !(throwable instanceof COMM_FAILURE)) {
                        _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "commit"});
                        String string = LogFormatter.getLocalizedMessage(_logger, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "commit"});
                        throw new INTERNAL(string);
                    }
                    if (n > 0 || bl) {
                        if (!bl) {
                            --n;
                        }
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (Throwable throwable2) {}
                        continue;
                    }
                    _logger.log(Level.FINE, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commit"});
                    String string = LogFormatter.getLocalizedMessage(_logger, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commit"});
                    throw new INTERNAL(string);
                }
            }
            if (bl5) {
                this.resourceStates.setElementAt(ResourceStatus.Heuristic, i);
                if (this.logRecord == null) continue;
                this.logRecord.addObject(this.heuristicLogSection, resource);
                continue;
            }
            this.resourceStates.setElementAt(ResourceStatus.Completed, i);
            if (!bl2) continue;
            resource._release();
        }
        if (bl3) {
            this.distributeForget(commitRetries, bl, bl4);
        }
    }

    void distributeRollback(boolean bl) throws HeuristicMixed, HeuristicHazard {
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        if (commitRetries == -1 && commitRetryVar != null) {
            try {
                commitRetries = Integer.parseInt(commitRetryVar);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            bl2 = false;
        }
        for (int i = 0; i < this.nRes; ++i) {
            Resource resource = (Resource)this.resourceObjects.elementAt(i);
            if (!this.resourceStates.elementAt(i).equals(ResourceStatus.Registered)) continue;
            boolean bl5 = false;
            if (!(resource instanceof OTSResourceImpl)) {
                ProxyChecker proxyChecker = Configuration.getProxyChecker();
                bl4 = proxyChecker.isProxy(resource);
            }
            this.resourceStates.setElementAt(ResourceStatus.Completing, i);
            int n = commitRetries;
            boolean bl6 = true;
            while (bl6) {
                try {
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.logp(Level.FINER, "RegisteredResources", "distributeRollback()", "Before invoking rollback on resource = " + resource);
                    }
                    resource.rollback();
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.logp(Level.FINER, "RegisteredResources", "distributeRollback()", "After invoking rollback on resource = " + resource);
                    }
                    bl6 = false;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof TRANSACTION_ROLLEDBACK) {
                        bl6 = false;
                    }
                    if (throwable instanceof HeuristicRollback) {
                        bl = true;
                        bl5 = true;
                        bl6 = false;
                        continue;
                    }
                    if (throwable instanceof HeuristicCommit || throwable instanceof HeuristicHazard || throwable instanceof HeuristicMixed) {
                        bl = true;
                        bl3 = !(throwable instanceof HeuristicHazard);
                        bl5 = true;
                        bl6 = false;
                        continue;
                    }
                    if (throwable instanceof INV_OBJREF || throwable instanceof OBJECT_NOT_EXIST) {
                        bl6 = false;
                        continue;
                    }
                    if (!(throwable instanceof TRANSIENT) && !(throwable instanceof COMM_FAILURE)) {
                        _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "rollback"});
                        String string = LogFormatter.getLocalizedMessage(_logger, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "rollback"});
                        throw new INTERNAL(string);
                    }
                    if (n > 0 || bl2) {
                        if (!bl2) {
                            --n;
                        }
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (Throwable throwable2) {}
                        continue;
                    }
                    _logger.log(Level.SEVERE, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "rollback"});
                    String string = LogFormatter.getLocalizedMessage(_logger, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "rollback"});
                    throw new INTERNAL(string);
                }
            }
            if (bl5) {
                this.resourceStates.setElementAt(ResourceStatus.Heuristic, i);
                if (this.logRecord == null) continue;
                this.logRecord.addObject(this.heuristicLogSection, resource);
                continue;
            }
            this.resourceStates.setElementAt(ResourceStatus.Completed, i);
            if (!bl4) continue;
            resource._release();
        }
        if (bl) {
            this.distributeForget(commitRetries, bl2, bl3);
        }
    }

    private void distributeForget(int n, boolean bl, boolean bl2) throws HeuristicMixed, HeuristicHazard {
        boolean bl3 = false;
        if (this.logRecord != null) {
            this.logRecord.write(true);
        }
        for (int i = 0; i < this.nRes; ++i) {
            if ((ResourceStatus)this.resourceStates.elementAt(i) != ResourceStatus.Heuristic) continue;
            Resource resource = (Resource)this.resourceObjects.elementAt(i);
            if (!(resource instanceof OTSResourceImpl)) {
                ProxyChecker proxyChecker = Configuration.getProxyChecker();
                bl3 = proxyChecker.isProxy(resource);
            }
            int n2 = n;
            boolean bl4 = true;
            while (bl4) {
                try {
                    resource.forget();
                    bl4 = false;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof INV_OBJREF || throwable instanceof OBJECT_NOT_EXIST) {
                        bl4 = false;
                        continue;
                    }
                    if (!(throwable instanceof COMM_FAILURE) && !(throwable instanceof TRANSIENT)) {
                        bl4 = false;
                        continue;
                    }
                    if (n2 > 0 || bl) {
                        if (!bl) {
                            --n2;
                        }
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (Throwable throwable2) {}
                        continue;
                    }
                    _logger.log(Level.SEVERE, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(n), "forget"});
                    String string = LogFormatter.getLocalizedMessage(_logger, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(n), "forget"});
                    throw new INTERNAL(string);
                }
            }
            this.resourceStates.setElementAt(ResourceStatus.Completed, i);
            if (!bl3) continue;
            resource._release();
        }
        if (bl2) {
            HeuristicMixed heuristicMixed = new HeuristicMixed();
            throw heuristicMixed;
        }
        HeuristicHazard heuristicHazard = new HeuristicHazard();
        throw heuristicHazard;
    }

    void distributeSubcommit(Coordinator coordinator) throws TRANSACTION_ROLLEDBACK {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.nRes; ++i) {
            SubtransactionAwareResource subtransactionAwareResource;
            block5: {
                subtransactionAwareResource = (SubtransactionAwareResource)this.resourceObjects.elementAt(i);
                if (!(subtransactionAwareResource instanceof OTSResourceImpl)) {
                    ProxyChecker proxyChecker = Configuration.getProxyChecker();
                    bl2 = proxyChecker.isProxy(subtransactionAwareResource);
                }
                try {
                    subtransactionAwareResource.commit_subtransaction(coordinator);
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof TRANSACTION_ROLLEDBACK)) break block5;
                    bl = true;
                }
            }
            this.resourceStates.setElementAt(ResourceStatus.Completed, i);
            if (!bl2) continue;
            subtransactionAwareResource._release();
        }
        if (bl) {
            throw new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
        }
    }

    void distributeSubrollback() {
        boolean bl = false;
        for (int i = 0; i < this.nRes; ++i) {
            SubtransactionAwareResource subtransactionAwareResource = (SubtransactionAwareResource)this.resourceObjects.elementAt(i);
            if (!(subtransactionAwareResource instanceof OTSResourceImpl)) {
                ProxyChecker proxyChecker = Configuration.getProxyChecker();
                bl = proxyChecker.isProxy(subtransactionAwareResource);
            }
            try {
                subtransactionAwareResource.rollback_subtransaction();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.resourceStates.setElementAt(ResourceStatus.Completed, i);
            if (!bl) continue;
            subtransactionAwareResource._release();
        }
    }

    void commitOnePhase() throws HeuristicMixed, HeuristicHazard {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = true;
        if (commitRetries == -1 && commitRetryVar != null) {
            try {
                commitRetries = Integer.parseInt(commitRetryVar);
            }
            catch (Throwable throwable) {
                _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "CommitOnePhase commitRetryVar"});
                String string = LogFormatter.getLocalizedMessage(_logger, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "CommitOnePhase commitRetryVar"});
                throw new INTERNAL(string);
            }
            bl = false;
        }
        if (this.nRes > 1) {
            _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{"commitOnePhase", ">1 Resource"});
            String string = LogFormatter.getLocalizedMessage(_logger, "jts.exception_on_resource_operation", new java.lang.Object[]{"commitOnePhase", ">1 Resource"});
            throw new INTERNAL(string);
        }
        Resource resource = (Resource)this.resourceObjects.elementAt(0);
        if ((ResourceStatus)this.resourceStates.elementAt(0) != ResourceStatus.Registered) {
            return;
        }
        if (!(resource instanceof OTSResourceImpl)) {
            ProxyChecker proxyChecker = Configuration.getProxyChecker();
            bl4 = proxyChecker.isProxy(resource);
        }
        this.resourceStates.setElementAt(ResourceStatus.Completing, 0);
        int n = commitRetries;
        boolean bl9 = true;
        while (bl9) {
            try {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.logp(Level.FINEST, "RegisteredResources", "commitOnePhase()", "Before invoking commit_one_phase() on resource:" + resource);
                }
                resource.commit_one_phase();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.logp(Level.FINEST, "RegisteredResources", "commitOnePhase()", "After invoking commit_one_phase() on resource:" + resource);
                }
                this.resourceStates.setElementAt(ResourceStatus.Completed, 0);
                bl9 = false;
            }
            catch (Throwable throwable) {
                java.lang.Object object;
                if (throwable instanceof TRANSACTION_ROLLEDBACK) {
                    bl7 = true;
                    this.resourceStates.setElementAt(ResourceStatus.Completed, 0);
                    bl9 = false;
                    continue;
                }
                if (throwable instanceof HeuristicHazard) {
                    object = (XAException)throwable.getCause();
                    if (object != null && ((XAException)object).errorCode >= 100 && ((XAException)object).errorCode <= 107) {
                        bl7 = true;
                        this.resourceStates.setElementAt(ResourceStatus.Completed, 0);
                        bl9 = false;
                        continue;
                    }
                    bl3 = true;
                    bl2 = true;
                    bl9 = false;
                    bl5 = false;
                    continue;
                }
                if (throwable instanceof INV_OBJREF || throwable instanceof OBJECT_NOT_EXIST) {
                    this.resourceStates.setElementAt(ResourceStatus.Completed, 0);
                    bl9 = false;
                    continue;
                }
                if (throwable instanceof NotPrepared) {
                    _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "commit one phase"});
                    object = LogFormatter.getLocalizedMessage(_logger, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "commit one phase"});
                    throw new INTERNAL((String)object);
                }
                if (!(throwable instanceof TRANSIENT) && !(throwable instanceof COMM_FAILURE)) {
                    _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "commit one phase"});
                    object = LogFormatter.getLocalizedMessage(_logger, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "commit one phase"});
                    throw new INTERNAL((String)object);
                }
                if (n > 0 || bl) {
                    if (!bl) {
                        --n;
                    }
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Throwable throwable2) {}
                    continue;
                }
                _logger.log(Level.SEVERE, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commitOnePhase"});
                object = LogFormatter.getLocalizedMessage(_logger, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commitOnePhase"});
                throw new INTERNAL((String)object);
            }
        }
        if (bl2) {
            this.resourceStates.setElementAt(ResourceStatus.Heuristic, 0);
            if (this.logRecord != null) {
                this.logRecord.addObject(this.heuristicLogSection, resource);
            }
        } else {
            this.resourceStates.setElementAt(ResourceStatus.Completed, 0);
            if (bl4) {
                resource._release();
            }
        }
        if (bl3) {
            this.distributeForget(commitRetries, bl, bl5);
        }
        if (bl7) {
            throw new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
        }
    }

    public static void setCommitRetryVar(String string) {
        if (commitRetries == -1 && commitRetryVar != null) {
            try {
                commitRetries = Integer.parseInt(commitRetryVar);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

