/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorLogPool;
import com.sun.jts.CosTransactions.CoordinatorLogSection;
import com.sun.jts.CosTransactions.Log;
import com.sun.jts.CosTransactions.LogFile;
import com.sun.jts.CosTransactions.LogLSN;
import com.sun.jts.CosTransactions.LogUpcallTarget;
import com.sun.jts.CosTransactions.SectionPool;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

class CoordinatorLog
implements LogUpcallTarget {
    private static final int LOG_DEF_KEY_TRIGGER = 100;
    private static final int LOG_THRESHOLD = 10000;
    private static final int STRING_TO_REF_RETRIES = 20;
    private static LogFile logFile = null;
    private static Log log = null;
    private static Hashtable activeLogs = new Hashtable();
    private static Hashtable keypointLogs = new Hashtable();
    private static int tranCount = 0;
    private static int keypointTrigger = 100;
    private static boolean keypointInProgress = false;
    private static java.lang.Object keypointLock = new java.lang.Object();
    private static java.lang.Object keypointStateLock = new java.lang.Object();
    private Hashtable sectionMapping = null;
    private boolean rewriteRequired = false;
    private boolean writeDone = false;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");
    Long localTID = null;
    private ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(2000);
    private DataOutputStream dataOutput = new DataOutputStream(this.byteOutput);

    CoordinatorLog() {
        this.sectionMapping = new Hashtable();
    }

    public synchronized void finalize() {
        if (this.sectionMapping != null) {
            Enumeration enumeration = this.sectionMapping.elements();
            int n = this.sectionMapping.size();
            while (n-- > 0) {
                CoordinatorLogSection coordinatorLogSection = (CoordinatorLogSection)enumeration.nextElement();
                coordinatorLogSection.reUse();
            }
            this.sectionMapping.clear();
            this.sectionMapping = null;
        }
    }

    private synchronized void reUse() {
        if (this.sectionMapping != null) {
            Enumeration enumeration = this.sectionMapping.elements();
            int n = this.sectionMapping.size();
            while (n-- > 0) {
                CoordinatorLogSection coordinatorLogSection = (CoordinatorLogSection)enumeration.nextElement();
                coordinatorLogSection.reUse();
            }
            this.sectionMapping.clear();
        }
        this.rewriteRequired = false;
        this.writeDone = false;
        this.localTID = null;
        this.byteOutput.reset();
        CoordinatorLogPool.putCoordinatorLog(this);
    }

    CoordinatorLog(Long l) {
        this.localTID = l;
        if (l != 0L) {
            CoordinatorLog.addLog(l, this);
        }
    }

    synchronized java.lang.Object createSection(String string) {
        CoordinatorLogSection coordinatorLogSection = null;
        coordinatorLogSection = (CoordinatorLogSection)this.sectionMapping.get(string);
        if (coordinatorLogSection == null) {
            int n = string.length();
            coordinatorLogSection = SectionPool.getCoordinatorLogSection(string);
            if (coordinatorLogSection != null) {
                this.sectionMapping.put(string, coordinatorLogSection);
            }
        }
        return coordinatorLogSection;
    }

    synchronized boolean addObject(java.lang.Object object, Object object2) {
        boolean bl = true;
        if (object != null) {
            CoordinatorLogSection coordinatorLogSection = (CoordinatorLogSection)object;
            coordinatorLogSection.unwrittenEmpty = false;
            if (coordinatorLogSection.unwrittenObjects == null) {
                coordinatorLogSection.unwrittenObjects = new Vector(10, 10);
            }
            String string = null;
            try {
                string = Configuration.getORB().object_to_string(object2);
                coordinatorLogSection.unwrittenObjects.addElement(string);
            }
            catch (Throwable throwable) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    synchronized boolean addData(java.lang.Object object, byte[] byArray) {
        boolean bl = true;
        if (object != null) {
            CoordinatorLogSection coordinatorLogSection = (CoordinatorLogSection)object;
            coordinatorLogSection.unwrittenEmpty = false;
            if (coordinatorLogSection.unwrittenData == null) {
                coordinatorLogSection.unwrittenData = new Vector(4, 4);
            }
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            coordinatorLogSection.unwrittenData.addElement(byArray2);
        } else {
            bl = false;
        }
        return bl;
    }

    boolean write(boolean bl) {
        boolean bl2 = true;
        try {
            bl2 = this.formatLogRecords(bl);
        }
        catch (IOException iOException) {
            bl2 = false;
        }
        return bl2;
    }

    private synchronized boolean requireRewrite() {
        boolean bl = true;
        if (this.writeDone) {
            this.rewriteRequired = true;
        }
        return bl;
    }

    private boolean rewrite() {
        boolean bl = true;
        if (this.rewriteRequired) {
            try {
                bl = this.formatLogRecords(false);
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean reconstruct(DataInputStream dataInputStream) throws IOException {
        boolean bl = true;
        int n = dataInputStream.readUnsignedShort();
        while (--n >= 0) {
            java.lang.Object object;
            int n2;
            int n3 = dataInputStream.readUnsignedShort();
            if (n3 <= 0) continue;
            int n4 = dataInputStream.readUnsignedShort();
            int n5 = dataInputStream.readUnsignedShort();
            byte[] byArray = new byte[n3];
            dataInputStream.read(byArray);
            String string = new String(byArray);
            CoordinatorLogSection coordinatorLogSection = (CoordinatorLogSection)this.createSection(string);
            if (n4 > 0 && coordinatorLogSection.writtenObjects == null) {
                coordinatorLogSection.writtenObjects = new Vector(n4, 10);
            }
            for (n2 = 0; n2 < n4; ++n2) {
                n3 = dataInputStream.readUnsignedShort();
                byArray = new byte[n3];
                dataInputStream.read(byArray);
                object = new String(byArray);
                coordinatorLogSection.writtenObjects.addElement(object);
            }
            if (n5 > 0 && coordinatorLogSection.writtenData == null) {
                coordinatorLogSection.writtenData = new Vector(n5, 4);
            }
            for (n2 = 0; n2 < n5; ++n2) {
                n3 = dataInputStream.readUnsignedShort();
                object = new byte[n3];
                dataInputStream.read((byte[])object);
                coordinatorLogSection.writtenData.addElement(object);
            }
        }
        return bl;
    }

    java.lang.Object[] getObjects(java.lang.Object object) {
        java.lang.Object[] objectArray = null;
        if (object != null) {
            Object object2;
            int n;
            CoordinatorLogSection coordinatorLogSection = (CoordinatorLogSection)object;
            int n2 = 0;
            if (coordinatorLogSection.unwrittenObjects != null) {
                n2 = coordinatorLogSection.unwrittenObjects.size();
            }
            int n3 = 0;
            if (coordinatorLogSection.writtenObjects != null) {
                n3 = coordinatorLogSection.writtenObjects.size();
            }
            objectArray = new java.lang.Object[n2 + n3];
            int n4 = 0;
            ORB oRB = Configuration.getORB();
            for (n = 0; n < n3; ++n) {
                object2 = null;
                String string = (String)coordinatorLogSection.writtenObjects.elementAt(n);
                int n5 = 20;
                boolean bl = false;
                while (object2 == null && n5-- > 0 && !bl) {
                    try {
                        object2 = oRB.string_to_object(string);
                    }
                    catch (MARSHAL mARSHAL) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            _logger.log(Level.WARNING, "jts.wait_for_resync_complete_interrupted");
                            String string2 = LogFormatter.getLocalizedMessage(_logger, "jts.wait_for_resync_complete_interrupted");
                            throw new INTERNAL(string2);
                        }
                    }
                    catch (Throwable throwable) {
                        bl = true;
                    }
                }
                if (bl) continue;
                if (object2 != null) {
                    objectArray[n4++] = object2;
                    continue;
                }
                _logger.log(Level.SEVERE, "jts.unable_to_convert_object_reference_to_string_in_recovery");
                String string3 = LogFormatter.getLocalizedMessage(_logger, "jts.unable_to_convert_object_reference_to_string_in_recovery");
                throw new INTERNAL(string3);
            }
            for (n = 0; n < n2; ++n) {
                try {
                    object2 = oRB.string_to_object((String)coordinatorLogSection.unwrittenObjects.elementAt(n));
                    objectArray[n4++] = object2;
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return objectArray;
    }

    byte[][] getData(java.lang.Object object) {
        java.lang.Object object2 = null;
        if (object != null) {
            CoordinatorLogSection coordinatorLogSection = (CoordinatorLogSection)object;
            int n = 0;
            if (coordinatorLogSection.unwrittenData != null) {
                n = coordinatorLogSection.unwrittenData.size();
            }
            int n2 = 0;
            if (coordinatorLogSection.writtenData != null) {
                n2 = coordinatorLogSection.writtenData.size();
            }
            object2 = new byte[n + n2][];
            if (n > 0) {
                coordinatorLogSection.unwrittenData.copyInto((java.lang.Object[])object2);
            }
            for (int i = 0; i < n2; ++i) {
                object2[n++] = (byte[])coordinatorLogSection.writtenData.elementAt(i);
            }
        }
        return object2;
    }

    synchronized void setLocalTID(Long l) {
        boolean bl = l != 0L && (this.localTID == null || this.localTID == 0L);
        this.localTID = l;
        if (bl) {
            CoordinatorLog.addLog(l, this);
        }
    }

    private void formatSection(CoordinatorLogSection coordinatorLogSection, boolean bl, DataOutputStream dataOutputStream) throws IOException {
        java.lang.Object object;
        int n;
        if (coordinatorLogSection.unwrittenEmpty && (!bl || coordinatorLogSection.writtenEmpty)) {
            dataOutputStream.writeShort(0);
            return;
        }
        dataOutputStream.writeShort(coordinatorLogSection.sectionName.length());
        int n2 = 0;
        int n3 = 0;
        if (coordinatorLogSection.unwrittenObjects != null) {
            n2 = coordinatorLogSection.unwrittenObjects.size();
        }
        if (bl && coordinatorLogSection.writtenObjects != null) {
            n3 = coordinatorLogSection.writtenObjects.size();
        }
        dataOutputStream.writeShort(n2 + n3);
        int n4 = 0;
        int n5 = 0;
        if (coordinatorLogSection.unwrittenData != null) {
            n4 = coordinatorLogSection.unwrittenData.size();
        }
        if (bl && coordinatorLogSection.writtenData != null) {
            n5 = coordinatorLogSection.writtenData.size();
        }
        dataOutputStream.writeShort(n4 + n5);
        dataOutputStream.writeBytes(coordinatorLogSection.sectionName);
        for (n = 0; n < n3; ++n) {
            object = (String)coordinatorLogSection.writtenObjects.elementAt(n);
            dataOutputStream.writeShort(((String)object).length());
            dataOutputStream.writeBytes((String)object);
        }
        for (n = 0; n < n2; ++n) {
            object = (String)coordinatorLogSection.unwrittenObjects.elementAt(n);
            dataOutputStream.writeShort(((String)object).length());
            dataOutputStream.writeBytes((String)object);
            if (coordinatorLogSection.writtenObjects == null) {
                coordinatorLogSection.writtenObjects = new Vector(n2, 10);
            }
            coordinatorLogSection.writtenObjects.addElement(object);
        }
        if (n2 > 0) {
            coordinatorLogSection.unwrittenObjects.removeAllElements();
        }
        for (n = 0; n < n5; ++n) {
            object = (byte[])coordinatorLogSection.writtenData.elementAt(n);
            dataOutputStream.writeShort(((java.lang.Object)object).length);
            dataOutputStream.write((byte[])object);
        }
        for (n = 0; n < n4; ++n) {
            object = (byte[])coordinatorLogSection.unwrittenData.elementAt(n);
            dataOutputStream.writeShort(((java.lang.Object)object).length);
            dataOutputStream.write((byte[])object);
            if (coordinatorLogSection.writtenData == null) {
                coordinatorLogSection.writtenData = new Vector(n4, 4);
            }
            coordinatorLogSection.writtenData.addElement(object);
        }
        if (n4 > 0) {
            coordinatorLogSection.unwrittenData.removeAllElements();
        }
        coordinatorLogSection.unwrittenEmpty = true;
        coordinatorLogSection.writtenEmpty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean formatLogRecords(boolean bl) throws IOException {
        CoordinatorLog.openLog();
        if (logFile == null) {
            return false;
        }
        boolean bl2 = false;
        java.lang.Object object = keypointLock;
        synchronized (object) {
            CoordinatorLog coordinatorLog = this;
            synchronized (coordinatorLog) {
                this.byteOutput.reset();
                this.dataOutput.writeLong(this.localTID);
                this.dataOutput.writeShort(this.sectionMapping.size());
                Enumeration enumeration = this.sectionMapping.elements();
                int n = this.sectionMapping.size();
                while (n-- > 0) {
                    this.formatSection((CoordinatorLogSection)enumeration.nextElement(), this.rewriteRequired, this.dataOutput);
                }
                bl2 = logFile.write(bl ? 1 : 0, this.byteOutput.toByteArray(), this.rewriteRequired ? 3 : 0, null);
                this.rewriteRequired = false;
                this.writeDone = true;
            }
        }
        return bl2;
    }

    private static boolean openLog() {
        boolean bl = false;
        if (log == null && !(log = new Log()).initialise()) {
            log = null;
            _logger.log(Level.SEVERE, "jts.cannot_initialise_log");
            String string = LogFormatter.getLocalizedMessage(_logger, "jts.cannot_initialise_log");
            throw new INTERNAL(string);
        }
        String string = null;
        if (log != null && logFile == null && (string = Configuration.getServerName()) != null) {
            logFile = log.open(string, CoordinatorLogPool.getCoordinatorLog());
            if (logFile == null) {
                _logger.log(Level.SEVERE, "jts.cannot_open_log_file", string);
                String string2 = LogFormatter.getLocalizedMessage(_logger, "jts.cannot_open_log_file");
                throw new INTERNAL(string2);
            }
            Configuration.setLogFile(logFile);
        }
        bl = log != null && logFile != null;
        return bl;
    }

    static synchronized Enumeration getLogged() {
        Vector vector = null;
        Enumeration enumeration = null;
        if (CoordinatorLog.openLog()) {
            vector = logFile.getLogRecords();
            for (int i = 0; i < vector.size(); ++i) {
                byte[] byArray = (byte[])vector.elementAt(i);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                try {
                    Long l = new Long(dataInputStream.readLong());
                    CoordinatorLog coordinatorLog = (CoordinatorLog)activeLogs.get(l);
                    if (coordinatorLog == null) {
                        coordinatorLog = CoordinatorLogPool.getCoordinatorLog();
                        coordinatorLog.setLocalTID(l);
                    }
                    coordinatorLog.reconstruct(dataInputStream);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            enumeration = activeLogs.elements();
        } else {
            enumeration = new Hashtable().elements();
        }
        return enumeration;
    }

    private static boolean addLog(Long l, CoordinatorLog coordinatorLog) {
        boolean bl = true;
        activeLogs.put(l, coordinatorLog);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized boolean removeLog(Long l) {
        boolean bl = true;
        CoordinatorLog coordinatorLog = (CoordinatorLog)activeLogs.remove(l);
        if (coordinatorLog != null) {
            java.lang.Object object = keypointStateLock;
            synchronized (object) {
                if (keypointInProgress && keypointLogs != null) {
                    keypointLogs.put(l, null);
                }
            }
            if (coordinatorLog.writeDone) {
                ++tranCount;
            }
            coordinatorLog.reUse();
            if (tranCount >= keypointTrigger) {
                tranCount = 0;
                CoordinatorLog.keypoint();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void keypoint() {
        byte[] byArray = new byte[]{75, 69, 89, 69, 78, 68};
        LogLSN logLSN = new LogLSN();
        LogLSN logLSN2 = new LogLSN();
        boolean bl = false;
        Enumeration enumeration = keypointLock;
        synchronized (enumeration) {
            bl = CoordinatorLog.startKeypoint(logLSN2);
        }
        if (logLSN2.isNULL()) {
            return;
        }
        if (bl) {
            enumeration = keypointLogs.keys();
            while (enumeration.hasMoreElements()) {
                java.lang.Object object = keypointStateLock;
                synchronized (object) {
                    CoordinatorLog coordinatorLog = (CoordinatorLog)keypointLogs.get(enumeration.nextElement());
                    if (coordinatorLog != null) {
                        coordinatorLog.rewrite();
                    }
                }
            }
        }
        logFile.write(0, byArray, 2, logLSN);
        logFile.checkpoint(logLSN2);
        keypointInProgress = false;
        keypointLogs.clear();
    }

    public void upcall(int n) {
        CoordinatorLog.keypoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void finalizeAll() {
        boolean bl = false;
        java.lang.Object object = keypointStateLock;
        synchronized (object) {
            if (activeLogs != null) {
                if (activeLogs.size() == 0) {
                    bl = true;
                }
                activeLogs.clear();
                activeLogs = null;
            }
            if (logFile != null) {
                logFile.close(bl);
            }
            logFile = null;
            if (keypointLogs != null) {
                keypointLogs.clear();
            }
            keypointLogs = null;
        }
        keypointStateLock = null;
        keypointLock = null;
    }

    static synchronized boolean startKeypoint(LogLSN logLSN) {
        java.lang.Object object;
        boolean bl = false;
        if (keypointInProgress) {
            return false;
        }
        keypointInProgress = true;
        if (!CoordinatorLog.openLog()) {
            keypointInProgress = false;
            return false;
        }
        if (activeLogs.size() == 0) {
            bl = false;
        } else {
            object = activeLogs.elements();
            while (object.hasMoreElements()) {
                CoordinatorLog coordinatorLog = (CoordinatorLog)object.nextElement();
                Long l = coordinatorLog.localTID;
                coordinatorLog.requireRewrite();
                keypointLogs.put(l, coordinatorLog);
            }
            bl = keypointLogs.size() > 0;
        }
        object = new byte[]{75, 69, 89, 83, 84, 65, 82, 84};
        logFile.write(0, (byte[])object, 1, logLSN);
        return bl;
    }

    static void dumpClass() {
        log.dump();
        logFile.dump();
    }

    void dump() {
        if (this.sectionMapping != null) {
            Enumeration enumeration = this.sectionMapping.elements();
            while (enumeration.hasMoreElements()) {
                java.lang.Object object;
                Enumeration enumeration2;
                CoordinatorLogSection coordinatorLogSection = (CoordinatorLogSection)enumeration.nextElement();
                if (coordinatorLogSection.writtenObjects != null) {
                    enumeration2 = coordinatorLogSection.writtenObjects.elements();
                    while (enumeration2.hasMoreElements()) {
                        object = (String)enumeration2.nextElement();
                    }
                }
                if (coordinatorLogSection.unwrittenObjects != null) {
                    enumeration2 = coordinatorLogSection.unwrittenObjects.elements();
                    while (enumeration2.hasMoreElements()) {
                        object = (String)enumeration2.nextElement();
                    }
                }
                if (coordinatorLogSection.writtenData != null) {
                    enumeration2 = coordinatorLogSection.writtenData.elements();
                    while (enumeration2.hasMoreElements()) {
                        object = (byte[])enumeration2.nextElement();
                    }
                }
                if (coordinatorLogSection.unwrittenData == null) continue;
                enumeration2 = coordinatorLogSection.unwrittenData.elements();
                while (enumeration2.hasMoreElements()) {
                    object = (byte[])enumeration2.nextElement();
                }
            }
        }
    }

    public static void setKeypointTrigger(int n) {
        keypointTrigger = n;
    }

    static {
        String string = Configuration.getPropertyValue("com.sun.jts.keypointCount");
        keypointTrigger = 100;
        if (string != null) {
            try {
                keypointTrigger = Integer.parseInt(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

