/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbExternalDescriptor;
import com.sun.enterprise.deployment.EjbExternalEntityDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.acl.Group;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.tools.packager.ComponentPackager;
import com.sun.enterprise.util.BeanMethodCalculator;
import com.sun.enterprise.util.FileClassLoader;
import com.sun.enterprise.util.NiceProperties;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;

public class PropsToXmlConverter {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private Hashtable ejbReferencesToConvert = new Hashtable();
    private static final String MESSAGE_SELECTOR_PROP = "message-selector";
    private static final String MSG_BEAN_DEST_TYPE_PROP = "dest-type";
    private static final String QUEUE_DEST_TYPE = "Queue";
    private static final String TOPIC_DEST_TYPE = "Topic";
    private static final String DURABLE_SUBSCRIPTION_NAME_PROP = "subscription-name";
    private static final String JMS_CLIENT_ID = "jms-client-id";
    private static final String MDB_CONNECTION_FACTORY = "mdb-connection-factory";
    private static final String JMS_ACKNOWLEDGE_MODE_PROP = "acknowledge-mode";
    private static final String AUTO_ACKNOWLEDGE_MODE = "AUTO_ACKNOWLEDGE";
    private static final String DUPS_OK_MODE = "DUPS_OK";
    static /* synthetic */ Class class$javax$jms$Message;

    public static void writeXmlToFiles(Application application, String string, String string2, String string3) throws IOException {
        XmlDocument xmlDocument = null;
        Object var5_5 = null;
        File file = null;
        file = "".equals(string2) ? new File(ComponentPackager.getEjbBundleFilename(string)) : new File(string2);
        EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)application.getEjbBundleDescriptors().iterator().next();
        xmlDocument = EjbBundleNode.getDocument(ejbBundleDescriptor);
        XMLUtils.writeDocumentToFile((Document)xmlDocument, file);
        xmlDocument = RuntimeDescriptorNode.getDocument(application);
        file = "".equals(string3) ? new File(ComponentPackager.getRuntimeDescriptorFilename(string)) : new File(string3);
        XMLUtils.writeDocumentToFile((Document)xmlDocument, file);
        xmlDocument = ApplicationNode.getDocument(application);
        file = new File(string);
        XMLUtils.writeDocumentToFile((Document)xmlDocument, file);
    }

    private void convertEnvironmentProperties(String string, Properties properties, EjbDescriptor ejbDescriptor) throws IOException {
        int n = Integer.parseInt(properties.getProperty(string + "#envProps"));
        HashSet hashSet = new HashSet();
        for (int i = 0; i < n; ++i) {
            Object object;
            String string2 = string + "envProps" + i + ".";
            String string3 = properties.getProperty(string2 + "name");
            String string4 = properties.getProperty(string2 + "type");
            String string5 = properties.getProperty(string2 + "value");
            if (string3 == null) {
                throw new IOException("Bad envProps count or envProps key");
            }
            String string6 = string2 + "isRoleRef";
            String string7 = string2 + "isEjbReference";
            String string8 = string2 + "isJmsDestinationReference";
            String string9 = string2 + "isResourceEnvReference";
            if (properties.getProperty(string6) != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, string3 + " is a role ref ");
                }
                object = new RoleReference(string3, "");
                ((EnvironmentProperty)object).setValue(string5);
                ejbDescriptor.addRoleReference((RoleReference)object);
                continue;
            }
            if (properties.getProperty(string7) != null) {
                object = string2 + "ejbReference.";
                this.ejbReferencesToConvert.put(string2, ejbDescriptor);
                continue;
            }
            if (properties.getProperty(string8) != null || properties.getProperty(string9) != null) {
                if (properties.getProperty(string8) != null) {
                    _logger.log(Level.WARNING, "enterprise_util.isjmsdestinationreference_deprec");
                }
                object = new JmsDestinationReferenceDescriptor(string3, "", string4);
                ((JmsDestinationReferenceDescriptor)object).setJndiName(string5);
                ejbDescriptor.addJmsDestinationReferenceDescriptor((JmsDestinationReferenceDescriptor)object);
                continue;
            }
            object = new EnvironmentProperty(string3, string5, "");
            if (string4 != null) {
                ((EnvironmentProperty)object).setType(string4);
            }
            ejbDescriptor.addEnvironmentProperty((EnvironmentProperty)object);
        }
    }

    private void convertEjbReference(EjbBundleDescriptor ejbBundleDescriptor, Properties properties, String string, EjbDescriptor ejbDescriptor) {
        _logger.log(Level.FINE, "\n");
        String string2 = string + "ejbReference.";
        String string3 = properties.getProperty(string + "name");
        String string4 = properties.getProperty(string + "value");
        boolean bl = false;
        if ("true".equals(properties.getProperty(string2 + "isEjbLink"))) {
            bl = true;
        }
        String string5 = properties.getProperty(string2 + "type");
        String string6 = properties.getProperty(string2 + "homeInterface");
        String string7 = properties.getProperty(string2 + "remoteInterface");
        boolean bl2 = false;
        if (properties.getProperty(string2 + "isLocal") != null) {
            bl2 = new Boolean(properties.getProperty(string2 + "isLocal"));
        }
        if (bl) {
            String string8 = properties.getProperty(string2 + "ejbLink");
            EjbDescriptor ejbDescriptor2 = null;
            if (ejbBundleDescriptor.hasEjbByName(string8)) {
                ejbDescriptor2 = ejbBundleDescriptor.getEjbByName(string8);
            }
            if (ejbDescriptor2 == null) {
                EjbExternalDescriptor ejbExternalDescriptor = new EjbExternalDescriptor();
                ejbExternalDescriptor.setName("name ??");
                if (bl2) {
                    ejbExternalDescriptor.setLocalHomeClassName(string6);
                    ejbExternalDescriptor.setLocalClassName(string7);
                } else {
                    ejbExternalDescriptor.setHomeClassName(string6);
                    ejbExternalDescriptor.setRemoteClassName(string7);
                }
                ejbExternalDescriptor.setType(string5);
                ejbExternalDescriptor.setLinkName(string8);
                EjbReferenceDescriptor ejbReferenceDescriptor = new EjbReferenceDescriptor(string3, "", ejbExternalDescriptor, bl2);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Adding internal UNRESOLVED reference " + ejbReferenceDescriptor);
                }
                ejbDescriptor.addEjbReferenceDescriptor(ejbReferenceDescriptor);
            } else {
                EjbReferenceDescriptor ejbReferenceDescriptor = new EjbReferenceDescriptor(string3, "", ejbDescriptor2, bl2);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Adding internal RESOLVED reference " + ejbReferenceDescriptor);
                }
                ejbDescriptor.addEjbReferenceDescriptor(ejbReferenceDescriptor);
            }
        } else {
            if (bl2) {
                throw new RuntimeException("ejbLink must be provided in local reference " + string2);
            }
            EjbExternalDescriptor ejbExternalDescriptor = new EjbExternalDescriptor();
            ejbExternalDescriptor.setName("name ??");
            ejbExternalDescriptor.setHomeClassName(string6);
            ejbExternalDescriptor.setRemoteClassName(string7);
            ejbExternalDescriptor.setType(string5);
            ejbExternalDescriptor.setJndiName(string4);
            EjbReferenceDescriptor ejbReferenceDescriptor = new EjbReferenceDescriptor(string3, "", ejbExternalDescriptor, bl2);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Adding external reference " + ejbReferenceDescriptor);
            }
            ejbDescriptor.addEjbReferenceDescriptor(ejbReferenceDescriptor);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convertToXml(File file, String string, String string2, String string3, String string4) throws Throwable {
        String string5;
        String string6;
        Serializable serializable;
        Object object;
        int n;
        Serializable serializable2;
        String string7;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Convert : " + file + " to XML");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        NiceProperties niceProperties = new NiceProperties();
        niceProperties.load(fileInputStream);
        FileClassLoader fileClassLoader = new FileClassLoader(string);
        String string8 = ((Properties)niceProperties).getProperty("application.name");
        Application application = new Application(string8, new File(string8 + ".jar"));
        application.getApplicationArchivist().setClassLoader(fileClassLoader);
        EjbBundleDescriptor ejbBundleDescriptor = new EjbBundleDescriptor();
        application.addEjbBundleDescriptor(ejbBundleDescriptor);
        String string9 = ((Properties)niceProperties).getProperty("ejbclientjaruri");
        if (string9 != null) {
            ejbBundleDescriptor.setEjbClientJarUri(string9);
        }
        if ((string7 = ((Properties)niceProperties).getProperty("archiveuri")) != null) {
            ejbBundleDescriptor.getArchivist().setArchiveUri(string7);
        } else {
            ejbBundleDescriptor.getArchivist().setArchiveUri("");
        }
        if (((Properties)niceProperties).getProperty("rolecount") != null) {
            _logger.log(Level.FINE, "This ejb jar has assembly descriptor roles");
            serializable2 = application.getRoleMapper();
            n = Integer.parseInt(((Properties)niceProperties).getProperty("rolecount"));
            for (int i = 0; i < n; ++i) {
                object = "role" + i + ".name";
                serializable = new Role(((Properties)niceProperties).getProperty((String)object));
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "-adding role: " + serializable);
                }
                string6 = "role" + i + ".users";
                string5 = "role" + i + ".groups";
                if (((Properties)niceProperties).getProperty(string6) != null) {
                    PropsToXmlConverter.makeUserRoleMapping((RoleMapper)serializable2, (Role)serializable, ((Properties)niceProperties).getProperty(string6));
                }
                if (((Properties)niceProperties).getProperty(string5) != null) {
                    PropsToXmlConverter.makeGroupRoleMapping((RoleMapper)serializable2, (Role)serializable, ((Properties)niceProperties).getProperty(string5));
                }
                ejbBundleDescriptor.addRole((Role)serializable);
            }
        }
        if (((Properties)niceProperties).getProperty("cmp.DBJndiName") != null) {
            serializable2 = new ResourceReferenceDescriptor();
            ((ResourceReferenceDescriptor)serializable2).setJndiName(((Properties)niceProperties).getProperty("cmp.DBJndiName"));
            ((ResourceReferenceDescriptor)serializable2).setResourcePrincipal(PropsToXmlConverter.parseResourcePrincipalFromString(((Properties)niceProperties).getProperty("cmp.defaultDBAccount")));
            ejbBundleDescriptor.setCMPResourceReference((ResourceReferenceDescriptor)serializable2);
        }
        int n2 = Integer.parseInt(((Properties)niceProperties).getProperty("ejbcount"));
        for (n = 0; n < n2; ++n) {
            Object object2;
            Object object3;
            Object object4;
            void var26_39;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            String string10;
            String string11 = "ejb" + n + ".";
            object = ((Properties)niceProperties).getProperty(string11 + "type");
            serializable = ((String)object).equalsIgnoreCase(EjbSessionDescriptor.TYPE) ? new EjbSessionDescriptor() : (((String)object).equalsIgnoreCase(EjbEntityDescriptor.TYPE) ? ((string6 = (string6 = ((Properties)niceProperties).getProperty(string11 + "entity.persistenceType")) == null ? EjbEntityDescriptor.BEAN_PERSISTENCE : string6.trim()).equals(EjbEntityDescriptor.BEAN_PERSISTENCE) ? new EjbEntityDescriptor() : new EjbCMPEntityDescriptor()) : new EjbMessageBeanDescriptor());
            this.createIORConfigurationDescriptor((EjbDescriptor)serializable, string11, niceProperties);
            this.createIORConfigDescriptors((EjbDescriptor)serializable, string11, niceProperties);
            string6 = ((Properties)niceProperties).getProperty(string11 + "logicalName");
            if (string6 != null) {
                ((Descriptor)serializable).setName(string6);
            }
            string5 = ((Properties)niceProperties).getProperty(string11 + "name");
            ((EjbDescriptor)serializable).setEjbClassName(string5);
            Class<?> clazz = fileClassLoader.loadClass(string5);
            ((EjbAbstractDescriptor)serializable).setJndiName(((Properties)niceProperties).getProperty(string11 + "JNDIName"));
            if (((String)object).equalsIgnoreCase("Message-driven")) {
                String string12;
                EjbMessageBeanDescriptor ejbMessageBeanDescriptor = (EjbMessageBeanDescriptor)serializable;
                string10 = ((Properties)niceProperties).getProperty(string11 + MESSAGE_SELECTOR_PROP);
                if (string10 != null) {
                    ejbMessageBeanDescriptor.setJmsMessageSelector(string10);
                }
                if ((object9 = ((Properties)niceProperties).getProperty(string11 + JMS_CLIENT_ID)) != null) {
                    _logger.log(Level.WARNING, "enterprise_util.prop_jms_client_id_deprec");
                }
                if ((object8 = ((Properties)niceProperties).getProperty(string11 + MDB_CONNECTION_FACTORY)) != null) {
                    ejbMessageBeanDescriptor.setConnectionFactoryName((String)object8);
                }
                if ((string12 = ((Properties)niceProperties).getProperty(string11 + MSG_BEAN_DEST_TYPE_PROP)) == null) throw new RuntimeException("Must specify the message bean destination type");
                if (string12.equals(QUEUE_DEST_TYPE)) {
                    ejbMessageBeanDescriptor.setHasQueueDest();
                    ejbMessageBeanDescriptor.setHasDurableSubscription(false);
                } else {
                    if (!string12.equals(TOPIC_DEST_TYPE)) throw new RuntimeException("Invalid message bean destination type : " + string12);
                    ejbMessageBeanDescriptor.setHasTopicDest();
                    object7 = ((Properties)niceProperties).getProperty(string11 + DURABLE_SUBSCRIPTION_NAME_PROP);
                    if (object7 != null) {
                        ejbMessageBeanDescriptor.setHasDurableSubscription(true);
                        ejbMessageBeanDescriptor.setDurableSubscriptionName((String)object7);
                    } else {
                        ejbMessageBeanDescriptor.setHasDurableSubscription(false);
                    }
                }
                object7 = ((Properties)niceProperties).getProperty(string11 + JMS_ACKNOWLEDGE_MODE_PROP);
                if (object7 != null) {
                    object6 = ((Properties)niceProperties).getProperty(string11 + "transactionAttribute");
                    if (((String)object6).equals("TX_BEAN_MANAGED")) {
                        if (((String)object7).equals(AUTO_ACKNOWLEDGE_MODE)) {
                            ejbMessageBeanDescriptor.setJmsAcknowledgeMode(1);
                        } else {
                            if (!((String)object7).equals(DUPS_OK_MODE)) throw new RuntimeException("Invalid ack mode = " + (String)object7);
                            ejbMessageBeanDescriptor.setJmsAcknowledgeMode(3);
                        }
                    } else {
                        _logger.log(Level.WARNING, "enterprise_util.mdb_with_cmt_jms_ack");
                    }
                }
            } else {
                this.convertInterfaces(string11, niceProperties, (EjbAbstractDescriptor)serializable);
            }
            this.convertEnvironmentProperties(string11, niceProperties, (EjbDescriptor)serializable);
            int n3 = Integer.parseInt(((Properties)niceProperties).getProperty(string11 + "#methodDescriptors"));
            string10 = ((Properties)niceProperties).getProperty(string11 + "transactionAttribute");
            if (string10.equals("TX_BEAN_MANAGED")) {
                _logger.log(Level.WARNING, "enterprise_util.entity_bmt_n_session_mlt");
                ((EjbDescriptor)serializable).setTransactionType(EjbSessionDescriptor.BEAN_TRANSACTION_TYPE);
            } else {
                ((EjbDescriptor)serializable).setTransactionType(EjbSessionDescriptor.CONTAINER_TRANSACTION_TYPE);
                object9 = PropsToXmlConverter.convertTransactionAttribute(string10);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "You have entered the bean level transaction attribute of " + string10);
                    _logger.log(Level.FINE, "This is being interpreted as follows:");
                    _logger.log(Level.FINE, "1) The bean level transaction attribute is 'Container'");
                    _logger.log(Level.FINE, "2) The default for all the method level container transactions is " + (String)object9);
                    _logger.log(Level.FINE, "3) This default for each method is overridden by any method level transaction attribute you specify elsewhere in the props file");
                }
                if (((String)object).equalsIgnoreCase("Message-driven")) {
                    if (!((String)object9).equals(ContainerTransaction.NOT_SUPPORTED) && !((String)object9).equals(ContainerTransaction.REQUIRED)) throw new RuntimeException("ERROR : TX ATTRIBUTE '" + (String)object9 + "' is not valid for message-driven beans");
                    object8 = new ContainerTransaction((String)object9, "");
                    Class[] classArray = new Class[]{class$javax$jms$Message == null ? PropsToXmlConverter.class$("javax.jms.Message") : class$javax$jms$Message};
                    object7 = clazz.getMethod("onMessage", classArray);
                    ((EjbDescriptor)serializable).setContainerTransactionFor((Method)object7, (ContainerTransaction)object8);
                } else {
                    object8 = BeanMethodCalculator.getTransactionalMethodsFor((EjbDescriptor)serializable, fileClassLoader);
                    Iterator iterator = object8.iterator();
                    while (iterator.hasNext()) {
                        object7 = (Method)iterator.next();
                        object6 = new MethodDescriptor((Method)object7, (EjbDescriptor)serializable, fileClassLoader);
                        object5 = new ContainerTransaction((String)object9, "");
                        ((EjbDescriptor)serializable).getMethodContainerTransactions().put(object6, object5);
                    }
                }
            }
            object9 = new Vector();
            object8 = BeanMethodCalculator.getTransactionalMethodsFor((EjbDescriptor)serializable, fileClassLoader);
            Iterator iterator = object8.iterator();
            while (iterator.hasNext()) {
                object7 = (Method)iterator.next();
                ((Vector)object9).add(new MethodDescriptor((Method)object7, (EjbDescriptor)serializable, fileClassLoader));
            }
            boolean bl = false;
            while (var26_39 < n3) {
                object7 = string11 + "mdesc" + (int)var26_39 + ".";
                object6 = this.convertMethodDescriptor((String)object7, niceProperties, fileClassLoader, (EjbDescriptor)serializable);
                object5 = ((MethodDescriptor)object6).doStyleConversion((EjbDescriptor)serializable, (Collection)object9);
                string10 = ((Properties)niceProperties).getProperty((String)object7 + "transactionAttribute");
                object4 = PropsToXmlConverter.convertTransactionAttribute(string10);
                object3 = new ContainerTransaction((String)object4, "");
                Iterator iterator2 = ((Vector)object5).iterator();
                while (iterator2.hasNext()) {
                    object2 = (MethodDescriptor)iterator2.next();
                    ((EjbDescriptor)serializable).getMethodContainerTransactions().put(object2, object3);
                }
                ++var26_39;
            }
            if (((String)object).equalsIgnoreCase(EjbSessionDescriptor.TYPE)) {
                EjbSessionDescriptor ejbSessionDescriptor = (EjbSessionDescriptor)serializable;
                object7 = ((Properties)niceProperties).getProperty(string11 + "session.state");
                if (((String)object7).equals("STATEFUL_SESSION")) {
                    ejbSessionDescriptor.setStateless(false);
                } else if (((String)object7).equals("STATELESS_SESSION")) {
                    ejbSessionDescriptor.setStateless(true);
                }
            } else if (((String)object).equalsIgnoreCase(EjbEntityDescriptor.TYPE)) {
                EjbEntityDescriptor ejbEntityDescriptor = (EjbEntityDescriptor)serializable;
                object7 = string11 + "entity.";
                object6 = ((Properties)niceProperties).getProperty((String)object7 + "primaryKey");
                ejbEntityDescriptor.setPrimaryKeyClassName((String)object6);
                object5 = ((Properties)niceProperties).getProperty(string11 + "isReentrant");
                if (object5 != null && "true".equals(object5)) {
                    ejbEntityDescriptor.setReentrant(true);
                }
                if (ejbEntityDescriptor instanceof EjbCMPEntityDescriptor) {
                    object4 = (EjbCMPEntityDescriptor)ejbEntityDescriptor;
                    object3 = ((Properties)niceProperties).getProperty((String)object7 + "cmpVersion");
                    object3 = object3 == null ? EjbCMPEntityDescriptor.CMP_1_VERSION : ((String)object3).trim();
                    ((EjbCMPEntityDescriptor)object4).setCMPVersion((String)object3);
                    boolean bl2 = false;
                    if (((String)object3).equals(EjbCMPEntityDescriptor.CMP_2_VERSION)) {
                        bl2 = true;
                    }
                    if (bl2) {
                        object2 = ((Properties)niceProperties).getProperty((String)object7 + "abstractSchemaName");
                        if (object2 == null) {
                            throw new IOException("Need entity.abstractSchemaName for EJB2.0 CMP EntityBean");
                        }
                        object2 = ((String)object2).trim();
                        ((EjbCMPEntityDescriptor)object4).setAbstractSchemaName((String)object2);
                    }
                    object2 = this.loadPersistenceDescriptor((String)object7, niceProperties, fileClassLoader, bl2);
                    ((EjbCMPEntityDescriptor)object4).setPersistenceDescriptor((PersistenceDescriptor)object2);
                    String string13 = ((Properties)niceProperties).getProperty((String)object7 + "primaryKeyField");
                    if (string13 != null) {
                        ((EjbCMPEntityDescriptor)object4).setPrimaryKeyFieldDesc(new FieldDescriptor(string13, ""));
                    }
                    if (((Properties)niceProperties).getProperty(string11 + "entity.DBJndiName") != null) {
                        ResourceReferenceDescriptor resourceReferenceDescriptor = new ResourceReferenceDescriptor();
                        resourceReferenceDescriptor.setJndiName(((Properties)niceProperties).getProperty(string11 + "entity.DBJndiName"));
                        resourceReferenceDescriptor.setResourcePrincipal(PropsToXmlConverter.parseResourcePrincipalFromString(((Properties)niceProperties).getProperty(string11 + "entity.defaultDBAccount")));
                        ejbBundleDescriptor.setCMPResourceReference(resourceReferenceDescriptor);
                    }
                }
            }
            this.convertResourceReferences(string11, niceProperties, (EjbDescriptor)serializable);
            _logger.log(Level.FINE, "Adding an XML EJB descriptor to the application...");
            ejbBundleDescriptor.addEjb((EjbDescriptor)serializable);
            this.convertMethodPermissions(string11, niceProperties, (EjbDescriptor)serializable, fileClassLoader);
            String string14 = ((Properties)niceProperties).getProperty(string11 + "runAsRole");
            object7 = ((Properties)niceProperties).getProperty(string11 + "runAsPrincipal");
            if (string14 != null) {
                object6 = new RunAsIdentityDescriptor();
                ((RunAsIdentityDescriptor)object6).setRoleName(string14);
                ((RunAsIdentityDescriptor)object6).setPrincipal((String)object7);
                ((EjbDescriptor)serializable).setUsesCallerIdentity(false);
                ((EjbDescriptor)serializable).setRunAsIdentity((RunAsIdentityDescriptor)object6);
                continue;
            }
            if (!(serializable instanceof EjbMessageBeanDescriptor)) continue;
            ((EjbDescriptor)serializable).setUsesCallerIdentity(false);
        }
        if (!ejbBundleDescriptor.areResourceReferencesValid()) {
            throw new RuntimeException("Make sure that if you declare an env prop to be a role reference, the value of the prop must be a declared role");
        }
        Enumeration enumeration = this.ejbReferencesToConvert.keys();
        while (enumeration.hasMoreElements()) {
            String string15 = (String)enumeration.nextElement();
            object = (EjbDescriptor)this.ejbReferencesToConvert.get(string15);
            this.convertEjbReference(((EjbDescriptor)object).getEjbBundleDescriptor(), niceProperties, string15, (EjbDescriptor)object);
        }
        this.convertRemoteEntityRefs(ejbBundleDescriptor, niceProperties);
        this.convertRelationships(ejbBundleDescriptor, niceProperties);
        PropsToXmlConverter.writeXmlToFiles(application, string2, string3, string4);
        if (!_logger.isLoggable(Level.FINE)) return;
        _logger.log(Level.FINE, "Done: XML deployment descriptor for " + application.getName() + " has been written to " + string2);
    }

    private void convertInterfaces(String string, Properties properties, EjbAbstractDescriptor ejbAbstractDescriptor) {
        String string2;
        String string3 = properties.getProperty(string + "homeInterface");
        if (string3 != null) {
            if (properties.getProperty(string + "remoteInterface") == null) {
                throw new RuntimeException("Home interface " + string3 + " present but not remote interface is defined");
            }
            ejbAbstractDescriptor.setHomeClassName(string3);
            ejbAbstractDescriptor.setRemoteClassName(properties.getProperty(string + "remoteInterface"));
        }
        if ((string2 = properties.getProperty(string + "localHomeInterface")) != null) {
            if (properties.getProperty(string + "localInterface") == null) {
                throw new RuntimeException("Local Home interface " + string3 + " present but not local interface is defined");
            }
            ejbAbstractDescriptor.setLocalHomeClassName(string2);
            ejbAbstractDescriptor.setLocalClassName(properties.getProperty(string + "localInterface"));
        }
        if (string3 == null && string2 == null) {
            throw new RuntimeException("Session or Entity beans should define at least a local or remote interface");
        }
    }

    private PersistenceDescriptor loadPersistenceDescriptor(String string, Properties properties, ClassLoader classLoader, boolean bl) throws IOException {
        Object object;
        Object object2;
        Object object3;
        String string2;
        String string3;
        Object object4;
        String string4;
        Object object5;
        String string5 = properties.getProperty(string + "#containerFields");
        HashSet<FieldDescriptor> hashSet = new HashSet<FieldDescriptor>();
        if (string5 != null) {
            int n = Integer.parseInt(string5);
            for (int i = 0; i < n; ++i) {
                String string6 = string + "containerField" + i;
                object5 = properties.getProperty(string6);
                if (bl) {
                    FieldDescriptor.checkFieldName((String)object5);
                }
                FieldDescriptor fieldDescriptor = new FieldDescriptor((String)object5, "");
                hashSet.add(fieldDescriptor);
            }
        }
        PersistenceDescriptor persistenceDescriptor = new PersistenceDescriptor();
        persistenceDescriptor.setCMPFields(hashSet);
        String string7 = properties.getProperty(string + "#pkFields");
        if (string7 != null && !string7.equals("")) {
            int n = Integer.parseInt(string7);
            object5 = new HashSet();
            for (int i = 0; i < n; ++i) {
                String string8 = string + "pkField" + i;
                string4 = properties.getProperty(string8);
                object4 = new FieldDescriptor(string4, "");
                if (string4 == null) {
                    throw new IOException("Bad pkField count or pkField key");
                }
                object5.add(object4);
            }
            persistenceDescriptor.setPkeyFields((Set)object5);
        }
        if ((string3 = properties.getProperty(string + "createTableOnDeployment")) != null) {
            persistenceDescriptor.setCreateTableOnDeployment(new Boolean(string3));
        }
        if ((object5 = properties.getProperty(string + "deleteTableOnUndeployment")) != null) {
            persistenceDescriptor.setDeleteTableOnUndeployment(new Boolean((String)object5));
        }
        if (properties.getProperty(string + "#sqlStatements") != null) {
            int n = Integer.parseInt(properties.getProperty(string + "#sqlStatements"));
            for (int i = 0; i < n; ++i) {
                string4 = string + "sqlStatement" + i + ".";
                object4 = properties.getProperty(string4 + "sql");
                string2 = properties.getProperty(string4 + "operation");
                if (string2 != null) {
                    persistenceDescriptor.setSqlStatementFor(string2.trim(), (String)object4);
                    continue;
                }
                object3 = new QueryDescriptor();
                ((QueryDescriptor)object3).setSQL((String)object4);
                object2 = string4 + "mdesc.";
                try {
                    object = this.convertMethod((String)object2, properties, classLoader);
                    ((QueryDescriptor)object3).setQueryMethod((Method)object);
                    persistenceDescriptor.setQueryFor((Method)object, (QueryDescriptor)object3);
                    continue;
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
        }
        if (properties.getProperty(string + "#queries") != null) {
            int n = Integer.parseInt(properties.getProperty(string + "#queries"));
            for (int i = 0; i < n; ++i) {
                string4 = string + "query" + i + ".";
                object4 = properties.getProperty(string4 + "sql");
                string2 = properties.getProperty(string4 + "description");
                object3 = properties.getProperty(string4 + "result-type-mapping");
                object2 = new QueryDescriptor();
                ((QueryDescriptor)object2).setSQL((String)object4);
                object = properties.getProperty(string4 + "ejbql");
                if (object != null) {
                    ((QueryDescriptor)object2).setQuery(((String)object).trim());
                }
                if (string2 != null) {
                    ((Descriptor)object2).setDescription(string2);
                }
                if (object3 != null) {
                    if (((String)object3).equalsIgnoreCase("remote")) {
                        ((QueryDescriptor)object2).setHasRemoteReturnTypeMapping();
                    } else if (((String)object3).equalsIgnoreCase("local")) {
                        ((QueryDescriptor)object2).setHasLocalReturnTypeMapping();
                    } else {
                        throw new RuntimeException(string4 + "result-type-mapping" + " does not have an acceptable value : " + (String)object3);
                    }
                }
                String string9 = string4 + "mdesc.";
                try {
                    Method method = this.convertMethod(string9, properties, classLoader);
                    ((QueryDescriptor)object2).setQueryMethod(method);
                    persistenceDescriptor.setQueryFor(method, (QueryDescriptor)object2);
                    continue;
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
        }
        return persistenceDescriptor;
    }

    private void createIORConfigurationDescriptor(EjbDescriptor ejbDescriptor, String string, Properties properties) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        int n;
        String string10 = string + "#methodPermissions";
        String string11 = properties.getProperty(string10);
        boolean bl = false;
        if (string11 != null && (n = Integer.parseInt(string11)) > 0) {
            bl = true;
        }
        EjbIORConfigurationDescriptor ejbIORConfigurationDescriptor = new EjbIORConfigurationDescriptor();
        if (bl) {
            ejbIORConfigurationDescriptor.setAuthMethodRequired(true);
        }
        if ((string9 = properties.getProperty(string + "integrity")) != null) {
            ejbIORConfigurationDescriptor.setIntegrity(string9);
        }
        if ((string8 = properties.getProperty(string + "confidentiality")) != null) {
            ejbIORConfigurationDescriptor.setConfidentiality(string8);
        }
        if ((string7 = properties.getProperty(string + "establishTrustInTarget")) != null) {
            ejbIORConfigurationDescriptor.setEstablishTrustInTarget(string7);
        }
        if ((string6 = properties.getProperty(string + "establishTrustInClient")) != null) {
            ejbIORConfigurationDescriptor.setEstablishTrustInClient(string6);
        }
        if ((string5 = properties.getProperty(string + "authMethod")) != null) {
            ejbIORConfigurationDescriptor.setAuthenticationMethod(string5);
        }
        if ((string4 = properties.getProperty(string + "realmName")) != null) {
            ejbIORConfigurationDescriptor.setRealmName(string4);
        }
        if ((string3 = properties.getProperty(string + "authRequired")) != null) {
            if (string3.equals("true")) {
                ejbIORConfigurationDescriptor.setAuthMethodRequired(true);
            } else {
                ejbIORConfigurationDescriptor.setAuthMethodRequired(false);
            }
        }
        if ((string2 = properties.getProperty(string + "callerPropagation")) != null) {
            ejbIORConfigurationDescriptor.setCallerPropagation(string2);
        }
        ejbDescriptor.addIORConfigurationDescriptor(ejbIORConfigurationDescriptor);
    }

    private void createIORConfigDescriptors(EjbDescriptor ejbDescriptor, String string, Properties properties) {
        String string2 = string + "interop.";
        int n = 0;
        if (properties.getProperty(string2 + "#parameters") != null) {
            n = Integer.parseInt(properties.getProperty(string2 + "#parameters"));
            ejbDescriptor.getIORConfigurationDescriptors().clear();
        }
        for (int i = 0; i < n; ++i) {
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10 = string + "interop" + i + ".";
            EjbIORConfigurationDescriptor ejbIORConfigurationDescriptor = new EjbIORConfigurationDescriptor();
            String string11 = properties.getProperty(string10 + "integrity");
            if (string11 != null) {
                ejbIORConfigurationDescriptor.setIntegrity(string11);
            }
            if ((string9 = properties.getProperty(string10 + "confidentiality")) != null) {
                ejbIORConfigurationDescriptor.setConfidentiality(string9);
            }
            if ((string8 = properties.getProperty(string10 + "establishTrustInTarget")) != null) {
                ejbIORConfigurationDescriptor.setEstablishTrustInTarget(string8);
            }
            if ((string7 = properties.getProperty(string10 + "establishTrustInClient")) != null) {
                ejbIORConfigurationDescriptor.setEstablishTrustInClient(string7);
            }
            if ((string6 = properties.getProperty(string10 + "authMethod")) != null) {
                ejbIORConfigurationDescriptor.setAuthenticationMethod(string6);
            }
            if ((string5 = properties.getProperty(string10 + "realmName")) != null) {
                ejbIORConfigurationDescriptor.setRealmName(string5);
            }
            if ((string4 = properties.getProperty(string10 + "authRequired")) != null) {
                if (string4.equals("true")) {
                    ejbIORConfigurationDescriptor.setAuthMethodRequired(true);
                } else {
                    ejbIORConfigurationDescriptor.setAuthMethodRequired(false);
                }
            }
            if ((string3 = properties.getProperty(string10 + "callerPropagation")) != null) {
                ejbIORConfigurationDescriptor.setCallerPropagation(string3);
            }
            ejbDescriptor.addIORConfigurationDescriptor(ejbIORConfigurationDescriptor);
        }
    }

    private Method convertMethod(String string, Properties properties, ClassLoader classLoader) throws Exception {
        Method[] methodArray;
        String string2 = properties.getProperty(string + "classname");
        if (string2 == null) {
            throw new IOException("Bad mdesc count or mdesc key");
        }
        int n = 0;
        if (properties.getProperty(string + "#parameters") != null) {
            n = Integer.parseInt(properties.getProperty(string + "#parameters"));
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            methodArray = properties.getProperty(string + "parameter" + i);
            stringArray[i] = methodArray;
        }
        String string3 = properties.getProperty(string + "methodname");
        if (string3 == null) {
            throw new RuntimeException("no value for " + string + "methodname is causing a method descriptor parse error");
        }
        methodArray = classLoader.loadClass(string2).getMethods();
        Method method = null;
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string3) || methodArray[i].getParameterTypes().length != n) continue;
            if (n > 0) {
                Class<?>[] classArray = methodArray[i].getParameterTypes();
                boolean bl = true;
                for (int j = 0; j < n; ++j) {
                    String string4 = MethodDescriptor.fixParamClassName(classArray[j].getName());
                    if (string4.equals(stringArray[j])) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                method = methodArray[i];
                break;
            }
            method = methodArray[i];
            break;
        }
        if (method == null) {
            throw new RuntimeException("Couldn't locate method for " + string3);
        }
        return method;
    }

    private MethodDescriptor convertMethodDescriptor(String string, Properties properties, ClassLoader classLoader, EjbDescriptor ejbDescriptor) throws Exception {
        String string2;
        String string3 = properties.getProperty(string + "classname");
        if (string3 == null) {
            throw new IOException("Bad mdesc count or mdesc key");
        }
        String string4 = BeanMethodCalculator.getMethodIntfFor(string3, classLoader, ejbDescriptor);
        if (string4 == null) {
            throw new RuntimeException(string3 + " is not a valid interface name for the bean " + ejbDescriptor.getName());
        }
        int n = 0;
        if (properties.getProperty(string + "#parameters") != null) {
            n = Integer.parseInt(properties.getProperty(string + "#parameters"));
        }
        if ((string2 = properties.getProperty(string + "methodname")) == null) {
            throw new RuntimeException("no value for " + string + "methodname is causing a method descriptor parse error");
        }
        String[] stringArray = null;
        if (n > 0) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                String string5;
                stringArray[i] = string5 = properties.getProperty(string + "parameter" + i);
            }
        }
        return new MethodDescriptor(string2, "", stringArray, string4);
    }

    private void convertMethodPermissions(String string, Properties properties, EjbDescriptor ejbDescriptor, ClassLoader classLoader) throws Exception {
        String string2 = string + "#methodPermissions";
        int n = 0;
        if (properties.getProperty(string2) != null) {
            _logger.log(Level.FINE, "There are method permissions set");
            n = Integer.parseInt(properties.getProperty(string2));
            for (int i = 0; i < n; ++i) {
                String string3 = string + "mdesc" + i + ".";
                MethodDescriptor methodDescriptor = this.convertMethodDescriptor(string3, properties, classLoader, ejbDescriptor);
                if (MethodDescriptor.EJB_BEAN.equals(methodDescriptor.getEjbClassSymbol())) {
                    throw new RuntimeException("Method permissions cannot be set on EJB class methods like : " + methodDescriptor);
                }
                boolean bl = false;
                if (properties.getProperty(string3 + "isExcluded") != null) {
                    bl = new Boolean(properties.getProperty(string3 + "isExcluded"));
                }
                boolean bl2 = true;
                if (properties.getProperty(string3 + "isChecked") != null) {
                    bl2 = new Boolean(properties.getProperty(string3 + "isChecked"));
                }
                String string4 = properties.getProperty(string3 + "permissionedRoles");
                Set set = ejbDescriptor.getMethodDescriptors();
                Vector vector = methodDescriptor.doStyleConversion(ejbDescriptor, set);
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    MethodDescriptor methodDescriptor2 = (MethodDescriptor)iterator.next();
                    String string5 = properties.getProperty(string3 + "classname");
                    try {
                        object = methodDescriptor2.getMethod(classLoader.loadClass(string5));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new RuntimeException(string5 + " cannot be loaded");
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Couldn't localte method for " + methodDescriptor2.getName());
                    }
                    if (bl) {
                        object = MethodPermission.getExcludedMethodPermission();
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, methodDescriptor2 + " is excluded");
                        }
                        ejbDescriptor.addPermissionedMethod((MethodPermission)object, methodDescriptor2);
                        continue;
                    }
                    if (string4 != null) {
                        object = PropsToXmlConverter.parseRolesFrom(string4);
                        while (object.hasMoreElements()) {
                            Role role = (Role)object.nextElement();
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.log(Level.FINE, role + " can call " + methodDescriptor2);
                            }
                            MethodPermission methodPermission = new MethodPermission(role);
                            ejbDescriptor.addPermissionedMethod(methodPermission, methodDescriptor2);
                        }
                        continue;
                    }
                    object = MethodPermission.getUncheckedMethodPermission();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, methodDescriptor2 + " is unchecked");
                    }
                    ejbDescriptor.addPermissionedMethod((MethodPermission)object, methodDescriptor2);
                }
            }
        }
    }

    private void addMethodPermissionsToAllMethods(EjbDescriptor ejbDescriptor, MethodPermission methodPermission, MethodDescriptor methodDescriptor) {
        ejbDescriptor.addPermissionedMethod(methodPermission, methodDescriptor);
    }

    private void convertResourceReferences(String string, Properties properties, EjbDescriptor ejbDescriptor) throws IOException {
        String string2 = properties.getProperty(string + "#resourceReferences");
        if (string2 != null) {
            int n = Integer.parseInt(properties.getProperty(string + "#resourceReferences"));
            for (int i = 0; i < n; ++i) {
                String string3 = string + "resourceReference" + i;
                String string4 = properties.getProperty(string3 + ".name");
                String string5 = properties.getProperty(string3 + ".jndiName");
                String string6 = properties.getProperty(string3 + ".type");
                String string7 = properties.getProperty(string3 + ".authorization");
                EnvironmentProperty environmentProperty = new EnvironmentProperty(string4, string5, "description");
                ResourceReferenceDescriptor resourceReferenceDescriptor = new ResourceReferenceDescriptor(string4, "description", string6);
                resourceReferenceDescriptor.setJndiName(string5);
                if (string7 != null) {
                    resourceReferenceDescriptor.setAuthorization(string7);
                }
                ejbDescriptor.addResourceReferenceDescriptor(resourceReferenceDescriptor);
                String string8 = properties.getProperty(string3 + ".defaultDBAccount");
                resourceReferenceDescriptor.setResourcePrincipal(PropsToXmlConverter.parseResourcePrincipalFromString(string8));
                String string9 = properties.getProperty(string3 + ".mailConfiguration");
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "--- " + string9);
                }
                resourceReferenceDescriptor.setMailConfiguration(PropsToXmlConverter.parseMailConfigurationFromString(string9));
            }
        }
    }

    private static Enumeration parseRolesFrom(String string) {
        Vector<Role> vector = new Vector<Role>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(new Role(stringTokenizer.nextToken()));
            }
        }
        return vector.elements();
    }

    private static void makeUserRoleMapping(RoleMapper roleMapper, Role role, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = "\"";
        String string3 = ",";
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            String string5 = string4.trim();
            StringBuffer stringBuffer = new StringBuffer(string5);
            if (string5.startsWith(string2)) {
                stringBuffer = stringBuffer.deleteCharAt(0);
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    stringBuffer.append(string3);
                    stringBuffer.append(string6);
                    if (!string6.endsWith(string2)) continue;
                    stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    break;
                }
            }
            roleMapper.assignRole(new PrincipalImpl(stringBuffer.toString()), role);
        }
    }

    private static void makeGroupRoleMapping(RoleMapper roleMapper, Role role, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            roleMapper.assignRole(new Group(stringTokenizer.nextToken()), role);
        }
    }

    private static ResourcePrincipal parseResourcePrincipalFromString(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        return new ResourcePrincipal(stringTokenizer.nextToken(), stringTokenizer.nextToken());
    }

    static MailConfiguration parseMailConfigurationFromString(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        return new MailConfiguration(stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray[0] != null && stringArray[1] != null && stringArray[2] != null) {
                String string = "";
                String string2 = "";
                if (stringArray.length == 5) {
                    if (stringArray[3] != null) {
                        string = stringArray[3];
                    }
                    if (stringArray[4] != null) {
                        string2 = stringArray[4];
                    }
                }
                PropsToXmlConverter propsToXmlConverter = new PropsToXmlConverter();
                propsToXmlConverter.convertToXml(new File(stringArray[0]), stringArray[1], stringArray[2], string, string2);
            } else {
                PropsToXmlConverter.help();
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "enterprise_util.error_converting_prop_file", throwable);
            System.exit(1);
        }
    }

    public static String convertTransactionAttribute(String string) {
        if (string.equals("TX_NOT_SUPPORTED")) {
            return ContainerTransaction.NOT_SUPPORTED;
        }
        if (string.equals("TX_REQUIRED")) {
            return ContainerTransaction.REQUIRED;
        }
        if (string.equals("TX_SUPPORTS")) {
            return ContainerTransaction.SUPPORTS;
        }
        if (string.equals("TX_REQUIRES_NEW")) {
            return ContainerTransaction.REQUIRES_NEW;
        }
        if (string.equals("TX_MANDATORY")) {
            return ContainerTransaction.MANDATORY;
        }
        if (string.equals("TX_NEVER")) {
            return ContainerTransaction.NEVER;
        }
        throw new IllegalArgumentException(string + " is not a known transaction attribute in EJB 1.0");
    }

    private void convertRemoteEntityRefs(EjbBundleDescriptor ejbBundleDescriptor, Properties properties) throws IOException {
        String string = properties.getProperty("remoteBeanCount");
        if (string == null) {
            return;
        }
        int n = Integer.parseInt(string);
        for (int i = 0; i < n; ++i) {
            String string2 = "remoteBean" + i + ".";
            String string3 = properties.getProperty(string2 + "remoteEjbName");
            String string4 = properties.getProperty(string2 + "homeInterface");
            String string5 = properties.getProperty(string2 + "remoteInterface");
            String string6 = properties.getProperty(string2 + "jndiName");
            String string7 = properties.getProperty(string2 + "linkName");
            EjbExternalEntityDescriptor ejbExternalEntityDescriptor = new EjbExternalEntityDescriptor();
            ejbExternalEntityDescriptor.setName(string3);
            ejbExternalEntityDescriptor.setHomeClassName(string4);
            ejbExternalEntityDescriptor.setRemoteClassName(string5);
            ejbExternalEntityDescriptor.setJndiName(string6);
            if (string7 != null) {
                EjbDescriptor ejbDescriptor = ejbBundleDescriptor.getEjbByName(string7);
                ejbExternalEntityDescriptor.setEntityDesc((EjbEntityDescriptor)ejbDescriptor);
                ejbExternalEntityDescriptor.setLinkName(string7);
            }
            ejbBundleDescriptor.addRemoteEntity(ejbExternalEntityDescriptor);
        }
    }

    private void convertRelationships(EjbBundleDescriptor ejbBundleDescriptor, Properties properties) {
        String string = properties.getProperty("relationshipcount");
        if (string == null) {
            return;
        }
        int n = Integer.parseInt(string);
        for (int i = 0; i < n; ++i) {
            String string2 = "relationship" + i + ".";
            String string3 = properties.getProperty(string2 + "source");
            String string4 = properties.getProperty(string2 + "sourceRoleName");
            String string5 = properties.getProperty(string2 + "sink");
            String string6 = properties.getProperty(string2 + "sinkRoleName");
            String string7 = properties.getProperty(string2 + "sourceField");
            String string8 = properties.getProperty(string2 + "sourceFieldType");
            String string9 = properties.getProperty(string2 + "sinkField");
            String string10 = properties.getProperty(string2 + "sinkFieldType");
            String string11 = properties.getProperty(string2 + "sourceCascadeDelete");
            String string12 = properties.getProperty(string2 + "sinkCascadeDelete");
            String string13 = properties.getProperty(string2 + "multiplicity");
            String string14 = properties.getProperty(string2 + "isBidirectional");
            String string15 = properties.getProperty(string2 + "name");
            RelationshipDescriptor relationshipDescriptor = new RelationshipDescriptor();
            if (string15 != null) {
                relationshipDescriptor.setName(string15);
            }
            Descriptor descriptor = ejbBundleDescriptor.getDescriptorByName(string3.trim());
            Descriptor descriptor2 = ejbBundleDescriptor.getDescriptorByName(string5.trim());
            if (descriptor == null || descriptor2 == null) {
                throw new RuntimeException("Unable to find source/sink object");
            }
            RelationRoleDescriptor relationRoleDescriptor = new RelationRoleDescriptor();
            relationshipDescriptor.setSource(relationRoleDescriptor);
            relationRoleDescriptor.setRelationshipDescriptor(relationshipDescriptor);
            if (string4 == null) {
                string4 = string3 + "-" + string5;
            }
            relationRoleDescriptor.setName(string4);
            RelationRoleDescriptor relationRoleDescriptor2 = new RelationRoleDescriptor();
            relationshipDescriptor.setSink(relationRoleDescriptor2);
            relationRoleDescriptor2.setRelationshipDescriptor(relationshipDescriptor);
            if (string6 == null) {
                string6 = string5 + "-" + string3;
            }
            relationRoleDescriptor2.setName(string6);
            relationRoleDescriptor.setPersistenceDescriptor(((EjbCMPEntityDescriptor)descriptor).getPersistenceDescriptor());
            relationRoleDescriptor.setPartner(relationRoleDescriptor2);
            FieldDescriptor.checkFieldName(string7.trim());
            relationRoleDescriptor.setCMRField(string7.trim());
            if (string8 != null) {
                relationRoleDescriptor.setCMRFieldType(string8.trim());
            }
            relationRoleDescriptor2.setPersistenceDescriptor(((EjbCMPEntityDescriptor)descriptor2).getPersistenceDescriptor());
            relationRoleDescriptor2.setPartner(relationRoleDescriptor);
            if (string9 != null) {
                FieldDescriptor.checkFieldName(string9.trim());
                relationRoleDescriptor2.setCMRField(string9.trim());
            }
            if (string10 != null) {
                relationRoleDescriptor2.setCMRFieldType(string10.trim());
            }
            if (string11 != null && string11.equals("true")) {
                relationRoleDescriptor.setCascadeDelete(true);
            }
            if (string12 != null && string12.equals("true")) {
                relationRoleDescriptor2.setCascadeDelete(true);
            }
            if (string13.equals("ONE-ONE")) {
                relationRoleDescriptor.setIsMany(false);
                relationRoleDescriptor2.setIsMany(false);
            } else if (string13.equals("ONE-MANY")) {
                relationRoleDescriptor.setIsMany(false);
                relationRoleDescriptor2.setIsMany(true);
            } else if (string13.equals("MANY-ONE")) {
                relationRoleDescriptor.setIsMany(true);
                relationRoleDescriptor2.setIsMany(false);
            } else if (string13.equals("MANY-MANY")) {
                relationRoleDescriptor.setIsMany(true);
                relationRoleDescriptor2.setIsMany(true);
            }
            if (string14.equals("true")) {
                relationshipDescriptor.setIsBidirectional(true);
            }
            ejbBundleDescriptor.addRelationship(relationshipDescriptor);
        }
    }

    private static void help() {
        System.out.println("Usage:- ");
        System.out.println("<propsfilename> <codebase> <applicationxmlfilenameForOutput> optional-ejb-bundle-xml-filename optional-runtime-filename");
        System.out.println("NB: The bean classes MUST be findable from the codebase. ");
    }
}

