/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.FileClassLoader;
import com.sun.enterprise.util.SimpleFilenameFilter;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUtil {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static final boolean debug = false;
    private static final String JAR_FILE_NAME = "j2ee.jar";
    private static final String HOME_DIR_PROP = "com.sun.enterprise.home";
    private static final String DEFAULT_HOME_DIR = System.getProperty("user.dir");
    public static final char JAR_SEPARATOR_CHAR = '/';
    private static final long JAR_ENTRY_UNKNOWN_VALUE = -1L;
    private static final int BYTE_READ_ERROR = -1;
    private static String basedir = null;

    public static String getAbsolutePath(String string) {
        if (FileUtil.isAbsolute(string)) {
            return string;
        }
        String string2 = string.replace('/', File.separatorChar);
        if (basedir == null) {
            FileUtil.setBaseDir();
        }
        String string3 = basedir + File.separator + string;
        return new File(string3).getAbsolutePath();
    }

    private static void setBaseDir() {
        basedir = System.getProperty(HOME_DIR_PROP);
        if (basedir != null) {
            return;
        }
        basedir = DEFAULT_HOME_DIR;
        String string = System.getProperty("java.class.path");
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.endsWith(JAR_FILE_NAME)) continue;
            try {
                String string3 = new File(string2).getAbsoluteFile().getParentFile().getParent();
                if (string3 != null) {
                    basedir = string3;
                }
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }
    }

    private static boolean isAbsolute(String string) {
        return new File(string).isAbsolute();
    }

    public static Set getAllFilesUnder(File file, FilenameFilter filenameFilter) throws IOException {
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException("Problem with: " + file + ". You must supply a directory that exists");
        }
        TreeSet treeSet = new TreeSet();
        FileUtil.recursiveGetFilesUnder(file, file, filenameFilter, treeSet, false);
        return treeSet;
    }

    public static Set getAllFilesAndDirectoriesUnder(File file) throws IOException {
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException("Problem with: " + file + ". You must supply a directory that exists");
        }
        TreeSet treeSet = new TreeSet();
        FileUtil.recursiveGetFilesUnder(file, file, null, treeSet, true);
        return treeSet;
    }

    private static void recursiveGetFilesUnder(File file, File file2, FilenameFilter filenameFilter, Set set, boolean bl) {
        File[] fileArray = file2.listFiles(filenameFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                FileUtil.recursiveGetFilesUnder(file, fileArray[i], filenameFilter, set, bl);
                if (!bl) continue;
                set.add(FileUtil.relativize(file, fileArray[i]));
                continue;
            }
            set.add(FileUtil.relativize(file, fileArray[i]));
        }
    }

    public static File relativize(File file, File file2) {
        String string = file.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        String string3 = string2.substring(string.length(), string2.length());
        if (string3.startsWith(File.separator)) {
            string3 = string3.substring(1);
        }
        return new File(string3);
    }

    public static String classNameFromEntryName(String string) {
        String string2 = string;
        if (string.endsWith(".class")) {
            int n = string.indexOf(".class");
            string2 = string.substring(0, n);
            string2 = string2.replace('/', '.');
        }
        return string2;
    }

    public static String classNameFromFile(File file) {
        String string = file.toString();
        if (string.endsWith(".class")) {
            String string2 = string.replace(File.separatorChar, '.');
            int n = string2.lastIndexOf(".class");
            string = string2.substring(0, n);
        }
        return string;
    }

    public static File getTempDirectory() {
        String string = System.getProperty("java.io.tmpdir");
        String string2 = System.getProperty("user.name");
        if (string2 == null) {
            string2 = "";
        }
        File file = null;
        file = string == null ? new File(string2, "tmp") : new File(string, "sun-as-" + string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static String[] parseFileList(String string) {
        Vector<String> vector = new Vector<String>();
        boolean bl = !File.pathSeparator.equals(":");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl && string2.length() == 1 && stringTokenizer.hasMoreTokens()) {
                string2 = string2 + ":" + stringTokenizer.nextToken();
            }
            vector.addElement(string2);
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean jarEntriesEqual(File file, String string, File file2, String string2) throws IOException {
        JarFile jarFile;
        boolean bl;
        block7: {
            bl = false;
            JarFile jarFile2 = null;
            jarFile = null;
            try {
                jarFile2 = new JarFile(file);
                jarFile = new JarFile(file2);
                String string3 = string.replace(File.separatorChar, '/');
                String string4 = string2.replace(File.separatorChar, '/');
                JarEntry jarEntry = jarFile2.getJarEntry(string3);
                JarEntry jarEntry2 = jarFile.getJarEntry(string4);
                if (jarEntry != null && jarEntry2 != null) {
                    bl = FileUtil.jarEntriesEqual(jarFile2, jarEntry, jarFile, jarEntry2);
                }
                Object var12_12 = null;
                if (jarFile2 == null) break block7;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (jarFile2 != null) {
                    jarFile2.close();
                }
                if (jarFile == null) throw throwable;
                jarFile.close();
                throw throwable;
            }
            jarFile2.close();
        }
        if (jarFile == null) return bl;
        jarFile.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean jarEntriesEqual(JarFile jarFile, JarEntry jarEntry, JarFile jarFile2, JarEntry jarEntry2) throws IOException {
        InputStream inputStream;
        boolean bl;
        block12: {
            bl = false;
            int n = (int)jarEntry.getSize();
            int n2 = (int)jarEntry2.getSize();
            if ((long)n != -1L && (long)n2 != -1L) {
                if (n != n2) return bl;
            }
            if (n == 0) {
                return true;
            }
            InputStream inputStream2 = null;
            inputStream = null;
            try {
                inputStream2 = jarFile.getInputStream(jarEntry);
                inputStream = jarFile2.getInputStream(jarEntry2);
                byte[] byArray = new byte[n];
                byte[] byArray2 = new byte[n2];
                int n3 = 0;
                int n4 = 0;
                while ((n3 = inputStream2.read(byArray, n4, n - n4)) != -1 & (n4 += n3) != n) {
                }
                int n5 = 0;
                while ((n3 = inputStream.read(byArray2, n5, n2 - n5)) != -1 & (n5 += n3) != n2) {
                }
                if (n4 == -1) throw new IOException("Byte read error " + n4 + " " + n5);
                if (n5 == -1) {
                    throw new IOException("Byte read error " + n4 + " " + n5);
                }
                if (Arrays.equals(byArray, byArray2)) {
                    bl = true;
                }
                Object var15_15 = null;
                if (inputStream2 == null) break block12;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                if (inputStream2 != null) {
                    inputStream2.close();
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream2.close();
        }
        if (inputStream == null) return bl;
        inputStream.close();
        return bl;
    }

    public static void main(String[] stringArray) {
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        String string = stringArray[2];
        try {
            FileUtil.jarEntriesEqual(file, string, file2, string);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise_util.excep_in_main", exception);
        }
    }

    public static String getClassNameFromFile(File file) throws IOException, ClassFormatError {
        FileClassLoader fileClassLoader = new FileClassLoader(file.toString());
        return fileClassLoader.getClassName(file);
    }

    public static void countWords() {
        try {
            String[] stringArray = new String[]{".java"};
            File file = new File("/home/dannyc/workspace/j2ee/src/share/com/sun/enterprise/deployment");
            Set set = FileUtil.getAllFilesUnder(file, new SimpleFilenameFilter(stringArray));
            int n = 0;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, set.toString());
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                File file3 = new File(file, file2.toString());
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "\n" + file3);
                }
                FileReader fileReader = new FileReader(file3);
                int n2 = 0;
                boolean bl = false;
                while (n2 != -1) {
                    if (n2 == 34) {
                        boolean bl2 = bl = !bl;
                        if (!bl) {
                            _logger.log(Level.FINE, "\"");
                            ++n;
                        } else if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, " \t word = ");
                        }
                    }
                    if (bl && _logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, new Character((char)n2).toString());
                    }
                    n2 = fileReader.read();
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, n + " words in " + set.size() + " files.");
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "enterprise_util.excep_countwords", throwable);
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        File file3 = new File(file2.getParent());
        if (!file3.exists()) {
            file3.mkdirs();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[8192];
        int n = 0;
        do {
            fileOutputStream.write(byArray, 0, n);
        } while ((n = fileInputStream.read(byArray, 0, byArray.length)) != -1);
        fileInputStream.close();
        fileOutputStream.close();
    }
}

