/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;

public class BeanMethodCalculator {
    private static final String[] entityBeanHomeMethodsDisallowed = new String[]{"getEJBMetaData", "getHomeHandle"};
    private static final String[] entityBeanRemoteMethodsDisallowed = new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical"};
    private static final String[] entityBeanLocalHomeMethodsDisallowed = new String[0];
    private static final String[] entityBeanLocalInterfaceMethodsDisallowed = new String[]{"getEJBLocalHome", "getPrimaryKey", "isIdentical"};
    private static final String[] sessionBeanMethodsDisallowed = new String[]{"*"};
    private static final String[] sessionLocalBeanMethodsDisallowed = new String[]{"*"};
    private static Map disallowedMethodsPerInterface;

    public static String getMethodIntfFor(String string, ClassLoader classLoader, EjbDescriptor ejbDescriptor) throws ClassNotFoundException {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3 = classLoader.loadClass(string);
        if (ejbDescriptor.isRemoteInterfacesSupported()) {
            clazz2 = classLoader.loadClass(ejbDescriptor.getHomeClassName());
            clazz = classLoader.loadClass(ejbDescriptor.getRemoteClassName());
            if (clazz3.isAssignableFrom(clazz2)) {
                return MethodDescriptor.EJB_HOME;
            }
            if (clazz3.isAssignableFrom(clazz)) {
                return MethodDescriptor.EJB_REMOTE;
            }
        }
        if (ejbDescriptor.isLocalInterfacesSupported()) {
            clazz2 = classLoader.loadClass(ejbDescriptor.getLocalHomeClassName());
            clazz = classLoader.loadClass(ejbDescriptor.getLocalClassName());
            if (clazz3.isAssignableFrom(clazz2)) {
                return MethodDescriptor.EJB_LOCALHOME;
            }
            if (clazz3.isAssignableFrom(clazz)) {
                return MethodDescriptor.EJB_LOCAL;
            }
        }
        if (ejbDescriptor instanceof EjbMessageBeanDescriptor && clazz3.isAssignableFrom(clazz2 = classLoader.loadClass(ejbDescriptor.getEjbClassName()))) {
            return MethodDescriptor.EJB_BEAN;
        }
        return null;
    }

    public static Vector getMethodsFor(EjbDescriptor ejbDescriptor, ClassLoader classLoader) throws ClassNotFoundException {
        Vector vector = new Vector();
        if (ejbDescriptor.isRemoteInterfacesSupported()) {
            BeanMethodCalculator.addAllInterfaceMethodsIn(vector, classLoader.loadClass(ejbDescriptor.getHomeClassName()));
            BeanMethodCalculator.addAllInterfaceMethodsIn(vector, classLoader.loadClass(ejbDescriptor.getRemoteClassName()));
        }
        if (ejbDescriptor.isLocalInterfacesSupported()) {
            BeanMethodCalculator.addAllInterfaceMethodsIn(vector, classLoader.loadClass(ejbDescriptor.getLocalHomeClassName()));
            BeanMethodCalculator.addAllInterfaceMethodsIn(vector, classLoader.loadClass(ejbDescriptor.getLocalClassName()));
        }
        return vector;
    }

    private static void addAllInterfaceMethodsIn(Collection collection, Class clazz) {
        collection.addAll(Arrays.asList(clazz.getMethods()));
    }

    public static Collection getTransactionalMethodsFor(EjbDescriptor ejbDescriptor, ClassLoader classLoader) throws ClassNotFoundException {
        Vector vector = new Vector();
        if (ejbDescriptor instanceof EjbSessionDescriptor) {
            Collection collection;
            if (ejbDescriptor.getHomeClassName() != null) {
                collection = BeanMethodCalculator.extractDisallowedMethodsFor(EJBObject.class, sessionBeanMethodsDisallowed);
                vector.addAll(BeanMethodCalculator.getTransactionMethodsFor(classLoader, ejbDescriptor.getRemoteClassName(), collection));
            }
            if (ejbDescriptor.getLocalHomeClassName() != null) {
                collection = BeanMethodCalculator.extractDisallowedMethodsFor(EJBLocalObject.class, sessionLocalBeanMethodsDisallowed);
                vector.addAll(BeanMethodCalculator.getTransactionMethodsFor(classLoader, ejbDescriptor.getLocalClassName(), collection));
            }
        } else {
            Object object;
            Object object2;
            Object object3;
            String string = ejbDescriptor.getHomeClassName();
            if (string != null) {
                object3 = classLoader.loadClass(string);
                vector.addAll(BeanMethodCalculator.getTransactionMethodsFor(EJBHome.class, (Class)object3));
                object2 = ejbDescriptor.getRemoteClassName();
                object = classLoader.loadClass((String)object2);
                vector.addAll(BeanMethodCalculator.getTransactionMethodsFor(EJBObject.class, (Class)object));
            }
            if ((object3 = ejbDescriptor.getLocalHomeClassName()) != null) {
                object2 = classLoader.loadClass((String)object3);
                vector.addAll(BeanMethodCalculator.getTransactionMethodsFor(EJBLocalHome.class, object2));
                object = ejbDescriptor.getLocalClassName();
                Class<?> clazz = classLoader.loadClass((String)object);
                vector.addAll(BeanMethodCalculator.getTransactionMethodsFor(EJBLocalObject.class, clazz));
            }
        }
        return vector;
    }

    private static Collection getTransactionMethodsFor(ClassLoader classLoader, String string, Collection collection) throws ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(string);
        return BeanMethodCalculator.getTransactionMethodsFor(clazz, collection);
    }

    private static Collection getTransactionMethodsFor(Class clazz, Collection collection) {
        Vector<Method> vector = new Vector<Method>(Arrays.asList(clazz.getMethods()));
        vector.removeAll(collection);
        return vector;
    }

    private static Collection getTransactionMethodsFor(Class clazz, Class clazz2) {
        Collection collection = BeanMethodCalculator.getDisallowedTransactionMethodsFor(clazz);
        return BeanMethodCalculator.getTransactionMethodsFor(clazz2, collection);
    }

    private static Collection getDisallowedTransactionMethodsFor(Class clazz) {
        return BeanMethodCalculator.extractDisallowedMethodsFor(clazz, BeanMethodCalculator.getDisallowedMethodsNamesFor(clazz));
    }

    private static Collection extractDisallowedMethodsFor(Class clazz, String[] stringArray) {
        Vector<Method> vector = new Vector<Method>();
        if (stringArray.length == 0) {
            return vector;
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (stringArray[0].equals("*")) {
                vector.addElement(methodArray[i]);
                continue;
            }
            if (Arrays.binarySearch(stringArray, methodArray[i].getName()) < 0) continue;
            vector.addElement(methodArray[i]);
        }
        return vector;
    }

    private static String[] getDisallowedMethodsNamesFor(Class clazz) {
        return (String[])BeanMethodCalculator.getDisallowedMethodsNames().get(clazz);
    }

    protected static Map getDisallowedMethodsNames() {
        if (disallowedMethodsPerInterface == null) {
            disallowedMethodsPerInterface = new Hashtable();
            disallowedMethodsPerInterface.put(EJBHome.class, entityBeanHomeMethodsDisallowed);
            disallowedMethodsPerInterface.put(EJBObject.class, entityBeanRemoteMethodsDisallowed);
            disallowedMethodsPerInterface.put(EJBLocalHome.class, entityBeanLocalHomeMethodsDisallowed);
            disallowedMethodsPerInterface.put(EJBLocalObject.class, entityBeanLocalInterfaceMethodsDisallowed);
        }
        return disallowedMethodsPerInterface;
    }
}

