/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.stateless;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;

public class StatelessEjbCreateHome
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor ejbDescriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(ejbDescriptor);
        if (ejbDescriptor instanceof EjbSessionDescriptor) {
            String string = ((EjbSessionDescriptor)ejbDescriptor).getSessionTypeString();
            if (EjbSessionDescriptor.STATELESS.equals(string)) {
                try {
                    GenericDeclaration[] genericDeclarationArray;
                    Context context = this.getVerifierContext();
                    ClassLoader classLoader = context.getClassLoader();
                    Class<?> clazz = classLoader.loadClass(ejbDescriptor.getEjbClassName());
                    Method method = null;
                    int n = 0;
                    do {
                        genericDeclarationArray = clazz.getDeclaredMethods();
                        for (int i = 0; i < genericDeclarationArray.length; ++i) {
                            if (!genericDeclarationArray[i].getName().equals("ejbCreate")) continue;
                            if (n == 0) {
                                method = genericDeclarationArray[i];
                                ++n;
                                continue;
                            }
                            ++n;
                        }
                    } while ((clazz = clazz.getSuperclass()) != null && method == null);
                    if (method != null && n == 1) {
                        genericDeclarationArray = method.getParameterTypes();
                        if (genericDeclarationArray.length > 0) {
                            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The ejbCreate method has one or more parameters \nwithin bean [ {0} ].  Stateless session are only allowed \nto have ejbCreate methods with no arguments.", new Object[]{ejbDescriptor.getEjbClassName()}));
                        } else {
                            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid: This bean's [ {0} ] ejbCreate method has no parameters.\n Stateless session beans can only have a ejbCreate method\n with no parameters.", new Object[]{ejbDescriptor.getEjbClassName()}));
                        }
                    } else if (method != null && n > 1) {
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "Error: [ {0} ] ejbCreate methods exists within bean [ {1} ].  The EJB class must have only one ejbCreate method for stateless session bean. ", new Object[]{new Integer(n), ejbDescriptor.getEjbClassName()}));
                    } else {
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "Error: No ejbCreate method exists within bean [ {0} ]", new Object[]{ejbDescriptor.getEjbClassName()}));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Verifier.debug(classNotFoundException);
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Class [ {0} ] not found within bean [ {1} ]", new Object[]{ejbDescriptor.getEjbClassName(), ejbDescriptor.getName()}));
                }
                return result;
            }
            if (EjbSessionDescriptor.STATEFUL.equals(string)) {
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "{0} expected {1} Session bean, but called with {2} Session bean.", new Object[]{this.getClass(), EjbSessionDescriptor.STATELESS, string}));
                return result;
            }
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed4", "Error: [ {0} ] is not valid stateType within bean [ {1} ].", new Object[]{string, ejbDescriptor.getName()}));
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

