/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf.remoteintf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;

public class RemoteInterfaceSuperInterface
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor ejbDescriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(ejbDescriptor);
        if (!(ejbDescriptor instanceof EjbSessionDescriptor) && !(ejbDescriptor instanceof EjbEntityDescriptor)) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return result;
        }
        if (ejbDescriptor.getRemoteClassName() == null || "".equals(ejbDescriptor.getRemoteClassName())) {
            return result;
        }
        boolean bl = false;
        try {
            Context context = this.getVerifierContext();
            ClassLoader classLoader = context.getClassLoader();
            Class<?> clazz = classLoader.loadClass(ejbDescriptor.getRemoteClassName());
            boolean bl2 = false;
            block2: do {
                Class<?>[] classArray = clazz.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    if (this.debug) {
                        System.out.println(smh.getLocalString(this.getClass().getName() + ".debug1", "Interface [ {0} ]", new Object[]{classArray[i].getName()}));
                    }
                    if (RmiIIOPUtils.isValidRmiIIOPInterface(classArray[i])) {
                        if (!classArray[i].getName().equals("javax.ejb.EJBObject")) continue;
                        bl2 = true;
                        continue block2;
                    }
                    bl = true;
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not properly conform to rules of RMI-IIOP for superinterfaces.  All enterprise beans remote interfaces are allowed to have superinterfaces that conform to the rules of RMI-IIOP for superinterfaces .  [ {1} ] is not a valid remote interface.", new Object[]{classArray[i].getName(), ejbDescriptor.getRemoteClassName()}));
                }
            } while ((clazz = clazz.getSuperclass()) != null && !bl2);
            if (bl2) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly conforms to rules of RMI-IIOP for superinterfaces.", new Object[]{ejbDescriptor.getRemoteClassName()}));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Verifier.debug(classNotFoundException);
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{ejbDescriptor.getRemoteClassName(), ejbDescriptor.getName()}));
            bl = true;
        }
        if (bl) {
            result.setStatus(1);
        } else {
            result.setStatus(0);
        }
        return result;
    }
}

