/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.beanclass;

import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class EjbClassStaticFieldsFinal
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor ejbDescriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(ejbDescriptor);
        try {
            Context context = this.getVerifierContext();
            ClassLoader classLoader = context.getClassLoader();
            Class<?> clazz = classLoader.loadClass(ejbDescriptor.getEjbClassName());
            boolean bl = false;
            boolean bl2 = false;
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                int n;
                bl2 = false;
                if (fieldArray[i].getName().indexOf("$") == -1 && Modifier.isStatic(n = fieldArray[i].getModifiers())) {
                    if (Modifier.isFinal(n)) continue;
                    if (!bl) {
                        bl = true;
                    }
                    bl2 = true;
                }
                if (!bl2) continue;
                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "Warning: Field [ {0} ] defined within bean class [ {1} ] is defined as static, but not defined as final.  An enterprise Bean must not use read/write static fields. Using read-only static fields is allowed.", new Object[]{fieldArray[i].getName(), ejbDescriptor.getEjbClassName()}));
            }
            if (!bl) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "This bean class [ {0} ] has defined any and all static fields as final.", new Object[]{ejbDescriptor.getEjbClassName()}));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Verifier.debug(classNotFoundException);
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{ejbDescriptor.getEjbClassName()}));
        }
        catch (Exception exception) {
            Verifier.debug(exception);
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: [ {0} ] class encountered [ {1} ]", new Object[]{ejbDescriptor.getEjbClassName(), exception.getMessage()}));
        }
        catch (Throwable throwable) {
            result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.warning(smh.getLocalString(this.getClass().getName() + ".warningException", "Warning: [ {0} ] class encountered [ {1} ]. Cannot access fields of class [ {2} ] which is external to [ {3} ].", new Object[]{ejbDescriptor.getEjbClassName(), throwable.toString(), throwable.getMessage(), Verifier.getJarFile(((EjbBundleArchivist)ejbDescriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName()).getName()}));
        }
        return result;
    }
}

