/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.Iterator;
import java.util.Set;

public class SecurityIdentityRefs
extends EjbTest {
    public Result check(EjbDescriptor ejbDescriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(ejbDescriptor);
        if (ejbDescriptor.getUsesCallerIdentity()) {
            if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.failed2", "Security identity user-caller-identity is not supported for message-driven bean [ {0} ]", new Object[]{ejbDescriptor.getName()}));
            } else {
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.notApplicable1", "Bean [ {0} ] use caller identity for the execution of the methods", new Object[]{ejbDescriptor.getName()}));
            }
            return result;
        }
        RunAsIdentityDescriptor runAsIdentityDescriptor = ejbDescriptor.getRunAsIdentity();
        if (runAsIdentityDescriptor == null) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.notApplicable2", "Bean [ {0} ] does not specify a security identity", new Object[]{ejbDescriptor.getName()}));
            return result;
        }
        EjbBundleDescriptor ejbBundleDescriptor = ejbDescriptor.getEjbBundleDescriptor();
        Set set = ejbBundleDescriptor.getRoles();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            if (!role.getName().equals(runAsIdentityDescriptor.getRoleName())) continue;
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.passed", "Security identity run-as specified identity [ {0} ] role is found in the list of roles", new Object[]{role.getName()}));
            return result;
        }
        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
        result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.failed", "Security identity run-as specified identity [ {0} ] role is not valid", new Object[]{runAsIdentityDescriptor.getRoleName()}));
        return result;
    }
}

