/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class RmiIIOPUtils {
    public static boolean isValidRmiIIOPInterface(Class clazz) {
        GenericDeclaration[] genericDeclarationArray;
        boolean bl = false;
        Class clazz2 = clazz;
        block2: do {
            if (clazz.getName().equals("java.rmi.Remote")) {
                bl = true;
                break;
            }
            genericDeclarationArray = clazz.getInterfaces();
            for (int i = 0; i < genericDeclarationArray.length; ++i) {
                if (((Class)genericDeclarationArray[i]).getName().equals("java.rmi.Remote") || ((Class)genericDeclarationArray[i]).getName().equals("javax.ejb.EJBObject") || ((Class)genericDeclarationArray[i]).getName().equals("javax.ejb.EJBHome")) {
                    bl = true;
                    continue block2;
                }
                if (!RmiIIOPUtils.isValidRmiIIOPInterface((Class)genericDeclarationArray[i])) continue;
                return true;
            }
        } while ((clazz = clazz.getSuperclass()) != null && !bl);
        if (!bl) {
            return false;
        }
        try {
            int n;
            genericDeclarationArray = clazz2.getDeclaredMethods();
            for (n = 0; n < genericDeclarationArray.length; ++n) {
                Class[] classArray = ((Method)genericDeclarationArray[n]).getExceptionTypes();
                if (EjbUtils.isValidRemoteException(classArray)) continue;
                return false;
            }
            for (n = 0; n < genericDeclarationArray.length; ++n) {
                Class[] classArray = ((Method)genericDeclarationArray[n]).getExceptionTypes();
                if (RmiIIOPUtils.isValidRmiIIOPException(classArray)) continue;
                return false;
            }
            Field[] fieldArray = clazz2.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                if (RmiIIOPUtils.isValidRmiIIOPField(fieldArray[i])) continue;
                return false;
            }
        }
        catch (Throwable throwable) {
            Verifier.debug(throwable);
            return false;
        }
        return bl;
    }

    public static boolean isValidRmiIIOPParameters(Class[] classArray) {
        if (classArray.length > 0) {
            for (int i = 0; i < classArray.length; ++i) {
                Class clazz = classArray[i];
                if (RmiIIOPUtils.isValidRmiIDLPrimitiveType(clazz) || RmiIIOPUtils.isValidRmiIIOPValueType(clazz) || RmiIIOPUtils.isValidRmiIIOPInterfaceType(clazz) || RmiIIOPUtils.isJavaLangStringType(clazz) || RmiIIOPUtils.isValidRmiIIOPException(classArray) || clazz.getName().equals("java.lang.Object") || RmiIIOPUtils.isValidRmiIIOPCORBAObjectType(clazz) || RmiIIOPUtils.isValidRmiIIOPIDLEntityType(clazz)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isValidRmiIIOPCORBAObjectType(Class clazz) {
        Class clazz2 = clazz;
        boolean bl = false;
        block0: do {
            Class<?>[] classArray = clazz2.getInterfaces();
            block1: for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i].getName().equals("org.omg.CORBA.Object")) {
                    bl = true;
                    continue block0;
                }
                Class<?> clazz3 = classArray[i];
                do {
                    if (!clazz3.getName().equals("org.omg.CORBA.Object")) continue;
                    bl = true;
                    continue block1;
                } while ((clazz3 = clazz3.getSuperclass()) != null && !bl);
            }
        } while ((clazz2 = clazz2.getSuperclass()) != null && !bl);
        return bl;
    }

    public static boolean isValidRmiIIOPIDLEntityType(Class clazz) {
        Class clazz2 = clazz;
        boolean bl = false;
        block0: do {
            Class<?>[] classArray = clazz2.getInterfaces();
            block1: for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i].getName().equals("org.omg.CORBA.portable.IDLEntity")) {
                    bl = true;
                    continue block0;
                }
                Class<?> clazz3 = classArray[i];
                do {
                    if (!clazz3.getName().equals("org.omg.CORBA.portable.IDLEntity")) continue;
                    bl = true;
                    continue block1;
                } while ((clazz3 = clazz3.getSuperclass()) != null && !bl);
            }
        } while ((clazz2 = clazz2.getSuperclass()) != null && !bl);
        return bl;
    }

    public static boolean isValidRmiIIOPValueType(Class clazz) {
        Class clazz2 = clazz;
        boolean bl = false;
        boolean bl2 = false;
        if (clazz2.getName().equals("java.lang.Object")) {
            return true;
        }
        bl = Serializable.class.isAssignableFrom(clazz2);
        if (!bl) {
            return false;
        }
        bl2 = Remote.class.isAssignableFrom(clazz2);
        if (bl2) {
            return false;
        }
        return bl;
    }

    public static boolean isValidRmiIIOPField(Field field) {
        boolean bl = false;
        if (RmiIIOPUtils.isValidRmiIDLPrimitiveType(field) || field.getType().equals(String.class)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isValidRmiIDLPrimitiveType(Field field) {
        boolean bl = false;
        if (field.getType().getName().equals("void") || field.getType().getName().equals("boolean") || field.getType().getName().equals("byte") || field.getType().getName().equals("char") || field.getType().getName().equals("short") || field.getType().getName().equals("int") || field.getType().getName().equals("long") || field.getType().getName().equals("float") || field.getType().getName().equals("double")) {
            bl = true;
        }
        return bl;
    }

    private static boolean isValidRmiIIOPInterfaceType(Class clazz) {
        return clazz.isInterface();
    }

    public static boolean isValidRmiIDLPrimitiveType(Class clazz) {
        boolean bl = false;
        if (clazz.getName().equals("void") || clazz.getName().equals("boolean") || clazz.getName().equals("byte") || clazz.getName().equals("char") || clazz.getName().equals("short") || clazz.getName().equals("int") || clazz.getName().equals("long") || clazz.getName().equals("float") || clazz.getName().equals("double")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isJavaLangStringType(Class clazz) {
        boolean bl = false;
        if (clazz.getName().equals("java.lang.String")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isValidRmiIIOPException(Class[] classArray) {
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].getName().equals("java.rmi.RemoteException") && !classArray[i].getName().equals("RemoteException")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isValidRmiIIOPReturnType(Class clazz) {
        return RmiIIOPUtils.isValidRmiIDLPrimitiveType(clazz) || RmiIIOPUtils.isValidRmiIIOPValueType(clazz) || RmiIIOPUtils.isValidRmiIIOPInterfaceType(clazz) || RmiIIOPUtils.isJavaLangStringType(clazz) || RmiIIOPUtils.isValidRmiIIOPCORBAObjectType(clazz) || clazz.getName().equals("java.lang.Object") || RmiIIOPUtils.isValidRmiIIOPIDLEntityType(clazz);
    }

    public static boolean isValidSerializableType(Class clazz) {
        return Serializable.class.isAssignableFrom(clazz);
    }

    public static boolean isPersistentFieldTypeValid(Class clazz, String string, String string2) {
        return RmiIIOPUtils.isValidRmiIDLPrimitiveType(clazz) || RmiIIOPUtils.isValidSerializableType(clazz) || clazz.getName().equals(string) || clazz.getName().equals(string2);
    }

    public static boolean isEjbFindMethodExceptionsSubsetOfFindMethodExceptions(Class[] classArray, Class[] classArray2) {
        boolean bl = false;
        if (Arrays.equals(classArray, classArray2)) {
            return true;
        }
        List<Class> list = Arrays.asList(classArray);
        List<Class> list2 = Arrays.asList(classArray2);
        if (!list.isEmpty()) {
            Iterator<Class> iterator = list.iterator();
            while (iterator.hasNext()) {
                Class clazz = iterator.next();
                if (list2.contains(clazz) || RmiIIOPUtils.isSuperClassofClass("java.lang.RuntimeException", clazz)) continue;
                bl = true;
                break;
            }
            return !bl;
        }
        return true;
    }

    private static boolean isSuperClassofClass(String string, Class clazz) {
        boolean bl = false;
        Class clazz2 = clazz;
        do {
            if (!clazz2.getName().equals(string)) continue;
            bl = true;
            break;
        } while ((clazz2 = clazz2.getSuperclass()) != null && !bl);
        return bl;
    }
}

