/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.dd;

import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.xml.XMLValidationHandler;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ParseDD
extends VerifierTest {
    DocumentBuilder builder = null;
    Result result = this.getInitializedResult();
    private LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    boolean oneFailed = false;
    private static String EJB = "EJB Deployment Descriptor";
    private static String APPCLIENT = "App Client Deployment Descriptor";
    private static String CONNECTOR = "Connector Deployment Descriptor";
    private static String WEB = "Web Deployment Descriptor";
    public static final String IAS_EJB = "Sun Java System Application Server EJB DD";
    public static final String COMMIT_OPTION = "commit-option";
    public static final String IS_READ_ONLY_BEAN = "is-read-only-bean";
    public static final String VICTIM_SELECTION_POLICY = "victim-selection-policy";
    public static final String INTEGRITY = "integrity";
    public static final String ESTABLISH_TRUST_IN_TARGET = "establish-trust-in-target";
    public static final String ESTABLISH_TRUST_IN_CLIENT = "establish-trust-in-client";
    public static final String REQUIRED = "required";
    public static final String AUTH_METHOD = "auth-method";
    public static final String CALLER_PROPAGATION = "caller-propagation";
    public static final String PASS_BY_REFERENCE = "pass-by-reference";
    public static final String IS_CACHE_OVERFLOW_ALLOWED = "is-cache-overflow-allowed";
    public static final String SERVER_NAME = "server-name";

    public ParseDD() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = documentBuilderFactory.newDocumentBuilder();
            XMLValidationHandler xMLValidationHandler = new XMLValidationHandler(false);
            this.builder.setEntityResolver(xMLValidationHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{parserConfigurationException.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{parserConfigurationException.toString()}));
        }
        catch (Exception exception) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}));
        }
    }

    public Result validateConnectorDescriptor(InputStream inputStream) {
        Document document = null;
        this.result = this.getInitializedResult();
        this.result.setComponentName(EJB);
        NodeList nodeList = null;
        try {
            String string;
            int n;
            if (inputStream == null) {
                System.out.println("source is null");
                this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".NoIO", "no InputStream found", new Object[0]));
                return this.result;
            }
            document = this.builder.parse(inputStream);
            nodeList = document.getElementsByTagName("license-required");
            if (nodeList != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("true") && !string.equals("false")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedLicense", "[Connector] license-required cannot be {0}. It has to be either true or false.", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedLicense", "PASSED[Connector]  : license-required is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("reauthentication-support")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("true") && !string.equals("false")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedReauthenticationSupport", "[Connector] reauthentication-support cannot be {0}. It has to be either true or false.", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedReauthenticationSupport", "PASSED [Connector] : reauthentication-support is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("transaction-support")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!(string.equals("NoTransaction") || string.equals("LocalTransaction") || string.equals("XATransaction"))) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedTransactionSupport", "[Connector]transaction-support cannot be {0}. It has to be either NoTransaction or LocalTransaction or XATransaction.", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedTransactionSupport", "PASSED [Connector] : transaction-support is {0}.", new Object[]{string}));
                }
            }
            if (this.result.getStatus() != 1) {
                this.result.setStatus(0);
            }
            return this.result;
        }
        catch (IOException iOException) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}));
            return this.result;
        }
        catch (SAXException sAXException) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{sAXException.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{sAXException.toString()}));
            return this.result;
        }
        catch (Exception exception) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}));
            return this.result;
        }
    }

    public Result validateAppClientDescriptor(InputStream inputStream) {
        Document document = null;
        this.result = this.getInitializedResult();
        this.result.setComponentName(EJB);
        NodeList nodeList = null;
        try {
            String string;
            int n;
            if (inputStream == null) {
                System.out.println("source is null");
                this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".NoIO", "no InputStream found", new Object[0]));
                return this.result;
            }
            document = this.builder.parse(inputStream);
            nodeList = document.getElementsByTagName("ejb-ref-type");
            if (nodeList != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals(EjbSessionDescriptor.TYPE) && !string.equals(EjbEntityDescriptor.TYPE)) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedAppClientEjbRefType", "[App Client] ejb-ref-type cannot be {0}. It has to be either Entity or Session.", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedAppClientEjbRefType", "PASSED [App Client] : ejb-ref-type is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("res-auth")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("Application") && !string.equals("Container")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedAppClientResAuth", "[App Client] res-auth cannot be {0}. It has to be either Application or Container", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedAppClientResAuth", "PASSED [App Client] : res-auth is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("res-sharing-scope")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("Shareable") && !string.equals("Unshareable")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedAppClientResSharingScope", "[App Client] res-sharing-scope cannot be {0}. It has to be either Shareable or Unshareable", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedAppClientResSharingScope", "PASSED [App Client] : res-sharing-scope is {0}.", new Object[]{string}));
                }
            }
            if (this.result.getStatus() != 1) {
                this.result.setStatus(0);
            }
            return this.result;
        }
        catch (IOException iOException) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}));
            return this.result;
        }
        catch (SAXException sAXException) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{sAXException.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{sAXException.toString()}));
            return this.result;
        }
        catch (Exception exception) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}));
            return this.result;
        }
    }

    public Result validateWebDescriptor(InputStream inputStream) {
        Document document = null;
        this.result = this.getInitializedResult();
        this.result.setComponentName(EJB);
        NodeList nodeList = null;
        try {
            String string;
            int n;
            if (inputStream == null) {
                System.out.println("source is null");
                this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".NoIO", "no InputStream found", new Object[0]));
                return this.result;
            }
            document = this.builder.parse(inputStream);
            nodeList = document.getElementsByTagName("ejb-ref-type");
            if (nodeList != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals(EjbSessionDescriptor.TYPE) && !string.equals(EjbEntityDescriptor.TYPE)) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedWebEjbRefType", "[Web] ejb-ref-type cannot be {0}. It has to be either Entity or Session.", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedWebEjbRefType", "PASSED [Web] : ejb-ref-type is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("res-auth")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("Application") && !string.equals("Container")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedWebResAuth", "[Web] res-auth cannot be {0}. It has to be either Application or Container", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedWebResAuth", "PASSED[Web]  : res-auth is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("res-sharing-scope")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("Shareable") && !string.equals("Unshareable")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedWebResSharingScope", "[Web] res-sharing-scope cannot be {0}. It has to be either Shareable or Unshareable", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedWebResSharingScope", "PASSED [Web] : res-sharing-scope is {0}.", new Object[]{string}));
                }
            }
            if (this.result.getStatus() != 1) {
                this.result.setStatus(0);
            }
            return this.result;
        }
        catch (IOException iOException) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}));
            return this.result;
        }
        catch (SAXException sAXException) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{sAXException.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{sAXException.toString()}));
            return this.result;
        }
        catch (Exception exception) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}));
            return this.result;
        }
    }

    public Result validateEJBDescriptor(InputStream inputStream) {
        Document document = null;
        this.result = this.getInitializedResult();
        this.result.setComponentName(EJB);
        NodeList nodeList = null;
        try {
            String string;
            int n;
            if (inputStream == null) {
                System.out.println("source is null");
                this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".NoIO", "no InputStream found", new Object[0]));
                return this.result;
            }
            document = this.builder.parse(inputStream);
            this.checkInterfacePairs(document, "remote", "home");
            this.checkInterfacePairs(document, "local", "local-home");
            nodeList = document.getElementsByTagName("session-type");
            if (nodeList != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals(EjbSessionDescriptor.STATELESS) && !string.equals(EjbSessionDescriptor.STATEFUL)) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedSession", "session-type cannot be {0}. It has to be either Stateless or Stateful.", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedSession", "PASSED : session-type is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("ejb-ref-type")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals(EjbSessionDescriptor.TYPE) && !string.equals(EjbEntityDescriptor.TYPE)) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedEjbRefType", "[EJB] ejb-ref-type cannot be {0}. It has to be either Entity or Session.", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedEjbRefType", "PASSED [EJB] : ejb-ref-type is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("multiplicity")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("One") && !string.equals("Many")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedMultiplicity", "[EJB] multiplicity cannot be {0}. It has to be either One or Many", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedMultiplicity", "PASSED [EJB] : multiplicity is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("cmp-version")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("1.x") && !string.equals("2.x")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedVersion", "[EJB] version cannot be {0}. It has to be either 1.x or 2.x", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedVersion", "PASSED [EJB] : version is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("destination-type")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("javax.jms.Queue") && !string.equals("javax.jms.Topic")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedDestinationType", "[EJB] destination-type cannot be {0}. It has to be either javax.jms.Topic or javax.jms.Queue", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedDestinationType", "PASSED [EJB] : destination-type is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("method-intf")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!(string.equals("Home") || string.equals("Remote") || string.equals("LocalHome") || string.equals("Local"))) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedMethodIntf", "[EJB] method-intf cannot be {0}. It has to be either Local, Remote, LocalHome or Home", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedMethodIntf", "PASSED [EJB] : method-intf is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("persistence-type")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("Bean") && !string.equals("Container")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedPersistenceType", "[EJB] persistence-type cannot be {0}. It has to be either Bean or Container", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedPersistenceType", "PASSED [EJB] : persistence-type is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("reentrant")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("True") && !string.equals("False")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedReentrant", "[EJB] reentrant cannot be {0}. It has to be either True or False", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedReentrant", "PASSED [EJB] : reentrant is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("res-auth")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("Application") && !string.equals("Container")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedEjbResAuth", "[EJB] res-auth cannot be {0}. It has to be either Application or Container", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedEjbResAuth", "PASSED [EJB] : res-auth is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("result-type-mapping")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("Local") && !string.equals("Remote")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedResultTypeMapping", "[EJB] result-type-mapping cannot be {0}. It has to be either Remote or Local", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedResultTypeMapping", "PASSED [EJB] : result-type-mapping is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("subscription-durability")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("Durable") && !string.equals("NonDurable")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedSubscriptionDurability", "[EJB] subscription-durability cannot be {0}. It has to be either Durable or NonDurable", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedSubscriptionDurability", "PASSED [EJB] : subscription-durability is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("trans-attribute")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!(string.equals("NotSupported") || string.equals("Supports") || string.equals("Required") || string.equals("RequiresNew") || string.equals("Mandatory") || string.equals("Never"))) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedTransAttribute", "[EJB] trans-attribute cannot be {0}. It has to be either NotSupported or Supports or Required or RequiresNew or Mandatory or Never.", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedTransAttribute", "PASSED [EJB]: trans-attribute is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("transaction-type")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("Bean") && !string.equals("Container")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedTransactionType", "[EJB] transaction-type cannot be {0}. It has to be either Bean or Container", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedTransactionType", "PASSED [EJB]: transaction-type is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("acknowledge-mode")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("Auto-acknowledge") && !string.equals("Dups-ok-acknowledge")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedAcknowledgeMode", "[EJB] acknowledge-mode cannot be {0}. It has to be either True or False", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedAcknowledgeMode", "PASSED [EJB]: acknowledge-mode is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName("res-sharing-scope")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("Shareable") && !string.equals("Unshareable")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedEjbResSharingScope", "[EJB] res-sharing-scope cannot be {0}. It has to be either Shareable or Unshareable", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedEjbResSharingScope", "PASSED [EJB] : res-sharing-scope is {0}.", new Object[]{string}));
                }
            }
            if (this.result.getStatus() != 1) {
                this.result.setStatus(0);
            }
            return this.result;
        }
        catch (IOException iOException) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}));
            return this.result;
        }
        catch (SAXException sAXException) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{sAXException.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{sAXException.toString()}));
            return this.result;
        }
        catch (Exception exception) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}));
            return this.result;
        }
    }

    public void checkInterfacePairs(Document document, String string, String string2) {
        int n = 0;
        int n2 = 0;
        NodeList nodeList = document.getElementsByTagName(string.trim());
        if (nodeList != null) {
            n = nodeList.getLength();
        }
        if ((nodeList = document.getElementsByTagName(string2.trim())) != null) {
            n2 = nodeList.getLength();
        }
        if (n == n2) {
            if (n != 0) {
                this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedPairs", "PASSED [EJB] : [ {0} ] and [ {1} ] tags present.", new Object[]{string, string2}));
            }
        } else {
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedPairs", "FAILED [EJB] : Either one of the [ {0} ] : [ {1} ] tag pair is not present.", new Object[]{string, string2}));
        }
    }

    public Result validateIASEJBDescriptor(InputStream inputStream) {
        Document document = null;
        this.result = this.getInitializedResult();
        this.result.setComponentName(IAS_EJB);
        NodeList nodeList = null;
        try {
            String string;
            int n;
            if (inputStream == null) {
                System.out.println("source is null");
                this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".NoIO", "no InputStream found", new Object[0]));
                return this.result;
            }
            document = this.builder.parse(inputStream);
            nodeList = document.getElementsByTagName(IS_READ_ONLY_BEAN);
            if (nodeList != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("true") && !string.equals("false")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedIsReadOnlyBeanOption", "FAILED [AS-EJB] is-read-only-bean cannot be {0}. It has to be either true or false", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedIsReadOnlyBeanOption", "PASSED [AS-EJB]: is-read-only-bean is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName(INTEGRITY)) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!(string.equals("NONE") || string.equals("SUPPORTED") || string.equals("REQUIRED"))) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".faileIntegritydOption", "FAILED [AS-EJB] integrity cannot be {0}. It has to be either NONE, SUPPORTED or REQUIRED", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedIntegrityOption", "PASSED [AS-EJB]: integrity is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName(ESTABLISH_TRUST_IN_TARGET)) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!(string.equals("NONE") || string.equals("SUPPORTED") || string.equals("REQUIRED"))) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedEstablishTrustInTargetOption", "FAILED [AS-EJB] establish-trust-in-target cannot be {0}. It has to be either NONE, SUPPORTED or REQUIRED", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedEstablishTrustInTargetOption", "PASSED [AS-EJB]: establish-trust-in-target is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName(ESTABLISH_TRUST_IN_CLIENT)) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!(string.equals("NONE") || string.equals("SUPPORTED") || string.equals("REQUIRED"))) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedEstablishTrustInClientOption", "FAILED [AS-EJB] establish-trust-in-client cannot be {0}. It has to be either NONE, SUPPORTED or REQUIRED", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedEstablishTrustInClientOption", "PASSED [AS-EJB]: establish-trust-in-client is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName(REQUIRED)) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("true") && !string.equals("false")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedRequiredOption", "FAILED [AS-EJB] required cannot be {0}. It has to be either true or false", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedRequiredOption", "PASSED [AS-EJB]: required is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName(AUTH_METHOD)) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("USERNAME_PASSWORD")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedAuthMethodOption", "FAILED [AS-EJB] auth-method cannot be {0}. It has to be USERNAME_PASSWORD", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedAuthMethodOption", "PASSED [AS-EJB]: auth-method is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName(CALLER_PROPAGATION)) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!(string.equals("NONE") || string.equals("SUPPORTED") || string.equals("REQUIRED"))) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedCalllerPropagationOption", "FAILED [AS-EJB] caller-propagation cannot be {0}. It has to be either NONE, SUPPORTED or REQUIRED", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedCallerPropagationOption", "PASSED [AS-EJB]: caller-propagation is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName(PASS_BY_REFERENCE)) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("true") && !string.equals("false")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedPassByReferenceOption", "FAILED [AS-EJB] pass-by-reference cannot be {0}. It has to be either true or false", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedPassByReferenceOption", "PASSED [AS-EJB]: pass-by-reference is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName(IS_CACHE_OVERFLOW_ALLOWED)) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (!string.equals("true") && !string.equals("false")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedIsCacheOverflowAllowedOption", "FAILED [AS-EJB] is-cache-overflow-allowed cannot be {0}. It has to be either true or false", new Object[]{string}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedIsCacheOverflowAllowedOption", "PASSED [AS-EJB]: is-cache-overflow-allowed is {0}.", new Object[]{string}));
                }
            }
            if ((nodeList = document.getElementsByTagName(SERVER_NAME)) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    string = ((Text)nodeList.item(n).getFirstChild()).getNodeValue();
                    if (string.length() == 0) {
                        this.result.warning(this.smh.getLocalString(this.getClass().getName() + ".warning", "WARNING [AS-EJB] : server-name is empty [This is presently Not Used]"));
                        continue;
                    }
                    this.result.passed(this.smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-EJB] : server-name is {0}", new Object[]{string}));
                }
            }
            if (this.result.getStatus() != 1 && this.result.getStatus() != 2) {
                this.result.setStatus(0);
                this.result.passed(this.smh.getLocalString(this.getClass().getName() + ".passedAll", "PASSED [AS-EJB] : All tests passed."));
            }
            return this.result;
        }
        catch (IOException iOException) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}));
            return this.result;
        }
        catch (SAXException sAXException) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{sAXException.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{sAXException.toString()}));
            return this.result;
        }
        catch (Exception exception) {
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}));
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}));
            return this.result;
        }
    }
}

