/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.cci;

import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.cci.ConnectionFactoryTest;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;

public class InteractionSpecJavaBeansCompliance
extends ConnectionFactoryTest
implements ConnectorCheck {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result check(ConnectorDescriptor connectorDescriptor) {
        boolean bl = false;
        Result result = this.getInitializedResult();
        ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(connectorDescriptor);
        if (!this.isCCIImplemented(connectorDescriptor, result)) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.cci.InteractionExistence.notapp", "NotApplicable : The CCI interfaces do not seem to be implemented by this resource adapter"));
            return result;
        }
        File file = Verifier.getJarFile(((ConnectorArchivist)connectorDescriptor.getArchivist()).getRarFile().getName());
        Class clazz = this.findImplementorOf(file, "javax.resource.cci.InteractionSpec");
        if (clazz == null) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: While the CCI interfaces are implemented, the javax.resource.cci.InteractionSpec is not"));
            return result;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (propertyDescriptorArray[i].getReadMethod() == null || propertyDescriptorArray[i].getWriteMethod() == null) {
                    bl = true;
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The javax.resource.cci.InteractionSpec implementation [ {0} ] of the property [ {1} ] is not JavaBeans compliant", new Object[]{clazz.getName(), propertyDescriptorArray[i].getName()}));
                }
                if (propertyDescriptorArray[i].isConstrained() || propertyDescriptorArray[i].isBound()) continue;
                bl = true;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "Error: The property [ {0} ] of the javax.resource.cci.InteractionSpec implementation [ {1} ] is not bound or constrained", new Object[]{propertyDescriptorArray[i].getName(), clazz.getName()}));
            }
        }
        catch (IntrospectionException introspectionException) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The javax.resource.cci.InteractionSpec implementation [ {0} ] is not JavaBeans compliant", new Object[]{clazz.getName()}));
            return result;
        }
        if (!bl) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The javax.resource.cci.InteractionSpec implementation is JavaBeans compliant"));
        }
        return result;
    }
}

