/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.io.File;

public class TransactionSupportExistence
extends ConnectorTest
implements ConnectorCheck {
    public Result check(ConnectorDescriptor connectorDescriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(connectorDescriptor);
        String string = connectorDescriptor.getTransSupport();
        if (string == null) {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.TransactionSupport.nonexist", "Error: No Transaction support specified for ressource adapter", new Object[]{string}));
            return result;
        }
        File file = Verifier.getJarFile(((ConnectorArchivist)connectorDescriptor.getArchivist()).getRarFile().getName());
        if (string.equals(ConnectorNode.DD_NO_TRANSACTION)) {
            boolean bl = false;
            if (this.findImplementorOf(file, "javax.resource.spi.LocalTransaction") != null) {
                bl = true;
                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "Warning: Transaction support {0} is specified for ressource adapter but [ {1} ] is implemented", new Object[]{"NoTransaction", "javax.resource.spi.LocalTransaction"}));
            }
            if (this.findImplementorOf(file, "javax.transaction.xa.XAResource") != null) {
                bl = true;
                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.warning(smh.getLocalString(this.getClass().getName() + ".wrning", "Warning: Transaction support {0} is specified for ressource adapter but [ {1} ] is implemented", new Object[]{"NoTransaction", "javax.transaction.xa.XAResource"}));
            }
            if (!bl) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "Transaction support NoTransaction is specified for ressource adapter and [ {1} ] are not implemented", new Object[]{"javax.transaction.xa.XAResource, javax.resource.spi.LocalTransaction"}));
            }
        } else if (string.equals(ConnectorNode.DD_LOCAL_TRANSACTION)) {
            if (this.findImplementorOf(file, "javax.resource.spi.LocalTransaction") == null) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: Transaction support {0} is specified for ressource adapter but [ {1} ] is not implemented", new Object[]{"LocalTransaction", "javax.resource.spi.LocalTransaction"}));
            } else if (this.findImplementorOf(file, "javax.transaction.xa.XAResource") != null) {
                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".wrning", "Warning: Transaction support {0} is specified for ressource adapter but [ {1} ] is implemented", new Object[]{"LocalTransaction", "javax.transaction.xa.XAResource"}));
            } else {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "Transaction support {0} is specified for ressource adapter and [ {1} ] is(are) implemented", new Object[]{"LocalTransaction", "javax.resource.spi.LocalTransaction"}));
            }
        } else if (string.equals(ConnectorNode.DD_XA_TRANSACTION)) {
            boolean bl = false;
            if (this.findImplementorOf(file, "javax.resource.spi.LocalTransaction") == null) {
                bl = true;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: Transaction support {0} is specified for ressource adapter but [ {1} ] is not implemented", new Object[]{"XATransaction", "javax.resource.spi.LocalTransaction"}));
            }
            if (this.findImplementorOf(file, "javax.transaction.xa.XAResource") == null) {
                bl = true;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: Transaction support {0} is specified for ressource adapter but [ {1} ] is not implemented", new Object[]{"XATransaction", "javax.transaction.xa.XAResource"}));
            }
            if (!bl) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "Transaction support {0} is specified for ressource adapter and [ {1} ] is(are) implemented", new Object[]{"XATransaction", "javax.transaction.xa.Transaction, javax.resource.spi.LocalTransaction"}));
            }
        } else {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.TransactionSupport.failed", "Error: Deployment descriptor transaction-support [ {0} ] for ressource adapter is not valid", new Object[]{string}));
        }
        return result;
    }
}

