/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.Iterator;
import java.util.Set;

public class CredentialInterface
extends ConnectorTest
implements ConnectorCheck {
    private static String[] allowedInterfaces = new String[]{"javax.resource.security.PasswordCredential", "javax.resource.security.GenericCredential"};

    public Result check(ConnectorDescriptor connectorDescriptor) {
        boolean bl = false;
        Result result = this.getInitializedResult();
        ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(connectorDescriptor);
        Set set = connectorDescriptor.getAuthMechanisms();
        if (set.isEmpty()) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.AuthMechType.nonexist", "No authentication mechanism defined for this resource adapater", new Object[]{connectorDescriptor.getConnectionFactoryImpl()}));
            return result;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AuthMechanism authMechanism = (AuthMechanism)iterator.next();
            String string = authMechanism.getCredentialInterface();
            boolean bl2 = false;
            if (string != null) {
                for (int i = 0; i < allowedInterfaces.length; ++i) {
                    if (!string.equals(allowedInterfaces[i])) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2 && string != null) continue;
            bl = true;
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.CredentialInterface.failed", "Authentication mechanism credential interface [ {0} ] defined in the credential-interface tag is not allowed", new Object[]{string}));
        }
        if (!bl) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.CredentialInterface.passed", "All defined authorization mechanism credential interfaces are allowed", new Object[]{connectorDescriptor.getConnectionFactoryImpl()}));
        }
        return result;
    }
}

