/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CheckConfigPropertyType
extends ConnectorTest
implements ConnectorCheck {
    private static Class[] allowedTypes = new Class[]{String.class, Boolean.class, Integer.class, Double.class, Byte.class, Short.class, Long.class, Float.class, Character.class};

    public Result check(ConnectorDescriptor connectorDescriptor) {
        boolean bl = false;
        Result result = this.getInitializedResult();
        ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(connectorDescriptor);
        Set set = connectorDescriptor.getConfigProperties();
        Iterator iterator = set.iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            EnvironmentProperty environmentProperty = (EnvironmentProperty)iterator.next();
            String string = environmentProperty.getType();
            if (string == null) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".notdefined", "Error: The configuration property named [ {0} ] has no type ", new Object[]{environmentProperty.getName()}));
                return result;
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (Throwable throwable) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: The type [ {0} ] of the configuration property named [ {1} ] cannot be loaded", new Object[]{environmentProperty.getType(), environmentProperty.getName()}));
                return result;
            }
            boolean bl2 = false;
            for (int i = 0; i < allowedTypes.length; ++i) {
                if (!allowedTypes[i].equals(clazz)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            bl = true;
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The type [ {0} ] for the configuration property named [ {1} ] is not allowed", new Object[]{environmentProperty.getType(), environmentProperty.getName()}));
            return result;
        }
        if (!bl) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Success: all properties have an allowed type"));
        }
        return result;
    }
}

