/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ModulesExistAppClient
extends ApplicationTest
implements AppCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result check(Application application) {
        Result result = this.getInitializedResult();
        if (application.getApplicationClientDescriptors().size() > 0) {
            boolean bl = false;
            Iterator iterator = application.getApplicationClientDescriptors().iterator();
            while (iterator.hasNext()) {
                ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)iterator.next();
                if (applicationClientDescriptor.getArchivist().getArchiveUri().equals("")) continue;
                ZipFile zipFile = null;
                try {
                    File file = new File(Verifier.getEarFile());
                    zipFile = new JarFile(file);
                    ZipEntry zipEntry = ((JarFile)zipFile).getEntry(applicationClientDescriptor.getArchivist().getArchiveUri());
                    if (zipEntry != null) {
                        result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "J2EE Application Client module [ {0} ] exists within [ {1} ].", new Object[]{applicationClientDescriptor.getArchivist().getArchiveUri(), application.getName()}));
                    } else {
                        if (!bl) {
                            bl = true;
                        }
                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: J2EE Application Client module [ {0} ] does not exist within [ {1} ].", new Object[]{applicationClientDescriptor.getArchivist().getArchiveUri(), application.getName()}));
                    }
                    zipFile.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Verifier.debug(fileNotFoundException);
                    if (!bl) {
                        bl = true;
                    }
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: File not found trying to read J2EE module file [ {0} ] within [ {1} ]", new Object[]{applicationClientDescriptor.getArchivist().getArchiveUri(), application.getName()}));
                }
                catch (IOException iOException) {
                    Verifier.debug(iOException);
                    if (!bl) {
                        bl = true;
                    }
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: IO Error trying to read J2EE module file [ {0} ] within [ {1} ]", new Object[]{applicationClientDescriptor.getArchivist().getArchiveUri(), application.getName()}));
                }
                finally {
                    try {
                        zipFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (bl) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no java application clients in application [ {0} ]", new Object[]{application.getName()}));
        }
        return result;
    }
}

