/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.util.Iterator;

public class AppClientURI
extends ApplicationTest
implements AppCheck {
    public Result check(Application application) {
        Result result = this.getInitializedResult();
        if (application.getApplicationClientDescriptors().size() > 0) {
            boolean bl = false;
            Iterator iterator = application.getApplicationClientDescriptors().iterator();
            while (iterator.hasNext()) {
                ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)iterator.next();
                if (!applicationClientDescriptor.getArchivist().getArchiveUri().equals("")) {
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] specifies the URI [ {1} ] of a java application client module, relative to the top level of the application package [ {2} ].", new Object[]{applicationClientDescriptor.getName(), applicationClientDescriptor.getArchivist().getArchiveUri(), application.getName()}));
                    continue;
                }
                if (!bl) {
                    bl = true;
                }
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not specify the URI [ {1} ] of an ejb-jar, relative to the top level of the application package [ {2} ], or does not end with \".jar\"", new Object[]{applicationClientDescriptor.getName(), applicationClientDescriptor.getArchivist().getArchiveUri(), application.getName()}));
            }
            if (bl) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no java application client modules in application [ {0} ]", new Object[]{application.getName()}));
        }
        return result;
    }
}

