/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AppAltDDWeb
extends ApplicationTest
implements AppCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result check(Application application) {
        Result result = this.getInitializedResult();
        if (application.getWebBundleDescriptors().size() > 0) {
            boolean bl = false;
            int n = 0;
            Iterator iterator = application.getWebBundleDescriptors().iterator();
            while (iterator.hasNext()) {
                WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)iterator.next();
                if (webBundleDescriptor.getArchivist().hasExternalDescriptor()) {
                    if (webBundleDescriptor.getArchivist().getExternalDescriptorArchiveUri().equals("")) continue;
                    ZipFile zipFile = null;
                    try {
                        File file = new File(Verifier.getEarFile());
                        zipFile = new JarFile(file);
                        ZipEntry zipEntry = ((JarFile)zipFile).getEntry(webBundleDescriptor.getArchivist().getExternalDescriptorArchiveUri());
                        if (zipEntry != null) {
                            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Found alternate web deployment descriptor URI file [ {0} ] within [ {1} ]", new Object[]{webBundleDescriptor.getArchivist().getExternalDescriptorArchiveUri(), webBundleDescriptor.getName()}));
                        } else {
                            if (!bl) {
                                bl = true;
                            }
                            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: No alternate web deployment descriptor URI file found, looking for [{0} ] within [ {1} ]", new Object[]{webBundleDescriptor.getArchivist().getExternalDescriptorArchiveUri(), webBundleDescriptor.getName()}));
                        }
                        zipFile.close();
                        continue;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Verifier.debug(fileNotFoundException);
                        if (!bl) {
                            bl = true;
                        }
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: File not found trying to read deployment descriptor file [ {0} ] within [ {1} ]", new Object[]{webBundleDescriptor.getArchivist().getExternalDescriptorArchiveUri(), webBundleDescriptor.getName()}));
                        continue;
                    }
                    catch (IOException iOException) {
                        Verifier.debug(iOException);
                        if (!bl) {
                            bl = true;
                        }
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", " Error: IO Error trying to read deployment descriptor file [ {0} ] within [ {1} ]", new Object[]{webBundleDescriptor.getArchivist().getExternalDescriptorArchiveUri(), webBundleDescriptor.getName()}));
                        continue;
                    }
                    finally {
                        try {
                            zipFile.close();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                }
                ++n;
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "There is no java web alternative deployment descriptor in [ {0} ]", new Object[]{webBundleDescriptor.getName()}));
            }
            if (bl) {
                result.setStatus(1);
            } else if (n == application.getWebBundleDescriptors().size()) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no web components in application [ {0} ]", new Object[]{application.getName()}));
        }
        return result;
    }
}

