/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests;

import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public abstract class VerifierTest {
    protected final boolean debug = Verifier.getDebug();
    protected static final LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    private Context context = null;

    public void setVerifierContext(Context context) {
        this.context = context;
    }

    public Context getVerifierContext() {
        return this.context;
    }

    protected Result getInitializedResult() {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", this.getClass() + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        return result;
    }

    public static boolean isSubclassOf(Class clazz, String string) {
        if (clazz == null || string == null) {
            return false;
        }
        Class clazz2 = clazz;
        do {
            if (clazz2.getName().equals(string)) {
                return true;
            }
            Class<?>[] classArray = clazz2.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i].getName().equals(string)) {
                    return true;
                }
                if (!VerifierTest.isSubclassOf(classArray[i], string)) continue;
                return true;
            }
        } while ((clazz2 = clazz2.getSuperclass()) != null);
        return false;
    }

    public static boolean isImplementorOf(Class clazz, String string) {
        if (clazz == null || string == null) {
            return false;
        }
        do {
            if (VerifierTest.isSubclassOf(clazz, string)) {
                return true;
            }
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if (!VerifierTest.isSubclassOf(classArray[i], string)) continue;
                return true;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return false;
    }

    public static Method getMethod(Class clazz, String string, Class[] classArray) {
        Method method = null;
        Class clazz2 = clazz;
        do {
            try {
                method = clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            clazz2 = clazz2.getSuperclass();
        } while (method != null && clazz2 != null);
        return method;
    }

    public static boolean testImplementationOf(Class clazz, String string, Result result) {
        if (VerifierTest.isImplementorOf(clazz, string)) {
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.interfaceimplementation.passed", "The class [ {0} ] implements the [ {1} ] interface", new Object[]{clazz.getName(), string}));
            return true;
        }
        result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.interfaceimplementation.failed", "Error: The class [ {0} ] does not implement the [ {1} ] interface", new Object[]{clazz.getName(), string}));
        return false;
    }

    public static void testFileExistence(String string, File file, String string2, Result result) {
        JarFile jarFile;
        if (string == null || string.length() == 0) {
            result.warning(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.fileexistence.warning", "Warning: No {0} defined in deployment descriptors", new Object[]{string2}));
            return;
        }
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            Verifier.debug(iOException);
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.fileexistence.failed", "Error:  {0} [ {1} ] not found in the archive", new Object[]{string2, string}));
            return;
        }
        ZipEntry zipEntry = jarFile.getEntry(string);
        if (zipEntry == null) {
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.fileexistence.failed", "Error: {0} [ {1} ] not found in the archive", new Object[]{string2, string}));
        } else {
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.fileexistence.passed", "{0} [ {1} ] found in resource adapter archive", new Object[]{string2, string}));
        }
    }

    public static boolean methodThrowException(Method method, String string) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!VerifierTest.isSubclassOf(classArray[i], string)) continue;
            return true;
        }
        return false;
    }
}

