/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.iplanet.ias.deployment.AppClientXmlReader;
import com.iplanet.ias.deployment.AppConfigEnvImpl;
import com.iplanet.ias.deployment.AppConfigException;
import com.iplanet.ias.deployment.ApplicationXmlReader;
import com.iplanet.ias.deployment.ConnectorXmlReader;
import com.iplanet.ias.deployment.EjbBundleXmlReader;
import com.iplanet.ias.deployment.EjbModuleConfigEnv;
import com.iplanet.ias.deployment.IASEjbBundleDescriptor;
import com.iplanet.ias.deployment.RarModuleConfigEnv;
import com.iplanet.ias.deployment.WebBundleXmlReader;
import com.iplanet.ias.deployment.WebModuleConfigEnv;
import com.iplanet.ias.deployment.backend.ConnectorModuleInfo;
import com.iplanet.ias.deployment.backend.DeployableObjectInfo;
import com.iplanet.ias.deployment.backend.EjbModuleInfo;
import com.iplanet.ias.deployment.backend.JarExploder;
import com.iplanet.ias.deployment.backend.RarExploder;
import com.iplanet.ias.deployment.backend.WarExploder;
import com.iplanet.ias.deployment.backend.WebModuleInfo;
import com.iplanet.ias.tools.common.dd.cmpmapping.SunCmpMappings;
import com.iplanet.ias.tools.common.dd.ejb.SunEjbJar;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFile;
import com.iplanet.ias.util.zip.ZipFileException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.JarCheckImpl;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.ResultMgr;
import com.sun.enterprise.tools.verifier.ResultsReport;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.XMLErrorHandler;
import com.sun.enterprise.tools.verifier.gui.MainFrame;
import com.sun.enterprise.tools.verifier.tests.dd.ParseDD;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javax.swing.JFrame;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Verifier {
    private static boolean runningTestHarness = false;
    public static final String TMPFILENAME = "verifier-tmp";
    private Descriptor application = null;
    private static String EJB_DTD = "ejb-jar_2_0.dtd";
    private static String EJB_DTD_12 = "ejb-jar_1_1.dtd";
    private static String WEB_DTD = "web-app_2_3.dtd";
    private static String WEB_DTD_12 = "web-app_2_2.dtd";
    private static String APP_DTD = "application_1_3.dtd";
    private static String APP_DTD_12 = "application_1_2.dtd";
    private static String APP_CLIENT_DTD = "application-client_1_3.dtd";
    private static String APP_CLIENT_DTD_12 = "application-client_1_2.dtd";
    private static String CONNECTOR_DTD = "connector_1_0.dtd";
    private static String jarFileName = null;
    private static String earFileName = null;
    private static String startVerifierMsg = "Verifying ~~~~~~~~~~~~~~~~~~~~~~";
    private static String endVerifierMsg = "Verification done~~~~~~~~~~~~~~~";
    private static boolean alreadyWrittenInvalidParseDetails = false;
    private static int isParseDDValid = 0;
    private boolean checkPass = true;
    private static String configDirStr = "";
    private static boolean isUserConfigDir = false;
    private JarCheckImpl jarCheckImpl;
    private static Hashtable htJar = new Hashtable();
    private static boolean debug = false;
    static String outputFileStr = "Results";
    private static String FO_Str = "Failures only";
    private static String WFO_Str = "Warning and Failures only";
    private static String AO_Str = "All";
    private String currentExceptionMessage = null;
    private static boolean using_gui = false;
    private static boolean testing = false;
    public static final int FAIL = 0;
    public static final int WARN = 1;
    public static final int ALL = 2;
    private static int reportLevel = 2;
    private LocalStringManagerImpl smh;
    private Context context = null;
    public JarClassLoader jcl;
    public ResultMgr resultMgr = null;
    private ResultsReport resultReport = null;
    public File TMP_DIR = null;
    public String APP_DIR = null;
    public String EAR_NAME = null;
    public static final String outputFileSuffix = "_verified";
    private static String outputDirName;
    private final boolean validateXmlLocally = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createContext() {
        this.jcl = null;
        this.context = null;
        Class clazz = JarClassLoader.class;
        synchronized (clazz) {
            this.jcl = new JarClassLoader();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(Verifier.this.jcl);
                    return null;
                }
            });
        }
        this.context = new Context(this.jcl);
    }

    public void doVerifyForEars(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            jarFileName = stringArray[n];
            try {
                this.doit();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        n = this.writeDetails() ? 1 : 0;
    }

    public static boolean hasAlreadyWrittenInvalidParseDetails() {
        return alreadyWrittenInvalidParseDetails;
    }

    static void setWriteInvalidParseDetails(boolean bl) {
        alreadyWrittenInvalidParseDetails = bl;
    }

    public ResultsReport getResultsReport() {
        return this.resultReport;
    }

    public void resetApplication() {
        this.application = null;
    }

    public static int getReportLevel() {
        return reportLevel;
    }

    static String getReportLevelString(int n) {
        String string = "";
        if (n == 0) {
            string = FO_Str;
        } else if (n == 1) {
            string = WFO_Str;
        } else if (n == 2) {
            string = AO_Str;
        }
        return string;
    }

    public static void setReportLevel(int n) {
        reportLevel = n;
    }

    public static File getArchiveFile(String string) {
        File file = (File)htJar.get(string);
        return file;
    }

    static void setArchiveFile(String string, File file) {
        htJar.put(string, file);
    }

    public static File getJarFile(String string) {
        File file = (File)htJar.get(string);
        return file;
    }

    static void setJarFile(String string, File file) {
        htJar.put(string, file);
    }

    public static File getAppClientJarFile(String string) {
        File file = (File)htJar.get(string);
        return file;
    }

    static void setAppClientJarFile(String string, File file) {
        htJar.put(string, file);
    }

    public static String getEarFile() {
        return earFileName;
    }

    static void setEarFile(String string) {
        earFileName = string;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static void log(String string) {
        System.out.println(string);
    }

    public static void error(String string) {
        System.out.println(string);
    }

    public static void debug(String string) {
        if (debug) {
            Verifier.error(string);
        }
    }

    public static void debug(Exception exception) {
        if (debug) {
            exception.printStackTrace();
        }
    }

    void setExceptionMessage(Exception exception) {
        this.currentExceptionMessage = exception.getMessage();
    }

    public String getExceptionMessage() {
        return this.currentExceptionMessage;
    }

    public static void debug(Throwable throwable) {
        if (debug) {
            throwable.printStackTrace();
        }
    }

    public void usage() {
        System.err.println("\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine1", "usage: verifier [optional_params] <jarFile>") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine2", "where :") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine3", "  [optional_params]: Must be: ") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine4", "     -v : verbose debug turned on ") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine5", "    -d <destination dir> : Verifier results are put in the specified existing directory") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine10", "   -r[a|w|f] : result reporting level") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine11", "       a : set output report level to display all results") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine12", "       w : set output report level to display only warning and") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine13", "            failure results") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine14", "       f : set output report level to display only failure") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine15", "            results") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine16", "    Note: default is set to display all results in non-verbose mode.\n In verbose mode, all results are displayed.") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine17", "<jarFile>: ear/war/jar/rar file to perform static verification on ") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine18", "Below is an example which runs verifier in verbose mode") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine19", "and writes all the results of static verification of ") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine20", "file sample.ear to the destination directory /verifierresults") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine21", " verifier -v -ra -d /verifierresults sample.ear") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine22", " The results get generated in both text and xml format.") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine23", " 2 Result files sample.ear_verified.txt and sample.ear_verified.xml will be created") + "\n\n");
        System.exit(0);
    }

    void parseArgs(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length < 1) {
            this.usage();
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.argIs", "arg {0} is: {1}", new Object[]{new Integer(i), string}));
                if (string.startsWith("-")) {
                    try {
                        block1 : switch (string.charAt(1)) {
                            case 'v': {
                                debug = true;
                                Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.verboseFlag", "Setting verbose flag to TRUE."));
                                break;
                            }
                            case 'h': {
                                Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.helpMessage", "Displaying help message."));
                                this.usage();
                                break;
                            }
                            case 'd': {
                                Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.outputDirname", "Retrieving output dirname."));
                                Verifier.debug("Using this output dir = " + stringArray[i + 1]);
                                this.resultReport.setUserSpecifiedOutputFile(true);
                                if (string.length() > 2) {
                                    Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".log.unknownArg", "unknown option \"{0}\"", new Object[]{string}));
                                    this.usage();
                                }
                                if (!this.verifyAndSetResultDir(stringArray[i + 1])) {
                                    this.usage();
                                }
                                ++i;
                                break;
                            }
                            case 'r': {
                                int n = string.length() == 2 ? 97 : (int)string.charAt(2);
                                switch (n) {
                                    case 119: {
                                        if (!bl) {
                                            Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.displayWarningFailures", "Setting output report level to display only warning and failure results."));
                                            Verifier.setReportLevel(1);
                                            bl = true;
                                            break block1;
                                        }
                                        Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.reportLevel", "Already set output display report level to [ {0} ] ", new Object[]{Verifier.getReportLevelString(Verifier.getReportLevel())}));
                                        break block1;
                                    }
                                    case 102: {
                                        if (!bl) {
                                            Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.displayFailures", "Setting output report level to display only failure results."));
                                            Verifier.setReportLevel(0);
                                            bl = true;
                                            break block1;
                                        }
                                        Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.reportLevel", "Already set output display report level to [ {0} ] ", new Object[]{Verifier.getReportLevelString(Verifier.getReportLevel())}));
                                        break block1;
                                    }
                                    case 97: {
                                        if (!bl) {
                                            Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.displayAll", "Setting output report level to display all results."));
                                            Verifier.setReportLevel(2);
                                            bl = true;
                                            break block1;
                                        }
                                        Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.reportLevel", "Already set output display report level to [ {0} ] ", new Object[]{Verifier.getReportLevelString(Verifier.getReportLevel())}));
                                        break block1;
                                    }
                                }
                                Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".log.invalidReportLevel", "Reporting level not valid \"{0}\"", new Object[]{string}));
                                this.usage();
                                break;
                            }
                            case 'u': {
                                Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.startGUI", "Starting Verifier GUI."));
                                using_gui = true;
                                break;
                            }
                            case 't': {
                                testing = true;
                                Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.testingMode", "Testing mode is on."));
                                break;
                            }
                            default: {
                                Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".log.unknownArg", "unknown option \"{0}\"", new Object[]{string}));
                                this.usage();
                                break;
                            }
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        this.setExceptionMessage(stringIndexOutOfBoundsException);
                        Verifier.debug(stringIndexOutOfBoundsException);
                        this.usage();
                    }
                    continue;
                }
                if (jarFileName == null) {
                    jarFileName = new File(string).getAbsolutePath();
                    Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.jarFileName", "Jar filename: {0}", new Object[]{jarFileName}));
                    continue;
                }
                Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.invalidArg", "invalid argument \"{0}\"", new Object[]{string}));
                this.usage();
                return;
            }
            if (jarFileName == null && !using_gui) {
                this.usage();
            }
            if (using_gui) {
                MainFrame mainFrame = new MainFrame(jarFileName, true);
                mainFrame.setSize(800, 600);
                mainFrame.setVisible(true);
            }
            Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.endParseArgs", "*******************************END \"Parse Args\""));
        }
    }

    public void setResultFileName(String string) {
        outputFileStr = string;
        this.resultReport.setUserSpecifiedOutputFile(true);
    }

    public String getResultFileName() {
        return outputFileStr;
    }

    private String getAbsoluteFilenameURLForDTD(String string) {
        try {
            File file = new File(System.getProperty("com.sun.aas.installRoot"));
            file = new File(file, "lib");
            file = new File(file, "dtds");
            file = new File(file, string);
            return file.toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            this.setExceptionMessage(malformedURLException);
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{malformedURLException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(malformedURLException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
    }

    public static void setConfigDir(String string) {
        isUserConfigDir = true;
        configDirStr = string;
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (new File(string2).getParent() != null) {
            new File(new File(string2).getParent()).mkdirs();
        }
    }

    public static String getConfigDir() {
        return configDirStr;
    }

    public static boolean getIsUserConfigDir() {
        return isUserConfigDir;
    }

    public boolean validate(InputSource inputSource, String string) {
        try {
            SAXParserFactory sAXParserFactory = XMLUtils.getSAXParserFactory();
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".debug.validateParse", "About to ValidateParse {0} file.", new Object[]{string}));
            sAXParser.parse(inputSource, (DefaultHandler)new XMLErrorHandler(this, string));
            Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.xmlIsValid", "{0} file is Valid.", new Object[]{string}));
            return true;
        }
        catch (SAXException sAXException) {
            this.setExceptionMessage(sAXException);
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{sAXException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(sAXException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return false;
        }
        catch (Throwable throwable) {
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{throwable.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(throwable)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return false;
        }
    }

    public void setFrame(JFrame jFrame) {
        this.resultReport.setFrame(jFrame);
    }

    public Descriptor loadJar(String string) {
        Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.startingLoadJar", "Starting loadJar() method......"));
        int n = string.lastIndexOf(File.separator);
        String string2 = n != -1 ? string.substring(n + 1) : string;
        if (outputDirName != null) {
            this.setResultFileName(outputDirName + File.separator + string2 + outputFileSuffix);
        } else {
            this.setResultFileName(string2 + outputFileSuffix);
        }
        this.setCheckPass(true);
        this.resultReport.initialize();
        Descriptor.setBoundsChecking(false);
        try {
            Calendar calendar = Calendar.getInstance();
            String string3 = new Integer(calendar.get(11)).toString() + new Integer(calendar.get(12)).toString() + new Integer(calendar.get(14)).toString();
            this.TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
            this.TMP_DIR = new File(this.TMP_DIR, "j2ee-ri-verifier" + string3);
            boolean bl = this.TMP_DIR.getAbsoluteFile().mkdir();
            this.resultReport.setTmpDir(this.TMP_DIR);
            File file = new File(string);
            if (ApplicationArchivist.isApplication(file)) {
                return this.loadAppJar(file);
            }
            if (EjbBundleArchivist.isEjbBundle(file)) {
                return this.loadEjbJar(file);
            }
            if (WebBundleArchivist.isWebBundle(file)) {
                return this.loadWebApp(file);
            }
            if (ApplicationClientArchivist.isApplicationClientJar(file)) {
                return this.loadAppClient(file);
            }
            if (ConnectorArchivist.isConnector(file)) {
                return this.loadConnector(file);
            }
        }
        catch (IOException iOException) {
            this.setExceptionMessage(iOException);
            Verifier.debug(iOException);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".IOException", "Error: ** Error trying to process file: {0}", new Object[]{string}));
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(iOException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Descriptor loadAppJar(File file) {
        Descriptor descriptor;
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        Object object4;
        Iterator iterator2;
        Object object5;
        boolean bl;
        boolean bl2;
        Iterator iterator3;
        Set set;
        JarFile jarFile;
        block71: {
            Iterator iterator4;
            block72: {
                File file2;
                boolean bl3 = false;
                jarFile = null;
                this.createContext();
                try {
                    jarFile = new JarFile(file);
                    Verifier.setEarFile(jarFile.getName());
                    ZipEntry zipEntry = jarFile.getEntry("META-INF/application.xml");
                    if (zipEntry != null) {
                        Object object6;
                        bl3 = true;
                        if (!bl3) {
                            Descriptor descriptor2 = null;
                            return descriptor2;
                        }
                        this.application = this.openApplication(file);
                        if (this.application == null) {
                            Descriptor descriptor3 = null;
                            return descriptor3;
                        }
                        this.verification(this.application);
                        set = ((Application)this.application).getRarDescriptors();
                        iterator3 = set.iterator();
                        bl2 = false;
                        bl = false;
                        if (iterator3.hasNext()) {
                            do {
                                object5 = (ConnectorDescriptor)iterator3.next();
                                file2 = this.getExplodedFile(((ConnectorDescriptor)object5).getDeployName());
                                Verifier.setArchiveFile(((ConnectorArchivist)((BundleDescriptor)object5).getArchivist()).getRarFile().getName(), file2);
                            } while (iterator3.hasNext());
                        }
                        object5 = ((Application)this.application).getEjbBundleDescriptors();
                        iterator2 = object5.iterator();
                        bl2 = false;
                        if (iterator2.hasNext()) {
                            do {
                                object6 = (EjbBundleDescriptor)iterator2.next();
                                file2 = this.getExplodedFile(((BundleDescriptor)object6).getArchivist().getArchiveUri());
                                Verifier.setArchiveFile(((EjbBundleArchivist)((BundleDescriptor)object6).getArchivist()).getEjbJarFile().getName(), file2);
                            } while (iterator2.hasNext());
                        }
                        if (bl) {
                            object6 = null;
                            return object6;
                        }
                        object6 = ((Application)this.application).getWebBundleDescriptors();
                        iterator4 = object6.iterator();
                        bl2 = false;
                        if (iterator4.hasNext()) {
                            do {
                                object4 = (WebBundleDescriptor)iterator4.next();
                                file2 = this.getExplodedFile(((BundleDescriptor)object4).getArchivist().getArchiveUri());
                                Verifier.setArchiveFile(((WebBundleArchivist)((BundleDescriptor)object4).getArchivist()).getWebJarFile().getName(), file2);
                            } while (iterator4.hasNext());
                        }
                        if (bl) {
                            object4 = null;
                            return object4;
                        }
                        object4 = ((Application)this.application).getApplicationClientDescriptors();
                        iterator = object4.iterator();
                        bl2 = false;
                        if (iterator.hasNext()) {
                            do {
                                object3 = (ApplicationClientDescriptor)iterator.next();
                                file2 = this.getExplodedFile(((BundleDescriptor)object3).getArchivist().getArchiveUri());
                                Verifier.setAppClientJarFile(((ApplicationClientArchivist)((BundleDescriptor)object3).getArchivist()).getApplicationClientJarFile().getName(), file2);
                            } while (iterator.hasNext());
                        }
                        if (bl) {
                            object3 = null;
                            return object3;
                        }
                        object6 = ((Application)this.application).getApplicationArchivist().getLibraryJarUris();
                        iterator4 = object6.iterator();
                        bl2 = false;
                        if (!iterator4.hasNext()) break block71;
                        break block72;
                    }
                    if (debug) {
                        System.out.println(this.smh.getLocalString(this.getClass().getName() + ".debug.MissingXMLFile", "{0} is missing XML file: {1}", new Object[]{jarFile.getName(), "META-INF/application.xml"}));
                    }
                    this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".InvalidParse.MissingXMLFile1", "Error: ** Error in {0}: ", new Object[]{"LoadAppJar"}), this.smh.getLocalString(this.getClass().getName() + ".InvalidParse.MissingXMLFile2", " {0} is missing XML file: {1}", new Object[]{jarFile.getName(), "META-INF/application.xml"}));
                    this.resultReport.failureCount();
                    this.resultReport.writeToFile();
                    Descriptor descriptor4 = null;
                    return descriptor4;
                }
                catch (ZipException zipException) {
                    this.setExceptionMessage(zipException);
                    Verifier.debug(zipException);
                    Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".ZipException", "Error: ** Error in opening jar file: {0}", new Object[]{file.getName()}));
                    this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{zipException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(zipException)}));
                    this.resultReport.failureCount();
                    this.resultReport.writeToFile();
                    file2 = null;
                    return file2;
                }
                catch (Exception exception) {
                    this.setExceptionMessage(exception);
                    Verifier.debug(exception);
                    Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}));
                    this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(exception)}));
                    this.resultReport.failureCount();
                    this.resultReport.writeToFile();
                    file2 = null;
                    return file2;
                }
            }
            do {
                if ((iterator = jarFile.getEntry((String)(object4 = iterator4.next().toString()))) == null) {
                    throw new IOException(this.smh.getLocalString("enterprise.deployment.exceptionarchiveurinotfoundinappjar", "{0} not found in {1}", new Object[]{iterator4.next().toString(), jarFile.getName()}));
                }
                object3 = new File(this.TMP_DIR, "temp");
                object2 = ((File)(object3 = new File((File)object3, (String)object4))).getAbsolutePath();
                object = new File((String)object2).getParent();
                if (object != null) {
                    new File((String)object).mkdirs();
                }
                InputStream inputStream = jarFile.getInputStream((ZipEntry)((Object)iterator));
                FileOutputStream fileOutputStream = new FileOutputStream((File)object3);
                Archivist.copyWithoutClose(inputStream, fileOutputStream);
                inputStream.close();
                fileOutputStream.close();
            } while (iterator4.hasNext());
        }
        set = ((Application)this.application).getRarDescriptors();
        iterator3 = set.iterator();
        bl2 = false;
        bl = false;
        if (iterator3.hasNext()) {
            do {
                if ((descriptor = this.loadConnector(Verifier.getArchiveFile(((ConnectorArchivist)((BundleDescriptor)(object4 = (ConnectorDescriptor)iterator3.next())).getArchivist()).getRarFile().getName()))) != null) continue;
                bl = true;
            } while (iterator3.hasNext() && descriptor != null);
        }
        object5 = ((Application)this.application).getEjbBundleDescriptors();
        iterator2 = object5.iterator();
        bl2 = false;
        if (iterator2.hasNext()) {
            do {
                if ((descriptor = this.loadEjbJar(Verifier.getArchiveFile(((EjbBundleArchivist)((BundleDescriptor)(object4 = (EjbBundleDescriptor)iterator2.next())).getArchivist()).getEjbJarFile().getName()))) != null) continue;
                bl = true;
            } while (iterator2.hasNext() && descriptor != null);
        }
        if (bl) {
            return null;
        }
        object4 = ((Application)this.application).getWebBundleDescriptors();
        iterator = object4.iterator();
        bl2 = false;
        if (iterator.hasNext()) {
            do {
                if ((descriptor = this.loadWebApp(Verifier.getArchiveFile(((WebBundleArchivist)((BundleDescriptor)(object3 = (WebBundleDescriptor)iterator.next())).getArchivist()).getWebJarFile().getName()))) != null) continue;
                bl = true;
            } while (iterator.hasNext() && descriptor != null);
        }
        if (bl) {
            return null;
        }
        object3 = ((Application)this.application).getApplicationClientDescriptors();
        object2 = object3.iterator();
        bl2 = false;
        if (object2.hasNext()) {
            do {
                if ((descriptor = this.loadAppClient(Verifier.getAppClientJarFile(((ApplicationClientArchivist)((BundleDescriptor)(object = (ApplicationClientDescriptor)object2.next())).getArchivist()).getApplicationClientJarFile().getName()))) != null) continue;
                bl = true;
            } while (object2.hasNext() && descriptor != null);
        }
        if (bl) {
            return null;
        }
        jarFile.close();
        return this.application;
        finally {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Descriptor loadEjbJar(File file) {
        ParseDD parseDD;
        boolean bl = false;
        java.util.zip.ZipFile zipFile = null;
        this.createContext();
        EjbBundleDescriptor ejbBundleDescriptor = null;
        String string = null;
        String string2 = null;
        try {
            if (this.application != null && (string = (ejbBundleDescriptor = ((Application)this.application).getEjbBundleByUri(file.getName())).getArchivist().getExternalDescriptorArchiveUri()) != null) {
                string2 = ApplicationXmlReader.getIasAltDDEntryName(string);
            }
            zipFile = new JarFile(file);
            Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.retrievingJar", "Retrieving {0} file for ValidatingParser", new Object[]{EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
            InputStream inputStream = this.getInputStream((JarFile)zipFile, EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY, string);
            if (inputStream != null) {
                parseDD = new ParseDD();
                Result result = parseDD.validateEJBDescriptor(inputStream);
                isParseDDValid = result.getStatus();
                this.resultMgr.addResults(result);
                this.resultMgr.fireTestEvent(result);
                inputStream.close();
                bl = true;
                if (!bl) {
                    Descriptor descriptor = null;
                    return descriptor;
                }
                if (this.application == null) {
                    ejbBundleDescriptor = this.openEjbJar(file);
                    if (ejbBundleDescriptor == null) {
                        Descriptor descriptor = null;
                        return descriptor;
                    }
                    Verifier.setArchiveFile(((BundleDescriptor)ejbBundleDescriptor).getArchivist().getArchiveUri(), file);
                } else {
                    ejbBundleDescriptor = ((Application)this.application).getEjbBundleByUri(file.getName());
                }
                bl = true;
                if (!bl) {
                    Descriptor descriptor = null;
                    return descriptor;
                }
                try {
                    this.jcl.addJar(file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    this.setExceptionMessage(iOException);
                    System.out.println(this.smh.getLocalString(this.getClass().getName() + ".IOException.JarCannotBeAdded", "{0} can't be added.", new Object[]{zipFile.getName()}));
                }
                zipFile.close();
                this.verification(ejbBundleDescriptor);
                return ejbBundleDescriptor;
            }
            if (debug) {
                System.out.println(this.smh.getLocalString(this.getClass().getName() + ".debug.MissingXMLFile", "{0} is missing XML file: {1}", new Object[]{zipFile.getName(), EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
            }
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".InvalidParse.MissingXMLFile1", "Error: ** Error in {0}: ", new Object[]{"LoadEjbJar"}), this.smh.getLocalString(this.getClass().getName() + ".InvalidParse.MissingXMLFile2", " {0} is missing XML file: {1}", new Object[]{zipFile.getName(), EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            Descriptor descriptor = null;
            return descriptor;
        }
        catch (ZipException zipException) {
            this.setExceptionMessage(zipException);
            Verifier.debug(zipException);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".ZipException", "Error: ** Error in opening jar file:  {0}", new Object[]{file.getName()}));
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".ErrMessage", "Error:    {0}", new Object[]{zipException.getMessage()}));
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{zipException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(zipException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            parseDD = null;
            return parseDD;
        }
        catch (IOException iOException) {
            this.setExceptionMessage(iOException);
            Verifier.debug(iOException);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".IOException", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}));
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".ErrMessage", "Error:    {0}", new Object[]{iOException.getMessage()}));
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(iOException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            parseDD = null;
            return parseDD;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Descriptor loadWebApp(File file) {
        ParseDD parseDD;
        WebBundleDescriptor webBundleDescriptor = null;
        boolean bl = false;
        boolean bl2 = false;
        java.util.zip.ZipFile zipFile = null;
        String string = null;
        String string2 = null;
        try {
            if (this.application != null && (string = (webBundleDescriptor = ((Application)this.application).getWebBundleDescriptorByUri(file.getName())).getArchivist().getExternalDescriptorArchiveUri()) != null) {
                string2 = ApplicationXmlReader.getIasAltDDEntryName(string);
            }
            zipFile = new JarFile(file);
            Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.retrievingJar", "Retrieving {0} file for ValidatingParser", new Object[]{WebBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
            InputStream inputStream = this.getInputStream((JarFile)zipFile, WebBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY, string);
            if (inputStream != null) {
                parseDD = new ParseDD();
                Result result = parseDD.validateWebDescriptor(inputStream);
                isParseDDValid = result.getStatus();
                this.resultMgr.addResults(result);
                this.resultMgr.fireTestEvent(result);
                inputStream.close();
                bl = true;
                if (!bl) {
                    Descriptor descriptor = null;
                    return descriptor;
                }
                if (this.application == null) {
                    webBundleDescriptor = this.openWebApp(file);
                    if (webBundleDescriptor == null) {
                        Descriptor descriptor = null;
                        return descriptor;
                    }
                    Verifier.setArchiveFile(((BundleDescriptor)webBundleDescriptor).getArchivist().getArchiveUri(), file);
                }
            } else {
                if (debug) {
                    System.out.println(this.smh.getLocalString(this.getClass().getName() + ".debug.MissingXMLFile", "{0} is missing XML file: {1}", new Object[]{zipFile.getName(), WebBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
                }
                this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".InvalidParse.MissingXMLFile1", "Error: ** Error in {0}: ", new Object[]{"LoadWebApp"}), this.smh.getLocalString(this.getClass().getName() + ".InvalidParse.MissingXMLFile2", " {0} is missing XML file: {1}", new Object[]{zipFile.getName(), WebBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
                this.resultReport.failureCount();
                this.resultReport.writeToFile();
                Descriptor descriptor = null;
                return descriptor;
            }
            zipFile.close();
            this.verification(webBundleDescriptor);
            return webBundleDescriptor;
        }
        catch (ZipException zipException) {
            this.setExceptionMessage(zipException);
            Verifier.debug(zipException);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".ZipException", "Error: ** Error in opening jar file:  {0}", new Object[]{file.getName()}));
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{zipException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(zipException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            parseDD = null;
            return parseDD;
        }
        catch (Exception exception) {
            this.setExceptionMessage(exception);
            Verifier.debug(exception);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}));
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(exception)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            parseDD = null;
            return parseDD;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isXmlValid(File file, String string) {
        boolean bl = false;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.retrievingJar", "Retrieving {0} file for ValidatingParser", new Object[]{string}));
            ZipEntry zipEntry = jarFile.getEntry(string);
            if (zipEntry != null) {
                InputStream inputStream = jarFile.getInputStream(zipEntry);
                InputSource inputSource = new InputSource(inputStream);
                bl = this.validate(inputSource, string);
                inputStream.close();
            } else {
                if (debug) {
                    System.out.println(this.smh.getLocalString(this.getClass().getName() + ".debug.MissingXMLFile", "{0} is missing XML file: {1}", new Object[]{jarFile.getName(), string}));
                }
                this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".InvalidParse.MissingXMLFile1", "Error: ** Error in {0}: ", new Object[]{"isXMLValide"}), this.smh.getLocalString(this.getClass().getName() + ".InvalidParse.MissingXMLFile2", " {0} is missing XML file: {1}", new Object[]{jarFile.getName(), string}));
                this.resultReport.failureCount();
                this.resultReport.writeToFile();
            }
        }
        catch (ZipException zipException) {
            this.setExceptionMessage(zipException);
            Verifier.debug(zipException);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".ZipException", "Error: ** Error in opening jar file:  {0}", new Object[]{file.getName()}));
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{zipException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(zipException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            boolean bl2 = false;
            return bl2;
        }
        catch (Exception exception) {
            this.setExceptionMessage(exception);
            Verifier.debug(exception);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}));
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(exception)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Descriptor loadConnector(File file) {
        ParseDD parseDD;
        this.createContext();
        ConnectorDescriptor connectorDescriptor = null;
        java.util.zip.ZipFile zipFile = null;
        String string = null;
        String string2 = null;
        try {
            InputStream inputStream;
            if (this.application != null && (string = ((WebBundleDescriptor)((Object)(connectorDescriptor = ((Application)this.application).getRarDescriptorByUri(file.getName())))).getArchivist().getExternalDescriptorArchiveUri()) != null) {
                string2 = ApplicationXmlReader.getIasAltDDEntryName(string);
            }
            if ((inputStream = this.getInputStream((JarFile)(zipFile = new JarFile(file)), ConnectorArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY, string)) != null) {
                parseDD = new ParseDD();
                Result result = parseDD.validateConnectorDescriptor(inputStream);
                isParseDDValid = result.getStatus();
                this.resultMgr.addResults(result);
                this.resultMgr.fireTestEvent(result);
                inputStream.close();
                boolean bl = false;
                bl = true;
                if (bl) {
                    if (this.application == null) {
                        connectorDescriptor = this.openConnector(file);
                        if (connectorDescriptor == null) {
                            Descriptor descriptor = null;
                            return descriptor;
                        }
                        Verifier.setArchiveFile(((BundleDescriptor)connectorDescriptor).getArchivist().getArchiveUri(), file);
                    }
                    Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry jarEntry = enumeration.nextElement();
                        if (!jarEntry.getName().endsWith(".jar")) continue;
                        try {
                            inputStream = ((JarFile)zipFile).getInputStream(jarEntry);
                            File file2 = File.createTempFile(jarEntry.getName(), "");
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                            Archivist.copy(inputStream, bufferedOutputStream);
                            bufferedOutputStream.close();
                            file2.deleteOnExit();
                            this.jcl.addJar(file2.getAbsolutePath());
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(iOException)}));
                            this.resultReport.failureCount();
                            this.resultReport.writeToFile();
                        }
                    }
                }
            }
            this.verification(connectorDescriptor);
            zipFile.close();
        }
        catch (IOException iOException) {
            this.setExceptionMessage(iOException);
            Verifier.debug(iOException);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".IOException", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}));
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".ErrMessage", "Error:    {0}", new Object[]{iOException.getMessage()}));
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(iOException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            parseDD = null;
            return parseDD;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return connectorDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Descriptor loadAppClient(File file) {
        ParseDD parseDD;
        ApplicationClientDescriptor applicationClientDescriptor = null;
        boolean bl = false;
        java.util.zip.ZipFile zipFile = null;
        this.createContext();
        String string = null;
        String string2 = null;
        try {
            if (this.application != null && (string = (applicationClientDescriptor = ((Application)this.application).getApplicationClientByUri(file.getName())).getArchivist().getExternalDescriptorArchiveUri()) != null) {
                string2 = ApplicationXmlReader.getIasAltDDEntryName(string);
            }
            zipFile = new JarFile(file);
            Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.retrievingJar", "Retrieving {0} file for ValidatingParser", new Object[]{"META-INF/application-client.xml"}));
            InputStream inputStream = this.getInputStream((JarFile)zipFile, "META-INF/application-client.xml", string);
            if (inputStream != null) {
                parseDD = new ParseDD();
                Result result = parseDD.validateAppClientDescriptor(inputStream);
                isParseDDValid = result.getStatus();
                this.resultMgr.addResults(result);
                this.resultMgr.fireTestEvent(result);
                inputStream.close();
                bl = true;
                if (!bl) {
                    Descriptor descriptor = null;
                    return descriptor;
                }
                if (this.application == null) {
                    applicationClientDescriptor = AppClientXmlReader.load(file, file.getName(), true);
                    Verifier.setAppClientJarFile(file.getName(), file);
                }
                try {
                    this.jcl.addJar(file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    this.setExceptionMessage(iOException);
                    System.out.println(this.smh.getLocalString(this.getClass().getName() + ".IOException.JarCannotBeAdded", "{0} can't be added.", new Object[]{zipFile.getName()}));
                }
                zipFile.close();
                this.verification(applicationClientDescriptor);
                return applicationClientDescriptor;
            }
            if (debug) {
                System.out.println(this.smh.getLocalString(this.getClass().getName() + ".debug.MissingXMLFile", "{0} is missing XML file: {1}", new Object[]{zipFile.getName(), "META-INF/application-client.xml"}));
            }
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".InvalidParse.MissingXMLFile1", "Error: ** Error in {0}: ", new Object[]{"LoadAppClient"}), this.smh.getLocalString(this.getClass().getName() + ".InvalidParse.MissingXMLFile2", " {0} is missing XML file: {1}", new Object[]{zipFile.getName(), "META-INF/application-client.xml"}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            Descriptor descriptor = null;
            return descriptor;
        }
        catch (ZipException zipException) {
            this.setExceptionMessage(zipException);
            Verifier.debug(zipException);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".ZipException", "Error: ** Error in opening jar file:  {0}", new Object[]{file.getName()}));
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{zipException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(zipException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            parseDD = null;
            return parseDD;
        }
        catch (Exception exception) {
            this.setExceptionMessage(exception);
            Verifier.debug(exception);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}));
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(exception)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            parseDD = null;
            return parseDD;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Verifier() {
        debug = false;
        try {
            StringManagerHelper.setLocalStringsManager(Class.forName(this.getClass().getName()));
            this.smh = StringManagerHelper.getLocalStringsManager();
            this.resultMgr = new ResultMgr();
            this.resultReport = new ResultsReport();
            this.context = null;
            this.jcl = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.setExceptionMessage(classNotFoundException);
            classNotFoundException.printStackTrace();
        }
    }

    public Verifier(boolean bl) {
        this();
        using_gui = bl;
    }

    public static void main(String[] stringArray) throws ClassNotFoundException, IOException {
        Verifier verifier = new Verifier();
        verifier.parseArgs(stringArray);
        if (!using_gui) {
            boolean bl = verifier.doit();
            boolean bl2 = verifier.writeDetails();
            if (bl) {
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
    }

    private File extractFileToTmpDir(String string, Descriptor descriptor) {
        File file = null;
        try {
            file = new File(this.TMP_DIR, "temp");
            file = new File(file, string);
            String string2 = file.getAbsolutePath();
            String string3 = new File(string2).getParent();
            if (string3 != null) {
                new File(string3).mkdirs();
            }
            BundleDescriptor bundleDescriptor = (BundleDescriptor)descriptor;
            bundleDescriptor.getApplication().getApplicationArchivist().extractBundleToFile(bundleDescriptor, file);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage() + " " + this.smh.getLocalString("com.sun.enterprise.tools.verifier.Verifier.tryingtoextractfile", "trying to extract file") + " [" + string + "] " + this.smh.getLocalString("com.sun.enterprise.tools.verifier.Verifier.totmpdir", " to Temp Dir") + ".  " + StringManagerHelper.getLocalStringsManager().getLocalString("com.sun.enterprise.tools.verifier.Verifier.cannotrunverifier", "Cannot run verifier on J2EE components contained in file") + " [" + string + "]" + ".");
            return file;
        }
        return file;
    }

    public void cleanTMPFiles() {
        File file = null;
        try {
            String string = this.TMP_DIR.getAbsolutePath();
            String string2 = new File(string).getParent();
            if (string2 != null) {
                new File(string2).mkdirs();
            }
            this.cleanAll(this.TMP_DIR.getAbsolutePath());
            this.TMP_DIR.delete();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage() + " " + StringManagerHelper.getLocalStringsManager().getLocalString("com.sun.enterprise.tools.verifier.Verifier.tryingtocleanupfile", "trying to remove file") + file.getName() + StringManagerHelper.getLocalStringsManager().getLocalString("com.sun.enterprise.tools.verifier.Verifier.fromtmpdir", " from Temp Dir") + ".");
        }
    }

    private void cleanAll(String string) {
        File file = null;
        int n = 0;
        String string2 = null;
        String string3 = null;
        File file2 = new File(string);
        if (!file2.exists()) {
            return;
        }
        File[] fileArray = file2.listFiles();
        n = fileArray != null ? fileArray.length : 0;
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                if (fileArray[i].isFile()) {
                    fileArray[i].delete();
                    continue;
                }
                string2 = file2 + File.separator + fileArray[i].getName();
                file = new File(string2);
                string3 = file.getAbsolutePath();
                this.cleanAll(string3);
            }
        }
        if (!file2.equals("temp")) {
            file2.delete();
        }
    }

    public void setCheckPass(boolean bl) {
        this.checkPass = bl;
    }

    public boolean getCheckPass() {
        return this.checkPass;
    }

    public void setTestHarness(boolean bl) {
        runningTestHarness = bl;
    }

    public boolean getTestHarness() {
        return runningTestHarness;
    }

    private void verification(Descriptor descriptor) {
        this.jarCheckImpl = new JarCheckImpl();
        this.jarCheckImpl.setVerifierContext(this.context);
        this.jarCheckImpl.setContextForCheckMgrs();
        boolean bl = JarCheckImpl.check(descriptor);
        if (runningTestHarness) {
            this.setCheckPass(true);
        }
        Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.endStaticVerification", "*******************************END \"Static Verification\""));
        if (isParseDDValid == 1 || !bl) {
            this.setCheckPass(false);
        }
        if (bl && isParseDDValid == 0) {
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".AllTestsPassed", "{0}: There were no failed tests.", new Object[]{descriptor.getName()}));
        } else {
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".SomeTestsFailed", "{0}: Some tests failed.", new Object[]{descriptor.getName()}));
        }
    }

    public boolean doit() throws ClassNotFoundException, IOException {
        Verifier.debug(this.smh.getLocalString(this.getClass().getName() + ".debug.beginStaticVerification", "*******************************BEGIN \"Static Verification\""));
        if (this.loadJar(jarFileName) == null) {
            if (!Verifier.hasAlreadyWrittenInvalidParseDetails()) {
                this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".ErrorLoading1", "Error loading: [ {0} ]", new Object[]{jarFileName}), this.smh.getLocalString(this.getClass().getName() + ".ErrorLoading2", "Unable to perform static testing, check XML file for validity."));
                this.resultReport.failureCount();
                this.resultReport.writeToFile();
            }
            this.cleanTMPFiles();
            return false;
        }
        this.cleanTMPFiles();
        return true;
    }

    public boolean writeDetails() {
        try {
            this.resultReport.setResultMgr(this.resultMgr);
            return this.resultReport.writeResults();
        }
        catch (Exception exception) {
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(exception)}));
            return false;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public boolean validateIASEjb(JarFile jarFile, String string) throws IOException {
        boolean bl = false;
        InputStream inputStream = this.getInputStream(jarFile, EjbBundleArchivist.IAS_DEPLOYMENT_DESCRIPTOR_ENTRY, string);
        if (inputStream != null) {
            ParseDD parseDD = new ParseDD();
            Result result = parseDD.validateIASEJBDescriptor(inputStream);
            isParseDDValid = result.getStatus();
            this.resultMgr.addResults(result);
            this.resultMgr.fireTestEvent(result);
            inputStream.close();
            bl = true;
        }
        return bl;
    }

    public EjbBundleDescriptor openEjbJar(File file) {
        try {
            JarExploder jarExploder = new JarExploder(this.TMP_DIR, file);
            EjbModuleInfo ejbModuleInfo = jarExploder.explode();
            File file2 = new File(this.TMP_DIR, ejbModuleInfo.getName());
            this.jcl.addDir(file2.toURL());
            EjbModuleConfigEnv ejbModuleConfigEnv = new EjbModuleConfigEnv(file2, file2.getName(), true);
            ejbModuleConfigEnv.setVerifying(true);
            Application application = EjbBundleXmlReader.loadStdAloneModule(ejbModuleConfigEnv, this.jcl);
            Set set = application.getEjbBundleDescriptors();
            Iterator iterator = set.iterator();
            EjbBundleDescriptor ejbBundleDescriptor = null;
            while (iterator.hasNext()) {
                ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
                if (!(ejbBundleDescriptor instanceof IASEjbBundleDescriptor)) continue;
                ((IASEjbBundleDescriptor)ejbBundleDescriptor).setModuleDirName(file2.getCanonicalPath());
            }
            return ejbBundleDescriptor;
        }
        catch (ZipException zipException) {
            this.setExceptionMessage(zipException);
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{zipException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(zipException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setExceptionMessage(illegalArgumentException);
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{illegalArgumentException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(illegalArgumentException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
        catch (Throwable throwable) {
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{throwable.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(throwable)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
    }

    public boolean validateIasCmp(Descriptor descriptor, JarFile jarFile) {
        EjbBundleDescriptor ejbBundleDescriptor;
        boolean bl = true;
        if (descriptor instanceof EjbBundleDescriptor && (ejbBundleDescriptor = (EjbBundleDescriptor)descriptor).getIasCmpMappings() != null) {
            try {
                ZipEntry zipEntry = jarFile.getEntry("META-INF/sun-cmp-mappings.xml");
                InputStream inputStream = jarFile.getInputStream(zipEntry);
                InputSource inputSource = new InputSource(inputStream);
                bl = this.validate(inputSource, "META-INF/sun-cmp-mappings.xml");
            }
            catch (Exception exception) {
                this.setExceptionMessage(exception);
                this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(exception)}));
                this.resultReport.failureCount();
                this.resultReport.writeToFile();
                bl = false;
            }
        }
        return bl;
    }

    public Application openApplication(File file) {
        String string;
        if (this.jcl == null) {
            this.createContext();
        }
        this.EAR_NAME = string = FileUtils.makeFriendlyFileNameNoExtension(file.getName());
        File file2 = new File(this.TMP_DIR, string);
        this.APP_DIR = file2.getAbsolutePath();
        try {
            Object object;
            Object object2;
            Object object3;
            ZipFile zipFile = new ZipFile(file, file2);
            ArrayList arrayList = zipFile.explode();
            AppConfigEnvImpl appConfigEnvImpl = new AppConfigEnvImpl(file2.getAbsolutePath(), file2.getName(), true);
            appConfigEnvImpl.setVerifying(true);
            ApplicationXmlReader applicationXmlReader = new ApplicationXmlReader(appConfigEnvImpl);
            this.jcl.addDir(file2.toURL());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object3 = file2 + File.separator + (String)iterator.next();
                if (((String)object3).endsWith(".jar")) {
                    object2 = new JarExploder(file2, new File((String)object3));
                    object = ((JarExploder)object2).explode();
                    File file3 = new File(file2, ((DeployableObjectInfo)object).getName());
                    this.jcl.addDir(file3.toURL());
                    continue;
                }
                if (((String)object3).endsWith(".war")) {
                    object2 = new WarExploder(file2, new File((String)object3));
                    object = ((WarExploder)object2).explode();
                    File file4 = new File(file2, ((DeployableObjectInfo)object).getName());
                    this.jcl.addDir(file4.toURL());
                    continue;
                }
                if (((String)object3).endsWith(".rar")) {
                    object2 = new RarExploder(file2, new File((String)object3));
                    object = ((RarExploder)object2).explode();
                    File file5 = new File(file2, ((DeployableObjectInfo)object).getName());
                    this.jcl.addDir(file5.toURL());
                    continue;
                }
                object2 = new File((String)object3);
                if (!((File)object2).isDirectory()) continue;
                object = ((File)object2).listFiles();
                for (int i = 0; i < ((File[])object).length; ++i) {
                    if (!((File)object[i]).getName().endsWith(".jar")) continue;
                    this.jcl.addJar(((File)object[i]).getAbsolutePath());
                }
            }
            object3 = applicationXmlReader.load(this.jcl);
            ((Application)object3).getApplicationArchivist().setApplicationFile(file);
            object2 = ((Application)object3).getEjbBundleDescriptors();
            object = object2.iterator();
            EjbBundleDescriptor ejbBundleDescriptor = null;
            while (object.hasNext()) {
                ejbBundleDescriptor = (EjbBundleDescriptor)object.next();
                String string2 = ejbBundleDescriptor.getArchivist().getArchiveUri();
                string2 = FileUtils.makeFriendlyFilename(string2);
                String string3 = file2.getCanonicalPath() + File.separator + string2;
                if (!(ejbBundleDescriptor instanceof IASEjbBundleDescriptor)) continue;
                ((IASEjbBundleDescriptor)ejbBundleDescriptor).setModuleDirName(string3);
            }
            return object3;
        }
        catch (Exception exception) {
            this.setExceptionMessage(exception);
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(exception)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
    }

    public File getExplodedFile(String string) {
        File file = new File(this.APP_DIR, string);
        return file;
    }

    public WebBundleDescriptor openWebApp(File file) {
        Application application = null;
        WebBundleDescriptor webBundleDescriptor = null;
        WebModuleConfigEnv webModuleConfigEnv = null;
        WebModuleInfo webModuleInfo = null;
        WarExploder warExploder = null;
        try {
            warExploder = new WarExploder(this.TMP_DIR, file);
            webModuleInfo = warExploder.explode();
            File file2 = new File(this.TMP_DIR, webModuleInfo.getName());
            webModuleConfigEnv = new WebModuleConfigEnv(file2, file2.getName(), true);
            webModuleConfigEnv.setVerifying(true);
            if (this.jcl != null) {
                this.jcl.addDir(file2.toURL());
            }
            application = WebBundleXmlReader.loadStdAloneModule(webModuleConfigEnv);
            Set set = application.getWebBundleDescriptors();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                webBundleDescriptor = (WebBundleDescriptor)iterator.next();
            }
        }
        catch (ZipFileException zipFileException) {
            this.setExceptionMessage(zipFileException);
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{zipFileException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(zipFileException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
        catch (AppConfigException appConfigException) {
            this.setExceptionMessage(appConfigException);
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{appConfigException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(appConfigException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
        catch (IOException iOException) {
            this.setExceptionMessage(iOException);
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(iOException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
        catch (Throwable throwable) {
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{throwable.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(throwable)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
        return webBundleDescriptor;
    }

    public void setIasObjects(Descriptor descriptor, JarFile jarFile) {
        Object object;
        EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)descriptor;
        SunEjbJar sunEjbJar = null;
        ZipEntry zipEntry = jarFile.getEntry("META-INF/sun-ejb-jar.xml");
        try {
            object = jarFile.getInputStream(zipEntry);
            sunEjbJar = SunEjbJar.createGraph((InputStream)object);
            ejbBundleDescriptor.setIasEjbObject(sunEjbJar);
        }
        catch (Exception exception) {
            System.out.println("ERROR : Could not Create an object representing META-INF/sun-ejb-jar.xml");
            exception.printStackTrace();
            return;
        }
        object = "META-INF/sun-cmp-mappings.xml";
        String string = "META-INF/sun-cmp-mappings.xml";
        if (object != null) {
            try {
                ZipEntry zipEntry2 = jarFile.getEntry((String)object);
                if (zipEntry2 != null) {
                    InputStream inputStream = jarFile.getInputStream(zipEntry2);
                    SunCmpMappings sunCmpMappings = SunCmpMappings.createGraph(inputStream);
                    ejbBundleDescriptor.setIasCmpMappingObject(sunCmpMappings);
                }
            }
            catch (ZipException zipException) {
                this.setExceptionMessage(zipException);
                this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{zipException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(zipException)}));
                this.resultReport.failureCount();
                this.resultReport.writeToFile();
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setExceptionMessage(illegalArgumentException);
                this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{illegalArgumentException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(illegalArgumentException)}));
                this.resultReport.failureCount();
                this.resultReport.writeToFile();
                return;
            }
            catch (Throwable throwable) {
                this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{throwable.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(throwable)}));
                this.resultReport.failureCount();
                this.resultReport.writeToFile();
                return;
            }
        }
    }

    public ConnectorDescriptor openConnector(File file) {
        Application application = null;
        ConnectorDescriptor connectorDescriptor = null;
        RarModuleConfigEnv rarModuleConfigEnv = null;
        ConnectorModuleInfo connectorModuleInfo = null;
        RarExploder rarExploder = null;
        try {
            Set set;
            rarExploder = new RarExploder(this.TMP_DIR, file);
            connectorModuleInfo = rarExploder.explode();
            File file2 = new File(this.TMP_DIR, connectorModuleInfo.getName());
            rarModuleConfigEnv = new RarModuleConfigEnv(file2, file2.getName(), true);
            rarModuleConfigEnv.setVerifying(true);
            if (this.jcl != null) {
                this.jcl.addDir(file2.toURL());
            }
            if ((set = (application = ConnectorXmlReader.loadStdAloneModule(rarModuleConfigEnv)).getRarDescriptors()) != null && set.size() > 0) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    connectorDescriptor = (ConnectorDescriptor)iterator.next();
                }
            }
        }
        catch (ZipFileException zipFileException) {
            this.setExceptionMessage(zipFileException);
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{zipFileException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(zipFileException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
        catch (AppConfigException appConfigException) {
            this.setExceptionMessage(appConfigException);
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{appConfigException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(appConfigException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
        catch (IOException iOException) {
            this.setExceptionMessage(iOException);
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", "{0}", new Object[]{this.resultReport.writeStackTraceToFile(iOException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
        catch (Throwable throwable) {
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{throwable.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(throwable)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
        return connectorDescriptor;
    }

    public ResultsReport verifyEar(Application application, String string) {
        BundleDescriptor bundleDescriptor;
        String string2;
        ClassLoader classLoader = application.getApplicationArchivist().getClassLoader();
        try {
            string2 = application.getRegistrationName() + ".ear" + outputFileSuffix;
        }
        catch (Exception exception) {
            string2 = null;
        }
        this.preVerify(classLoader, string2);
        this.verification(application);
        Iterator iterator = application.getWebBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            bundleDescriptor = (WebBundleDescriptor)iterator.next();
            this.verification(bundleDescriptor);
        }
        iterator = application.getEjbBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            bundleDescriptor = (EjbBundleDescriptor)iterator.next();
            ((IASEjbBundleDescriptor)bundleDescriptor).setModuleDirName(string + File.separator + Verifier.getModuleDirName((EjbBundleDescriptor)bundleDescriptor));
            this.verification(bundleDescriptor);
        }
        iterator = application.getRarDescriptors().iterator();
        while (iterator.hasNext()) {
            bundleDescriptor = (ConnectorDescriptor)iterator.next();
            this.verification(bundleDescriptor);
        }
        iterator = application.getApplicationClientDescriptors().iterator();
        while (iterator.hasNext()) {
            bundleDescriptor = (ApplicationClientDescriptor)iterator.next();
            this.verification(bundleDescriptor);
        }
        this.postVerify();
        return this.resultReport;
    }

    public ResultsReport verifyStdAloneJar(EjbBundleDescriptor ejbBundleDescriptor, String string) {
        String string2;
        EjbBundleArchivist ejbBundleArchivist = (EjbBundleArchivist)ejbBundleDescriptor.getArchivist();
        ClassLoader classLoader = ejbBundleArchivist.getClassLoader();
        try {
            string2 = ejbBundleDescriptor.getApplication().getRegistrationName() + ".jar" + outputFileSuffix;
        }
        catch (Exception exception) {
            string2 = null;
        }
        this.preVerify(classLoader, string2);
        ((IASEjbBundleDescriptor)ejbBundleDescriptor).setModuleDirName(string);
        this.verification(ejbBundleDescriptor);
        this.postVerify();
        return this.resultReport;
    }

    public ResultsReport verifyStdAloneWar(WebBundleDescriptor webBundleDescriptor) {
        String string;
        try {
            string = webBundleDescriptor.getApplication().getRegistrationName() + ".war" + outputFileSuffix;
        }
        catch (Exception exception) {
            string = null;
        }
        this.preVerify(null, string);
        this.verification(webBundleDescriptor);
        this.postVerify();
        return this.resultReport;
    }

    public ResultsReport verifyStdAloneRar(ConnectorDescriptor connectorDescriptor) {
        String string;
        try {
            string = connectorDescriptor.getApplication().getRegistrationName() + ".rar" + outputFileSuffix;
        }
        catch (Exception exception) {
            string = null;
        }
        this.preVerify(null, string);
        this.verification(connectorDescriptor);
        this.postVerify();
        return this.resultReport;
    }

    private void preVerify(ClassLoader classLoader, String string) {
        Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".startVerifierRun", "-----------VERIFYING-----------"));
        if (string != null) {
            String string2 = System.getProperty("java.io.tmpdir");
            this.setResultFileName(string2 + File.separator + string);
        }
        Descriptor.setBoundsChecking(false);
        this.resultReport.initialize();
        this.context = new Context(classLoader);
        this.context.setDeployRuntime(true);
        CheckMgr.testscount = 0;
        CheckMgr.exclcount = 0;
        JarCheckImpl.clearAllResults();
    }

    private void postVerify() {
        this.writeDetails();
        Descriptor.setBoundsChecking(true);
        Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".nooftestsdone", "Number of tests done: {0}", new Object[]{new Integer(CheckMgr.testscount)}));
        Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".nooftestsexcluded", "Number of tests excluded: {0}", new Object[]{new Integer(CheckMgr.exclcount)}));
        Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".endVerifierRun", "-------VERIFICATION DONE-------"));
    }

    private static String getModuleDirName(EjbBundleDescriptor ejbBundleDescriptor) {
        String string = ejbBundleDescriptor.getArchivist().getArchiveUri();
        return FileUtils.makeFriendlyFilename(string);
    }

    public boolean verifyAndSetResultDir(String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                if (file.isDirectory()) {
                    if (file.canWrite()) {
                        outputDirName = string;
                        return true;
                    }
                    Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".log.noPermissions", "No permissions to create results file into the specified destination directory \"{0}\"", new Object[]{string}));
                    return false;
                }
                Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".log.notADir", "Specified location is not a directory \"{0}\"", new Object[]{string}));
                return false;
            }
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".log.noDirExists", "Specified directory does not exist \"{0}\"", new Object[]{string}));
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private InputStream getInputStream(JarFile jarFile, String string, String string2) {
        InputStream inputStream = null;
        try {
            ZipEntry zipEntry;
            if (this.application != null && string2 != null) {
                inputStream = this.fetchAltDDFromApplication(string2);
            }
            if (inputStream == null && (zipEntry = jarFile.getEntry(string)) != null) {
                inputStream = jarFile.getInputStream(zipEntry);
            }
        }
        catch (IOException iOException) {
            this.setExceptionMessage(iOException);
            Verifier.debug(iOException);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".IOException", "Error: ** Error trying to process file:  {0}", new Object[]{jarFile.getName()}));
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(iOException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
        return inputStream;
    }

    private InputStream fetchAltDDFromApplication(String string) {
        if (this.application == null) {
            return null;
        }
        File file = null;
        try {
            file = ((Application)this.application).getApplicationArchivist().getApplicationFile();
            JarFile jarFile = new JarFile(file);
            ZipEntry zipEntry = jarFile.getEntry(string);
            if (zipEntry != null) {
                return jarFile.getInputStream(zipEntry);
            }
        }
        catch (IOException iOException) {
            this.setExceptionMessage(iOException);
            Verifier.debug(iOException);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".IOException", "Error: ** Error trying to process file {0}", new Object[]{file.getName()}));
            this.resultReport.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.resultReport.writeStackTraceToFile(iOException)}));
            this.resultReport.failureCount();
            this.resultReport.writeToFile();
            return null;
        }
        return null;
    }
}

