/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl;
import com.sun.enterprise.tools.verifier.appclient.AppClientCheckMgrImpl;
import com.sun.enterprise.tools.verifier.connector.ConnectorCheckMgrImpl;
import com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl;
import com.sun.enterprise.tools.verifier.web.WebCheckMgrImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;

public class JarCheckImpl {
    private static final EjbCheckMgrImpl ejbCheckMgr = new EjbCheckMgrImpl();
    private static final WebCheckMgrImpl webCheckMgr = new WebCheckMgrImpl();
    private static final AppCheckMgrImpl appCheckMgr = new AppCheckMgrImpl();
    private static final AppClientCheckMgrImpl appClientCheckMgr = new AppClientCheckMgrImpl();
    private static final ConnectorCheckMgrImpl connectorCheckMgr = new ConnectorCheckMgrImpl();
    private static final JarCheck[] checkMgrs = new JarCheck[]{connectorCheckMgr, webCheckMgr, appClientCheckMgr, appCheckMgr, ejbCheckMgr};
    private static final boolean debug = Verifier.getDebug();
    private Context context = null;

    public static JarCheck[] getCheckMgrs() {
        return checkMgrs;
    }

    public static void clearAllResults() {
        for (int i = 0; i < checkMgrs.length; ++i) {
            checkMgrs[i].clearAllResults();
        }
    }

    public void setVerifierContext(Context context) {
        this.context = context;
    }

    public Context getVerifierContext() {
        return this.context;
    }

    public void setContextForCheckMgrs() {
        for (int i = 0; i < checkMgrs.length; ++i) {
            checkMgrs[i].setVerifierContext(this.context);
        }
    }

    public static boolean check(Descriptor descriptor) {
        LocalStringManagerImpl localStringManagerImpl = StringManagerHelper.getLocalStringsManager();
        boolean bl = true;
        for (int i = 0; i < checkMgrs.length; ++i) {
            if (!checkMgrs[i].handleDescriptor(descriptor)) continue;
            if (debug) {
                System.out.println(localStringManagerImpl.getLocalString("com.sun.enterprise.tools.verifier.JarCheckImpl.debug.Bundle", "-instance of {0}: [ {1} ]", new Object[]{descriptor.getClass(), descriptor}));
            }
            if (checkMgrs[i].check(descriptor)) continue;
            bl = false;
        }
        return bl;
    }

    public static boolean check(Iterator iterator) {
        if (iterator == null) {
            return true;
        }
        boolean bl = true;
        while (iterator.hasNext()) {
            if (JarCheckImpl.check((Descriptor)iterator.next())) continue;
            bl = false;
        }
        return bl;
    }
}

