/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.ResultsRecord;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.TestInformation;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierEventsListener;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.crimson.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class CheckMgr {
    static int testscount = 0;
    static int exclcount = 0;
    static Vector listenerList = new Vector();
    protected final boolean debug = Verifier.getDebug();
    public LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    String description = "no description";
    private Context context = null;

    public Context getVerifierContext() {
        return this.context;
    }

    public void setVerifierContext(Context context) {
        this.context = context;
    }

    public static void addVerifierEventsListener(VerifierEventsListener verifierEventsListener) {
        listenerList.add(verifierEventsListener);
    }

    public static void removeVerifierEventsListener(VerifierEventsListener verifierEventsListener) {
        listenerList.remove(verifierEventsListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTestFinishedEvent(Result result) {
        Object[] objectArray;
        Vector vector = listenerList;
        synchronized (vector) {
            objectArray = listenerList.toArray();
        }
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof VerifierEventsListener)) continue;
            EventObject eventObject = new EventObject(result);
            ((VerifierEventsListener)objectArray[i]).testFinished(eventObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAllTestsFinishedEvent() {
        Object[] objectArray;
        Vector vector = listenerList;
        synchronized (vector) {
            objectArray = listenerList.toArray();
        }
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof VerifierEventsListener)) continue;
            EventObject eventObject = new EventObject(this);
            ((VerifierEventsListener)objectArray[i]).allTestsFinished(eventObject);
        }
    }

    public abstract Vector getTests();

    public abstract String getTestsListFileName();

    public abstract Vector getAllResults();

    public abstract String[][] getAcceptableDoctypes();

    public abstract String getDeploymentEntryName();

    public String getArchiveUri(Descriptor descriptor) {
        return ((BundleDescriptor)descriptor).getArchivist().getArchiveUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSpecVersionFor(Descriptor descriptor) {
        BufferedReader bufferedReader;
        String string = descriptor.getDocType();
        if (string != null) {
            return this.getVersionFromDocType(string);
        }
        String string2 = new File(this.getArchiveUri(descriptor)).getName();
        File file = Verifier.getArchiveFile(string2);
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            ZipEntry zipEntry = jarFile.getEntry(this.getDeploymentEntryName());
            if (zipEntry != null) {
                bufferedReader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(zipEntry)));
                string = bufferedReader.readLine();
                while (true) {
                    if (string != null) {
                        if (string.indexOf("DOCTYPE") > -1) {
                            String string3 = this.getVersionFromDocType(string);
                            return string3;
                        }
                        string = bufferedReader.readLine();
                        continue;
                    }
                    break;
                }
            }
        }
        catch (IOException iOException) {
            bufferedReader = null;
            return bufferedReader;
        }
        finally {
            try {
                jarFile.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public String getVersionFromDocType(String string) {
        try {
            String[][] stringArray = this.getAcceptableDoctypes();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i][0];
                if (string.indexOf(string2) <= -1) continue;
                String string3 = stringArray[i][1];
                return string3;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public void clearAllResults() {
        Vector vector = this.getAllResults();
        if (vector != null) {
            vector.clear();
        }
    }

    protected boolean loadTestInformationFromPropsFile() {
        boolean bl = true;
        Vector vector = this.getTests();
        vector.clear();
        if (this.debug) {
            System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.CheckMgr.TestnamesPropsFile", "About to get all test names from props file."));
        }
        File file = this.getTestsFileFor(this.getTestsListFileName());
        try {
            DocumentBuilder documentBuilder = new DocumentBuilderFactoryImpl().newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            NodeList nodeList = document.getElementsByTagName("description");
            if (nodeList.getLength() > 0) {
                Element element = (Element)nodeList.item(0);
                this.description = element.getFirstChild().getNodeValue().trim();
            }
            nodeList = document.getElementsByTagName("test");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                NodeList nodeList2 = element.getChildNodes();
                TestInformation testInformation = new TestInformation();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node;
                    String string = nodeList2.item(j).getNodeName();
                    if ("test-class".equals(string.trim())) {
                        node = nodeList2.item(j);
                        testInformation.setClassName(node.getFirstChild().getNodeValue().trim());
                    }
                    if ("minimum-version".equals(string.trim())) {
                        node = nodeList2.item(j);
                        testInformation.setMinimumVersion(node.getFirstChild().getNodeValue().trim());
                    }
                    if (!"maximum-version".equals(string.trim())) continue;
                    node = nodeList2.item(j);
                    testInformation.setMaximumVersion(node.getFirstChild().getNodeValue().trim());
                }
                vector.addElement(testInformation);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Verifier.debug(parserConfigurationException);
            System.out.println(this.smh.getLocalString("CheckMgr.ParserConfigurationException", "Error in reading/loading tests .. ParserConfigurationException" + parserConfigurationException.getMessage(), new Object[]{parserConfigurationException.getMessage()}));
            bl = false;
        }
        catch (SAXException sAXException) {
            Verifier.debug(sAXException);
            System.out.println(this.smh.getLocalString("CheckMgr.SAXException", "Error in reading/loading tests .. SAXException" + sAXException.getMessage(), new Object[]{sAXException.getMessage()}));
            bl = false;
        }
        catch (IOException iOException) {
            Verifier.debug(iOException);
            System.out.println(this.smh.getLocalString("CheckMgr.IOException", "Error in reading/loading tests .. IOException" + iOException.getMessage(), new Object[]{iOException.getMessage()}));
            bl = false;
        }
        if (bl) {
            bl = this.readSunONETests(vector);
        }
        return bl;
    }

    private File getTestsFileFor(String string) {
        File file = null;
        if (Verifier.getIsUserConfigDir()) {
            file = new File(Verifier.getConfigDir());
            file = new File(file, string);
        } else {
            file = new File(System.getProperty("com.sun.aas.installRoot"));
            file = new File(file, "lib");
            file = new File(file, "verifier");
            file = new File(file, string);
            if (this.debug) {
                System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.CheckMgr.RetrievingTestnames", "Retrieving Test names from [ {0} ]", new Object[]{file.toString()}));
            }
        }
        return new File(file.toString());
    }

    public boolean check(Descriptor descriptor) {
        boolean bl = true;
        if (this.debug) {
            System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.CheckMgr.check", "inside {0}.check for [ {1} ]", new Object[]{this.getClass().getName(), descriptor.getName()}));
        }
        if (bl = this.loadTestInformationFromPropsFile()) {
            Hashtable<String, Result> hashtable = new Hashtable<String, Result>();
            Hashtable<String, Result> hashtable2 = new Hashtable<String, Result>();
            Hashtable<String, Result> hashtable3 = new Hashtable<String, Result>();
            Hashtable<String, Result> hashtable4 = new Hashtable<String, Result>();
            if (this.debug) {
                System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.web.CheckMgr.RunAllTests", "Now run all tests against [ {0} ]", new Object[]{descriptor.getName()}));
            }
            Vector vector = this.getTests();
            String string = this.getSpecVersionFor(descriptor);
            HashSet hashSet = null;
            hashSet = this.getExcludeTestList();
            for (int i = 0; i < vector.size(); ++i) {
                try {
                    Result result = new Result();
                    TestInformation testInformation = (TestInformation)vector.elementAt(i);
                    if (hashSet != null && hashSet.contains(testInformation.getClassName())) {
                        ++exclcount;
                        continue;
                    }
                    String string2 = testInformation.getMinimumVersion();
                    String string3 = testInformation.getMaximumVersion();
                    if (string != null && string2 != null && string.compareTo(string2) < 0) {
                        result.notApplicable(this.smh.getLocalString("com.sun.enterprise.tools.verifier.CheckMgr.version.NOT_APPLICABLE", " {0}  [ VERSION NOT_APPLICABLE ]", new Object[]{testInformation.getClassName()}));
                        continue;
                    }
                    if (string != null && string3 != null && string.compareTo(string3) > 0) {
                        result.notApplicable(this.smh.getLocalString("com.sun.enterprise.tools.verifier.CheckMgr.version.NOT_APPLICABLE", " {0}  [ VERSION NOT_APPLICABLE ]", new Object[]{testInformation.getClassName()}));
                        continue;
                    }
                    Class<?> clazz = Class.forName(testInformation.getClassName());
                    try {
                        VerifierCheck verifierCheck = (VerifierCheck)clazz.newInstance();
                        try {
                            verifierCheck.setVerifierContext(this.context);
                            ++testscount;
                            result = verifierCheck.check(descriptor);
                            result.setComponentName(descriptor.getName());
                        }
                        catch (Throwable throwable) {
                            if (this.debug) {
                                System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.CheckMgr.unexpectedError", "Unexpected error in verifier, check for problems related to: [ {0} ]", new Object[]{throwable.toString()}));
                            }
                            Verifier.debug(throwable);
                            result.init(clazz);
                            result.failed(this.smh.getLocalString("com.sun.enterprise.tools.verifier.CheckMgr.unexpectedError", "Unexpected error in verifier, check for problems related to: [ {0} ]", new Object[]{throwable.toString()}));
                            result.setComponentName(descriptor.getName());
                        }
                        this.fireTestFinishedEvent(result);
                        if (result.getStatus() == 1) {
                            if (this.debug) {
                                System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.CheckMgr.status.FAILED", " {0}  [ FAILED ]", new Object[]{result.getTestName()}));
                            }
                            hashtable2.put(result.getTestName(), result);
                            bl = false;
                            continue;
                        }
                        if (result.getStatus() == 0) {
                            if (this.debug) {
                                System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.CheckMgr.status.PASSED", " {0}  [ PASSED ]", new Object[]{result.getTestName()}));
                            }
                            hashtable3.put(result.getTestName(), result);
                            continue;
                        }
                        if (result.getStatus() == 2) {
                            if (this.debug) {
                                System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.CheckMgr.status.WARNING", " {0}  [ WARNING ]", new Object[]{result.getTestName()}));
                            }
                            hashtable.put(result.getTestName(), result);
                            continue;
                        }
                        if (result.getStatus() != 3 && result.getStatus() != 4 && result.getStatus() != 5) continue;
                        if (this.debug) {
                            System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.CheckMgr.status.NOT_APPLICABLE", " {0}  [ NOT_APPLICABLE ]", new Object[]{result.getTestName()}));
                        }
                        hashtable4.put(result.getTestName(), result);
                    }
                    catch (InstantiationException instantiationException) {
                        Verifier.debug(instantiationException);
                        bl = false;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Verifier.debug(illegalAccessException);
                        bl = false;
                    }
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Verifier.debug(this.smh.getLocalString("CheckMgr.ClassNotFoundException", "Verifier test class [ " + ((TestInformation)vector.elementAt(i)).getClassName() + " ] not found.", new Object[]{((TestInformation)vector.elementAt(i)).getClassName()}));
                }
            }
            ResultsRecord resultsRecord = new ResultsRecord();
            resultsRecord.setPassedResults(hashtable3);
            resultsRecord.setFailedResults(hashtable2);
            resultsRecord.setNaResults(hashtable4);
            resultsRecord.setWarningResults(hashtable);
            this.getAllResults().addElement(resultsRecord);
        }
        this.fireAllTestsFinishedEvent();
        return bl;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract String getSunONETestsListFileName();

    public boolean readSunONETests(Vector vector) {
        boolean bl = true;
        String string = this.getSunONETestsListFileName();
        if (string == null) {
            return true;
        }
        File file = this.getTestsFileFor(string);
        if (!file.exists()) {
            return true;
        }
        try {
            DocumentBuilder documentBuilder = new DocumentBuilderFactoryImpl().newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            NodeList nodeList = document.getElementsByTagName("description");
            if (nodeList.getLength() > 0) {
                Element element = (Element)nodeList.item(0);
                this.description = element.getFirstChild().getNodeValue().trim();
            }
            nodeList = document.getElementsByTagName("test");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                NodeList nodeList2 = element.getChildNodes();
                TestInformation testInformation = new TestInformation();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node;
                    String string2 = nodeList2.item(j).getNodeName();
                    if ("test-class".equals(string2.trim())) {
                        node = nodeList2.item(j);
                        testInformation.setClassName(node.getFirstChild().getNodeValue().trim());
                    }
                    if ("minimum-version".equals(string2.trim())) {
                        node = nodeList2.item(j);
                        testInformation.setMinimumVersion(node.getFirstChild().getNodeValue().trim());
                    }
                    if (!"maximum-version".equals(string2.trim())) continue;
                    node = nodeList2.item(j);
                    testInformation.setMaximumVersion(node.getFirstChild().getNodeValue().trim());
                }
                vector.addElement(testInformation);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Verifier.debug(parserConfigurationException);
            System.out.println(this.smh.getLocalString("CheckMgr.ParserConfigurationException", "Error in reading/loading tests .. ParserConfigurationException" + parserConfigurationException.getMessage(), new Object[]{parserConfigurationException.getMessage()}));
            bl = false;
        }
        catch (SAXException sAXException) {
            System.out.println(this.smh.getLocalString("CheckMgr.SAXException", "Error in reading/loading tests .. SAXException" + sAXException.getMessage(), new Object[]{sAXException.getMessage()}));
            Verifier.debug(sAXException);
            bl = false;
        }
        catch (IOException iOException) {
            System.out.println(this.smh.getLocalString("CheckMgr.IOException", "Error in reading/loading tests .. IOException" + iOException.getMessage(), new Object[]{iOException.getMessage()}));
            Verifier.debug(iOException);
            bl = false;
        }
        return bl;
    }

    public static String getSunPrefix() {
        return "sun-";
    }

    private HashSet getExcludeTestList() {
        String[] stringArray;
        HashSet<String> hashSet = null;
        if (this.context != null && this.context.isDeployRuntime() && (stringArray = this.getExcludeTestNames()) != null) {
            int n = stringArray.length;
            hashSet = new HashSet<String>();
            for (int i = 0; i < n; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        return hashSet;
    }

    public abstract String[] getExcludeTestNames();
}

