/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.backend;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Vector;

public class JarRepository {
    private static final String SERVERJAR = ".serverJar";
    private static final String ORIGINALJAR = ".originalJar";
    private static final String CLIENTJAR = ".clientJar";
    private static final String WEBJAR = ".webJar";
    private static final String PREFIX = "server.";
    private static final String SERVER = "server";
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JarRepository.class);

    public static boolean removeFromPropsFile(String string) {
        ServerConfiguration serverConfiguration = ServerConfiguration.getConfiguration();
        String string2 = PREFIX + string;
        String string3 = string2 + SERVERJAR;
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.removingkey", "Removing: {0}", new Object[]{string3}));
        try {
            serverConfiguration.removeProperty(string3);
            string3 = string2 + CLIENTJAR;
            serverConfiguration.removeProperty(string3);
            string3 = string2 + WEBJAR;
            serverConfiguration.removeProperty(string3);
            string3 = string2 + ORIGINALJAR;
            serverConfiguration.removeProperty(string3);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getJarName(String string) {
        ServerConfiguration serverConfiguration = ServerConfiguration.getConfiguration();
        String string2 = PREFIX + string + SERVERJAR;
        String string3 = serverConfiguration.getProperty(string2);
        return string3;
    }

    public static String getJarFilename(String string) {
        ServerConfiguration serverConfiguration = ServerConfiguration.getConfiguration();
        String string2 = PREFIX + string + ORIGINALJAR;
        String string3 = serverConfiguration.getProperty(string2);
        try {
            return new URL(string3).getFile();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static String getServerJarFilename(String string) {
        ServerConfiguration serverConfiguration = ServerConfiguration.getConfiguration();
        String string2 = PREFIX + string + SERVERJAR;
        String string3 = serverConfiguration.getProperty(string2);
        try {
            return new URL(string3).getFile();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static String getClientJarFilename(String string) {
        ServerConfiguration serverConfiguration = ServerConfiguration.getConfiguration();
        String string2 = PREFIX + string + CLIENTJAR;
        String string3 = serverConfiguration.getProperty(string2);
        return string3;
    }

    static Vector getApplicationJarFilenamesFor(String string) {
        ServerConfiguration serverConfiguration = ServerConfiguration.getConfiguration();
        HashSet<String> hashSet = new HashSet<String>();
        try {
            String string2;
            String string3;
            String string4;
            String string5 = serverConfiguration.getProperty(PREFIX + string + SERVERJAR);
            if (string5 != null) {
                hashSet.add(new URL(string5).getFile());
            }
            if ((string4 = serverConfiguration.getProperty(PREFIX + string + CLIENTJAR)) != null) {
                hashSet.add(new URL(string4).getFile());
            }
            if ((string3 = serverConfiguration.getProperty(PREFIX + string + WEBJAR)) != null) {
                hashSet.add(new URL(string3).getFile());
            }
            if ((string2 = serverConfiguration.getProperty(PREFIX + string + ORIGINALJAR)) != null) {
                hashSet.add(new URL(string2).getFile());
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return new Vector(hashSet);
    }

    static String writeToPropsFile(String string, File file, File file2, File file3) {
        String string2 = file.getName();
        String string3 = PREFIX + string;
        ServerConfiguration serverConfiguration = ServerConfiguration.getConfiguration();
        String string4 = string3 + ORIGINALJAR;
        String string5 = string3 + SERVERJAR;
        String string6 = string3 + CLIENTJAR;
        String string7 = string3 + WEBJAR;
        try {
            URL uRL = file.toURL();
            URL uRL2 = file3.toURL();
            URL uRL3 = file2.toURL();
            serverConfiguration.setProperty(string4, uRL.toString());
            serverConfiguration.setProperty(string6, uRL2.toString());
            serverConfiguration.setProperty(string5, uRL3.toString());
            serverConfiguration.setProperty(string7, uRL3.toString());
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(localStrings.getLocalString("enterprise.tools.deployment.backend.installfailedinrepository", "Failed to install {0} in the repository.", new Object[]{string3}));
            malformedURLException.printStackTrace();
        }
        return string5;
    }

    public static Application getApplicationForName(String string) {
        try {
            ServerConfiguration serverConfiguration = ServerConfiguration.getConfiguration();
            String string2 = serverConfiguration.getProperty(PREFIX + string + ORIGINALJAR);
            if (string2 != null) {
                File file = new File(new URL(string2).getFile());
                return ApplicationArchivist.open(file);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static Vector getApplicationList() {
        Vector<String> vector = new Vector<String>();
        ServerConfiguration serverConfiguration = ServerConfiguration.getConfiguration();
        String[] stringArray = serverConfiguration.getKeys(SERVER);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(SERVERJAR)) continue;
            int n = stringArray[i].lastIndexOf(".");
            String string = stringArray[i].substring(0, n);
            n = string.indexOf(".");
            String string2 = string.substring(n + 1);
            vector.add(string2);
        }
        return vector;
    }
}

