/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.backend;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.ejb.PersistenceUtils;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.security.application.EJBSecurityManager;
import com.sun.enterprise.tools.deployment.backend.JarInfo;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class JarManagerImpl {
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JarManagerImpl.class);
    private boolean useOneLoader;
    private Hashtable jars = new Hashtable();
    private Hashtable appTable = new Hashtable();
    private Hashtable containerTable = new Hashtable();

    private Set getEJBClasses(Application application, ClassLoader classLoader) throws ClassNotFoundException {
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration enumeration = application.getEjbDescriptors().elements();
        while (enumeration.hasMoreElements()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)enumeration.nextElement();
            String string = ejbDescriptor.getEjbClassName();
            Class<?> clazz = classLoader.loadClass(string);
            do {
                hashSet.add(clazz.getName());
            } while ((clazz = clazz.getSuperclass()) != null);
        }
        return hashSet;
    }

    public void loadJar(String string) throws RemoteException {
        try {
            Object object;
            Object object2;
            Object object3;
            File file = new File(string);
            Application application = ApplicationArchivist.open(file, true);
            JarClassLoader jarClassLoader = new JarClassLoader();
            jarClassLoader.appendURL(file.toURL());
            Set set = this.getEJBClasses(application, jarClassLoader);
            final ClassLoader classLoader = application.getApplicationArchivist().getClassLoader();
            ((JarClassLoader)classLoader).addEjbClassNames(set);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
            JarInfo jarInfo = new JarInfo(application);
            this.jars.put(application.getName(), jarInfo);
            this.appTable.put(classLoader, application);
            Vector vector = application.getEjbDescriptors();
            Enumeration enumeration = vector.elements();
            ContainerFactory containerFactory = Switch.getSwitch().getContainerFactory();
            while (enumeration.hasMoreElements()) {
                object3 = (EjbDescriptor)enumeration.nextElement();
                try {
                    object2 = new EJBSecurityManager(classLoader, (EjbDescriptor)object3);
                    object = containerFactory.createContainer((EjbDescriptor)object3, classLoader, (SecurityManager)object2);
                    jarInfo.addContainer(((EjbDescriptor)object3).getUniqueId(), (Container)object);
                    this.containerTable.put(object3, object);
                }
                catch (Exception exception) {
                    this.undeploy(application.getName());
                    throw exception;
                }
            }
            object3 = application.getEjbBundleDescriptors().iterator();
            while (object3.hasNext()) {
                object2 = (EjbBundleDescriptor)object3.next();
                object = PersistenceUtils.getPMDeployer((EjbBundleDescriptor)object2);
                object.ejbJarDeployed();
            }
            object2 = jarInfo.listContainers();
            while (object2.hasMoreElements()) {
                object = (Container)object2.nextElement();
                object.doAfterApplicationDeploy();
            }
        }
        catch (Exception exception) {
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.errorloadingjar", "Error while loading JAR {0} ", new Object[]{string}), exception);
        }
    }

    public synchronized void undeploy(String string) {
        Object object;
        Object object2;
        Object object3;
        Switch switch_ = Switch.getSwitch();
        JarInfo jarInfo = (JarInfo)this.jars.get(string);
        if (jarInfo == null) {
            return;
        }
        ContainerFactory containerFactory = Switch.getSwitch().getContainerFactory();
        Enumeration enumeration = jarInfo.listContainers();
        while (enumeration.hasMoreElements()) {
            object3 = (Container)enumeration.nextElement();
            object2 = object3.getEjbDescriptor();
            containerFactory.removeContainer(((EjbDescriptor)object2).getUniqueId());
            object3.undeploy();
            object = this.containerTable.remove(object2);
            if (object != null) continue;
            Log.err.println(new IllegalStateException("cannot cleanup containerTable: " + object2));
        }
        this.jars.remove(string);
        object3 = jarInfo.application.getEjbBundleDescriptors().iterator();
        while (object3.hasNext()) {
            object2 = (EjbBundleDescriptor)object3.next();
            object = PersistenceUtils.getPMDeployer((EjbBundleDescriptor)object2);
            object.ejbJarUnDeployed();
        }
        object2 = this.getClassLoaderForApplication(string);
        object = this.appTable.remove(object2);
        if (object == null) {
            Log.err.println(new IllegalStateException("cannot cleanup appTable: " + string));
        }
    }

    public Container getContainer(EjbDescriptor ejbDescriptor) {
        return (Container)this.containerTable.get(ejbDescriptor);
    }

    public Application getApplication(ClassLoader classLoader) {
        return (Application)this.appTable.get(classLoader);
    }

    public ClassLoader getClassLoaderForApplication(String string) {
        Enumeration enumeration = this.appTable.keys();
        while (enumeration.hasMoreElements()) {
            ClassLoader classLoader = (ClassLoader)enumeration.nextElement();
            Application application = (Application)this.appTable.get(classLoader);
            if (!application.getName().equals(string)) continue;
            return classLoader;
        }
        return null;
    }

    public Application getApplication(String string) {
        ClassLoader classLoader = this.getClassLoaderForApplication(string);
        if (classLoader == null) {
            return null;
        }
        return this.getApplication(classLoader);
    }
}

