/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.backend;

import com.iplanet.ias.jms.IASJmsConfig;
import com.sun.ejb.codegen.GeneratorDriver;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.deployment.AbstractArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.DeploymentContext;
import com.sun.enterprise.deployment.DirectoryArchive;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.resource.ConnectorInfo;
import com.sun.enterprise.resource.NameNotFoundException;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.tools.deployment.backend.ApplicationRegistry;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import com.sun.enterprise.tools.deployment.backend.JarManagerImpl;
import com.sun.enterprise.tools.deployment.backend.JarRepository;
import com.sun.enterprise.tools.deployment.backend.RemoteNotificationListener;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import org.xml.sax.SAXParseException;

public class JarInstallerImpl
implements JarInstaller {
    private static final boolean debug = false;
    private static boolean validateXML = true;
    private static boolean cleanTmpDir = true;
    static final String VALIDATING_PARSER = "deployment.validating.parser";
    static final String CLEAN_TMP_DIR = "deployment.tmpdir.clean";
    public static final String CODEBASE_PREFIX = "http://" + Utility.getLocalAddress() + ":";
    public static final String SERVER_CHANGED = "ServerChanged";
    public static String port = null;
    public static String jit = System.getProperty("java.compiler");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JarInstallerImpl.class);
    private static int uniqueId = (int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL);
    private static Hashtable ejbJarCache = new Hashtable();
    private Vector listeners = new Vector();
    private InitialContext ic = null;
    private ApplicationRegistry applicationRegistry = null;
    private IASJmsConfig jmsConfig_ = null;

    public String deployApplication(byte[] byArray, String string, DeploymentSession deploymentSession) throws RemoteException {
        Object object;
        boolean bl;
        Serializable serializable;
        Object object2;
        Object object3;
        File file;
        Object var5_4 = null;
        String string2 = null;
        int n = 0;
        Application application = null;
        DeploymentContext deploymentContext = null;
        File file2 = null;
        this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.contacted.server", "Contacted server..."), deploymentSession);
        try {
            file = this.applicationRegistry.newApplicationJarFile(string);
            this.saveAsBytes(byArray, file);
            this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.application.transferred", "Application {0} transferred", new Object[]{string}), deploymentSession);
            this.progressEvent("Application Transferred", deploymentSession);
            file2 = DeploymentContext.createApplicationTempDirectory(string);
            JarClassLoader jarClassLoader = new JarClassLoader();
            jarClassLoader.addDir(file2.toURL());
            application = ApplicationArchivist.open(file, false, null, true);
            object3 = new DirectoryArchive(file2.getAbsolutePath());
            application.getApplicationArchivist().saveInClassLoadableFormat((AbstractArchive)object3);
            deploymentContext = new DeploymentContext((AbstractArchive)object3, application);
            deploymentContext.setSession(deploymentSession);
            application.getApplicationArchivist().setClassLoader(jarClassLoader);
            object2 = application.getEjbBundleDescriptors().iterator();
            while (object2.hasNext()) {
                serializable = (EjbBundleDescriptor)object2.next();
                EjbBundleArchivist ejbBundleArchivist = (EjbBundleArchivist)serializable.getArchivist();
                ejbBundleArchivist.setClassLoader(jarClassLoader);
            }
            this.setEjbJarIds(application);
        }
        catch (SAXParseException sAXParseException) {
            Log.err.println(sAXParseException);
            deploymentSession.setException(new Exception(sAXParseException.getMessage()));
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.error.xmlvalidationfailed", "Error while validating XML deployment descriptors : {0} ", new Object[]{sAXParseException.getMessage()}));
        }
        catch (Throwable throwable) {
            Log.err.println(throwable);
            deploymentSession.setException(new Exception(throwable.getMessage()));
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.error.saving/opening.jar", "Error saving/opening JAR ", new Object[]{throwable.getMessage()}));
        }
        boolean bl2 = false;
        object3 = null;
        if (this.isInstalled(string)) {
            bl2 = true;
            object2 = JarRepository.getServerJarFilename(string);
            object3 = new File((String)object2);
            this.undeployApplication(string, bl2);
        }
        int n2 = application.getEjbDescriptors().size();
        n = application.getWebBundleDescriptors().size();
        this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.application.ejb/webcount", "{0} has {1}  ejbs, {2} web components to deploy", new Object[]{application.getName(), new Integer(n2), new Integer(n)}), deploymentSession);
        object2 = file;
        serializable = file;
        object2 = this.applicationRegistry.newEjbServerJarFile(application.getName());
        serializable = this.applicationRegistry.newEjbClientJarFile(application.getName());
        string2 = this.deployEjbs(deploymentContext, (File)object2, (File)serializable, (File)object3);
        if (object3 != null && !(bl = ((File)object3).delete())) {
            Log.err.println("Couldn't delete old app jar : " + object3);
        }
        if (application.getRarComponentCount() > 0) {
            ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
            object = application.getRarDescriptors().iterator();
            while (object.hasNext()) {
                ConnectorDescriptor connectorDescriptor = (ConnectorDescriptor)object.next();
                String string3 = connectorDescriptor.getArchivist().getArchiveUri();
                resourceInstaller.registerConnectorDescriptor(connectorDescriptor, string, string3);
            }
        }
        if (cleanTmpDir && file2 != null) {
            final String string4 = file2.getAbsolutePath();
            object = new Thread(new Runnable(){

                public void run() {
                    DeploymentContext.deleteDirectory(new File(string4));
                }
            });
            ((Thread)object).start();
        }
        if (!deploymentSession.isCancelled()) {
            JarRepository.writeToPropsFile(application.getName(), application.getApplicationArchivist().getApplicationFile(), (File)object2, (File)serializable);
            System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.application.deployed", "Application {0} deployed.\n", new Object[]{string}));
            this.changed();
            this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.deployment.complete", " Deployment of {0} is complete.", new Object[]{application.getName()}), deploymentSession);
            this.progressEvent("Done Deploying", deploymentSession);
            return string2;
        }
        return null;
    }

    private void setEjbJarIds(Application application) {
        JarManagerImpl jarManagerImpl = Switch.getSwitch().getEJBJarManager();
        Application application2 = jarManagerImpl.getApplication(application.getName());
        if (application2 == null) {
            Iterator iterator = application.getEjbBundleDescriptors().iterator();
            while (iterator.hasNext()) {
                EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
                int n = this.getUniqueId();
                ejbBundleDescriptor.setUniqueId(n);
                ejbJarCache.put(new Long(n), ejbBundleDescriptor);
            }
        } else {
            Iterator iterator = application.getEjbBundleDescriptors().iterator();
            while (iterator.hasNext()) {
                EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
                EjbBundleDescriptor ejbBundleDescriptor2 = null;
                try {
                    ejbBundleDescriptor2 = application2.getEjbBundleByUri(ejbBundleDescriptor.getArchivist().getArchiveUri());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                long l = ejbBundleDescriptor2 != null ? ejbBundleDescriptor2.getUniqueId() : (long)this.getUniqueId();
                ejbBundleDescriptor.setUniqueId(l);
                ejbJarCache.put(new Long(l), ejbBundleDescriptor);
            }
        }
    }

    public static EjbBundleDescriptor getEjbJarForId(int n) {
        return (EjbBundleDescriptor)ejbJarCache.get(new Long(n));
    }

    private synchronized int getUniqueId() {
        return ++uniqueId;
    }

    private boolean isInstalled(String string) {
        boolean bl = false;
        try {
            bl = this.getApplicationNames().contains(string);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return bl;
    }

    public Vector getApplicationNames() throws RemoteException {
        return JarRepository.getApplicationList();
    }

    public Application getApplicationForName(String string) throws RemoteException {
        Application application = null;
        try {
            application = JarRepository.getApplicationForName(string);
        }
        catch (Throwable throwable) {
            System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.errorreturning.application", " Error returning {0}", new Object[]{string}));
            System.out.println(throwable);
        }
        return application;
    }

    public void undeployApplication(String string) throws RemoteException {
        this.undeployApplication(string, false);
    }

    private void undeployApplication(String string, boolean bl) throws RemoteException {
        if (AppVerification.doInstrument()) {
            AppVerification.getInstrumentLogger().handleChangeInDeployment();
        }
        int n = -1;
        try {
            Object object;
            Iterator iterator;
            Object object2;
            this.cleanupNameSpace(string);
            String string2 = JarRepository.getServerJarFilename(string);
            Application application = null;
            JarManagerImpl jarManagerImpl = Switch.getSwitch().getEJBJarManager();
            application = jarManagerImpl.getApplication(string);
            jarManagerImpl.undeploy(string);
            if (application.getRarComponentCount() > 0) {
                object2 = Switch.getSwitch().getResourceInstaller();
                iterator = application.getRarDescriptors().iterator();
                while (iterator.hasNext()) {
                    object = (ConnectorDescriptor)iterator.next();
                    String string3 = ((BundleDescriptor)object).getArchivist().getArchiveUri();
                    ((ResourceInstaller)object2).forceResourcePoolCleanup(string, string3);
                    ((ResourceInstaller)object2).unregisterConnectorDescriptor(string, string3);
                }
            }
            JarRepository.getApplicationJarFilenamesFor(string);
            object2 = JarRepository.getServerJarFilename(string);
            iterator = JarRepository.getApplicationJarFilenamesFor(string).elements();
            while (iterator.hasMoreElements()) {
                object = (String)iterator.nextElement();
                if (bl && ((String)object).equals(object2)) continue;
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.delete.nextserverjar", " delete {0}", new Object[]{object}));
                boolean bl2 = new File((String)object).delete();
                if (bl2) continue;
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.errorjarnotdeleted", " Warning: {0} could not be deleted", new Object[]{object}));
            }
            JarRepository.removeFromPropsFile(string);
            if (!bl) {
                iterator = application.getEjbBundleDescriptors().iterator();
                while (iterator.hasNext()) {
                    object = (EjbBundleDescriptor)iterator.next();
                    long l = ((EjbBundleDescriptor)object).getUniqueId();
                    ejbJarCache.remove(new Long(l));
                }
            }
            Switch.getSwitch().getPoolManager().resizeAllPools(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionapplicationnotundeployed.reasonnotknown", " Application {0} could not be undeployed - reason unknown", new Object[]{string}));
        }
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.applicationundeployed", " Application {0} has been undeployed", new Object[]{string}));
        this.changed();
    }

    private void removeDirectory(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    this.removeDirectory(file2);
                }
                file2.delete();
            }
        }
        file.delete();
    }

    public void deployConnector(byte[] byArray, String string) throws RemoteException, PoolingException {
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        resourceInstaller.installResourceAdapter(byArray, string);
    }

    public Set getConnectionFactoryPropertyTemplate(String string, String string2) throws RemoteException, PoolingException {
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        ConnectorDescriptor connectorDescriptor = resourceInstaller.getDescriptorByConnectorName(string, string2);
        if (connectorDescriptor == null) {
            throw new NameNotFoundException(string + ":" + string2);
        }
        Set set = connectorDescriptor.getConfigProperties();
        return set;
    }

    public void addConnectionFactory(String string, String string2, String string3, String string4, String string5, Properties properties) throws RemoteException, PoolingException {
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        resourceInstaller.addConnectionFactory(string, string2, string3, string4, string5, properties);
    }

    public void removeConnectionFactory(String string) throws RemoteException, PoolingException {
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        resourceInstaller.removeConnectionFactory(string);
    }

    public void undeployConnector(String string) throws RemoteException, PoolingException {
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        resourceInstaller.uninstallResourceAdapter(string);
    }

    public ConnectorInfo listConnectors() throws RemoteException, PoolingException {
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        return resourceInstaller.listResourceAdapters();
    }

    public Set listConnectorResources() throws RemoteException {
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        return resourceInstaller.listConnectorResources();
    }

    public void createDestination(JmsDestinationResource jmsDestinationResource) throws RemoteException, JMSException {
        try {
            IASJmsConfig iASJmsConfig = this.getJmsConfig();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Iterator iterator = jmsDestinationResource.getProperties().iterator();
            while (iterator.hasNext()) {
                ResourceProperty resourceProperty = (ResourceProperty)iterator.next();
                hashMap.put(resourceProperty.getName(), resourceProperty.getValue());
            }
            iASJmsConfig.createDestination(jmsDestinationResource.getName(), jmsDestinationResource.getIsQueue(), hashMap);
        }
        catch (Exception exception) {
            Log.err.println(exception);
            throw new JMSException(exception.getMessage());
        }
    }

    public void deleteDestination(JmsDestinationResource jmsDestinationResource) throws RemoteException, JMSException {
        try {
            IASJmsConfig iASJmsConfig = this.getJmsConfig();
            iASJmsConfig.deleteDestination(jmsDestinationResource.getName());
        }
        catch (Exception exception) {
            Log.err.println(exception);
            throw new JMSException(exception.getMessage());
        }
    }

    public void createJmsConnectionFactory(JmsCnxFactoryResource jmsCnxFactoryResource) throws RemoteException, JMSException {
        try {
            IASJmsConfig iASJmsConfig = this.getJmsConfig();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Iterator iterator = jmsCnxFactoryResource.getProperties().iterator();
            while (iterator.hasNext()) {
                ResourceProperty resourceProperty = (ResourceProperty)iterator.next();
                hashMap.put(resourceProperty.getName(), resourceProperty.getValue());
            }
            iASJmsConfig.createConnectionFactory(jmsCnxFactoryResource.getName(), jmsCnxFactoryResource.getIsQueue(), hashMap);
        }
        catch (Exception exception) {
            Log.err.println(exception);
            throw new JMSException(exception.getMessage());
        }
    }

    public void deleteJmsConnectionFactory(JmsCnxFactoryResource jmsCnxFactoryResource) throws RemoteException, JMSException {
        try {
            IASJmsConfig iASJmsConfig = this.getJmsConfig();
            iASJmsConfig.deleteConnectionFactory(jmsCnxFactoryResource.getName());
        }
        catch (Exception exception) {
            Log.err.println(exception);
            throw new JMSException(exception.getMessage());
        }
    }

    private String deployEjbs(DeploymentContext deploymentContext, File file, File file2, File file3) throws RemoteException {
        String string = "";
        int n = -1;
        Application application = deploymentContext.getApplication();
        DeploymentSession deploymentSession = deploymentContext.getSession();
        String string2 = CODEBASE_PREFIX + port + "/" + URLEncoder.encode(application.getName()) + "Client.jar";
        this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.deployingEjbs", "Deploying Ejbs..."), deploymentSession);
        try {
            string = GeneratorDriver.preDeploy(deploymentContext, file, file2, file3);
            if (deploymentSession.isCancelled()) {
                return null;
            }
        }
        catch (Exception exception) {
            Log.err.println(exception);
            deploymentSession.setException(exception);
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionprocessingejbjar", " Error processing ejb jar: {0} ", new Object[]{exception.getMessage()}));
        }
        JarManagerImpl jarManagerImpl = Switch.getSwitch().getEJBJarManager();
        jarManagerImpl.loadJar(file.toString());
        return string2;
    }

    private void saveAsBytes(byte[] byArray, File file) throws IOException {
        if (byArray == null) {
            throw new IOException(localStrings.getLocalString("enterprise.tools.deployment.backend.nulldata", "null data"));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray, 0, byArray.length);
        fileOutputStream.close();
    }

    private byte[] getFileAsBytes(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }

    private void progress(String string, DeploymentSession deploymentSession) {
        if (deploymentSession != null) {
            try {
                deploymentSession.setStatusMessage(string);
            }
            catch (Throwable throwable) {
                Log.err.println(throwable);
            }
        }
    }

    private void progressEvent(String string, DeploymentSession deploymentSession) {
        if (deploymentSession != null) {
            try {
                deploymentSession.notification(new NotificationEvent("", string, ""));
            }
            catch (Throwable throwable) {
                Log.err.println(throwable);
            }
        }
    }

    public void addRemoteNotificationListener(RemoteNotificationListener remoteNotificationListener) throws RemoteException {
        this.listeners.addElement(remoteNotificationListener);
    }

    public void removeRemoteNotificationListener(RemoteNotificationListener remoteNotificationListener) throws RemoteException {
        this.listeners.removeElement(remoteNotificationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed() throws RemoteException {
        Vector vector = null;
        Object object = this.listeners;
        synchronized (object) {
            vector = (Vector)this.listeners.clone();
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            final RemoteNotificationListener remoteNotificationListener = (RemoteNotificationListener)object.nextElement();
            final NotificationEvent notificationEvent = new NotificationEvent("", SERVER_CHANGED, SERVER_CHANGED, "");
            Thread thread = new Thread(){

                public void run() {
                    try {
                        remoteNotificationListener.notification(notificationEvent);
                    }
                    catch (Throwable throwable) {
                        JarInstallerImpl.this.listeners.removeElement(remoteNotificationListener);
                    }
                }
            };
            thread.start();
        }
    }

    private void cleanupNameSpace(String string) {
        try {
            Object object;
            Object object2;
            NamingManager namingManager = Switch.getSwitch().getNamingManager();
            JarManagerImpl jarManagerImpl = Switch.getSwitch().getEJBJarManager();
            Application application = jarManagerImpl.getApplication(string);
            if (application == null) {
                application = JarRepository.getApplicationForName(string);
            }
            if (application == null) {
                throw new RuntimeException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptioncouldnotopenapplication", "Couldn't open :  {0} ", new Object[]{string}));
            }
            Vector vector = application.getEjbDescriptors();
            for (int i = 0; i < vector.size(); ++i) {
                object2 = (EjbDescriptor)vector.elementAt(i);
                object = ((EjbAbstractDescriptor)object2).getJndiName();
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.unbindingJNDIname", "Unbinding JNDI name: {0} ", new Object[]{object}));
                if (!((EjbDescriptor)object2).getType().equals("Message-driven") && ((EjbAbstractDescriptor)object2).isRemoteInterfacesSupported()) {
                    namingManager.unpublishObject((String)object);
                }
                namingManager.unbindObjects((JndiNameEnvironment)object2);
            }
            Set set = application.getWebBundleDescriptors();
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (WebBundleDescriptor)object2.next();
                namingManager.unbindObjects((JndiNameEnvironment)object);
            }
        }
        catch (Exception exception) {
            Log.err.println(exception);
        }
    }

    private IASJmsConfig getJmsConfig() throws Exception {
        if (this.jmsConfig_ == null) {
            this.jmsConfig_ = new IASJmsConfig(1);
        }
        return this.jmsConfig_;
    }
}

