/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.security.auth.realm.AuthenticationHandler;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class Realm
implements Comparable {
    private static Logger _logger;
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings;
    private static Hashtable loadedRealms;
    private String myName;
    private static final String JAAS_CONTEXT_PARAM = "jaas-context";
    private static String defaultRealmName;
    private static final String RI_DEFAULT = "default";
    private Properties ctxProps = new Properties();
    static final /* synthetic */ boolean $assertionsDisabled;

    public final String getName() {
        return this.myName;
    }

    protected final void setName(String string) {
        if (this.myName != null) {
            return;
        }
        this.myName = string;
    }

    public String toString() {
        return this.myName;
    }

    public int compareTo(Object object) {
        if (!(object instanceof Realm)) {
            return 1;
        }
        Realm realm = (Realm)object;
        String string = realm.getAuthType();
        int n = this.getAuthType().compareTo(string);
        if (n != 0) {
            return n;
        }
        string = realm.getName();
        return this.getName().compareTo(string);
    }

    public static Realm instantiate(String string, String string2, Properties properties) throws BadRealmException {
        return Realm.doInstantiate(string, string2, properties);
    }

    public static Realm instantiate(String string, File file) throws NoSuchRealmException, BadRealmException, FileNotFoundException {
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException();
        }
        if (Realm.getInstance(string) != null) {
            throw new BadRealmException(localStrings.getLocalString("realm.already_exists", "This Realm already exists."));
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        Properties properties = new Properties();
        try {
            properties.load(fileInputStream);
            String string2 = properties.getProperty("classname");
            if (!$assertionsDisabled && string2 == null) {
                throw new AssertionError();
            }
            return Realm.doInstantiate(string, string2, properties);
        }
        catch (IOException iOException) {
            throw new BadRealmException(iOException.toString());
        }
    }

    private static Realm doInstantiate(String string, String string2, Properties properties) throws BadRealmException {
        try {
            Class<?> clazz = Class.forName(string2);
            Object obj = clazz.newInstance();
            Realm realm = (Realm)obj;
            realm.setName(string);
            realm.init(properties);
            loadedRealms.put(string, realm);
            return realm;
        }
        catch (Exception exception) {
            throw new BadRealmException(exception.toString());
        }
    }

    protected static void updateInstance(Realm realm, String string) {
        Realm realm2 = (Realm)loadedRealms.get(string);
        if (!realm2.getClass().equals(realm.getClass())) {
            throw new Error("Incompatible class " + realm.getClass() + " in replacement realm " + string);
        }
        realm.ctxProps = realm2.ctxProps;
        loadedRealms.put(string, realm);
    }

    public static Realm getDefaultInstance() {
        return Realm.getInstance(defaultRealmName);
    }

    public static String getDefaultRealm() {
        return defaultRealmName;
    }

    public static void setDefaultRealm(String string) {
        defaultRealmName = string;
    }

    public void setProperty(String string, String string2) {
        this.ctxProps.setProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.ctxProps.getProperty(string);
    }

    public String getJAASContext() {
        return this.ctxProps.getProperty(JAAS_CONTEXT_PARAM);
    }

    public static Realm getInstance(String string) {
        Realm realm = null;
        realm = (Realm)loadedRealms.get(string);
        if (realm == null && RI_DEFAULT.equals(string)) {
            realm = (Realm)loadedRealms.get(defaultRealmName);
        }
        return realm;
    }

    public static Enumeration getRealmNames() {
        return loadedRealms.keys();
    }

    protected Realm() {
    }

    protected void init(Properties properties) throws BadRealmException, NoSuchRealmException {
    }

    public abstract String getAuthType();

    public abstract AuthenticationHandler getAuthenticationHandler();

    public abstract Enumeration getUserNames() throws BadRealmException;

    public abstract User getUser(String var1) throws NoSuchUserException, BadRealmException;

    public abstract Enumeration getGroupNames() throws BadRealmException;

    public abstract Enumeration getGroupNames(String var1) throws InvalidOperationException, NoSuchUserException;

    public abstract void refresh() throws BadRealmException;

    static {
        $assertionsDisabled = !Realm.class.desiredAssertionStatus();
        _logger = null;
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        localStrings = new LocalStringManagerImpl(Realm.class);
        loadedRealms = new Hashtable();
        defaultRealmName = RI_DEFAULT;
    }
}

