/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.login.X509CertificateCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class ClientCertificateLoginModule
implements LoginModule {
    private static Logger _logger = null;
    private static LocalStringManagerImpl localStrings;
    private static KeyStore ks;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String alias;
    private X509Certificate certificate;
    private PrincipalImpl userPrincipal;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
        this.init();
    }

    private void init() {
        try {
            if (ks == null) {
                SSLUtils.initKeyStore();
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "java_security.initkeystore_exception", exception);
        }
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        try {
            String[] stringArray = new String[ks.size()];
            String[] stringArray2 = new String[ks.size()];
            Enumeration<String> enumeration = ks.aliases();
            for (int i = 0; i < ks.size(); ++i) {
                stringArray2[i] = enumeration.nextElement();
                stringArray[i] = ((X509Certificate)ks.getCertificate(stringArray2[i])).getSubjectDN().getName();
            }
            Callback[] callbackArray = new Callback[]{new ChoiceCallback(localStrings.getLocalString("login.certificate", "Choose from list of certificates: "), stringArray, 0, false)};
            this.callbackHandler.handle(callbackArray);
            String[] stringArray3 = ((ChoiceCallback)callbackArray[0]).getChoices();
            int[] nArray = ((ChoiceCallback)callbackArray[0]).getSelectedIndexes();
            if (stringArray3 == null) {
                // empty if block
            }
            if (nArray == null) {
                throw new LoginException("No certificate selected!");
            }
            if (nArray[0] == -1) {
                throw new LoginException("Incorrect keystore password");
            }
            if (this.debug) {
                _logger.log(Level.FINE, "\t\t[ClientCertificateLoginModule] user entered certificate: ");
                for (int i = 0; i < nArray.length; ++i) {
                    _logger.log(Level.FINE, stringArray2[nArray[i]]);
                }
            }
            this.alias = stringArray2[nArray[0]];
            this.certificate = (X509Certificate)ks.getCertificate(this.alias);
            if (this.debug) {
                _logger.log(Level.FINE, "\t\t[ClientCertificateLoginModule] authentication succeeded");
            }
            this.succeeded = true;
            return true;
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        catch (Exception exception) {
            throw new LoginException(exception.toString());
        }
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new PrincipalImpl(this.alias);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (this.debug) {
            _logger.log(Level.FINE, "\t\t[ClientCertificateLoginModule] added PrincipalImpl to Subject");
        }
        System.setProperty("com.sun.enterprise.selectCert", "true");
        System.setProperty("com.sun.enterprise.certAlias", this.alias);
        String string = LoginContextDriver.CERT_REALMNAME;
        X509Certificate[] x509CertificateArray = new X509Certificate[]{this.certificate};
        X509CertificateCredential x509CertificateCredential = new X509CertificateCredential(x509CertificateArray, this.alias, string);
        if (!this.subject.getPrivateCredentials().contains(x509CertificateCredential)) {
            this.subject.getPrivateCredentials().add(x509CertificateCredential);
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.alias = null;
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        System.setProperty("com.sun.enterprise.selectCert", "false");
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.alias = null;
        this.userPrincipal = null;
        return true;
    }

    public static void setKeyStore(KeyStore keyStore) {
        ks = keyStore;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        localStrings = new LocalStringManagerImpl(ClientCertificateLoginModule.class);
        ks = null;
    }
}

