/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.serverbeans.SecurityService;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.server.ApplicationServer;
import com.sun.enterprise.Switch;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.acl.Group;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.auth.AuthenticationInfo;
import com.sun.enterprise.security.auth.Credentials;
import com.sun.enterprise.security.auth.Privilege;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RoleMapper
implements Serializable {
    private static boolean debug;
    private static Hashtable roleMaps;
    private static final String DEFAULT_ROLE_NAME = "ANYONE";
    private static Role defaultRole;
    private static String defaultRoleName;
    private Hashtable prinTable = new Hashtable();
    private Hashtable roleTable = new Hashtable();
    private String appName;
    private static Logger _logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    private RoleMapper(String string) {
        this.appName = string;
        Switch switch_ = Switch.getSwitch();
        if (switch_.getContainerType() == 2) {
            RoleMapper.initDefaultRole();
        }
    }

    private static synchronized void initDefaultRole() {
        if (defaultRole == null) {
            defaultRoleName = DEFAULT_ROLE_NAME;
            try {
                ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
                if (!$assertionsDisabled && configContext == null) {
                    throw new AssertionError();
                }
                Server server = ServerBeansFactory.getServerBean(configContext);
                if (!$assertionsDisabled && server == null) {
                    throw new AssertionError();
                }
                SecurityService securityService = server.getSecurityService();
                if (!$assertionsDisabled && securityService == null) {
                    throw new AssertionError();
                }
                defaultRoleName = securityService.getAnonymousRole();
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "java_security.anonymous_role_reading_exception", exception);
            }
            _logger.log(Level.FINE, "Default role is: " + defaultRoleName);
            defaultRole = new Role(defaultRoleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoleMapper getRoleMapper(String string) {
        if (!roleMaps.containsKey(string)) {
            Class clazz = RoleMapper.class;
            synchronized (clazz) {
                roleMaps.put(string, new RoleMapper(string));
            }
        }
        return (RoleMapper)roleMaps.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRoleMapper(String string, RoleMapper roleMapper) {
        if (!roleMaps.containsKey(string)) {
            Class clazz = RoleMapper.class;
            synchronized (clazz) {
                roleMaps.put(string, roleMapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRoleMapper(String string) {
        if (roleMaps.containsKey(string)) {
            Class clazz = RoleMapper.class;
            synchronized (clazz) {
                roleMaps.remove(string);
            }
        }
    }

    public String getName() {
        return this.appName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        if (roleMaps.containsKey(this.appName)) {
            Class clazz = RoleMapper.class;
            synchronized (clazz) {
                roleMaps.remove(this.appName);
                this.appName = string;
                roleMaps.remove(string);
                roleMaps.put(this.appName, this);
            }
        }
    }

    public static Role getDefaultRole() {
        if (defaultRole == null) {
            RoleMapper.initDefaultRole();
        }
        return defaultRole;
    }

    public void assignRole(Principal principal, Role role) {
        this.createMapping(this.prinTable, principal, role);
        this.createMapping(this.roleTable, role, principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMapping(Hashtable hashtable, Principal principal, Principal principal2) {
        Cloneable cloneable;
        if (!hashtable.containsKey(principal)) {
            cloneable = hashtable;
            synchronized (cloneable) {
                hashtable.put(principal, new HashSet());
            }
        }
        Cloneable cloneable2 = cloneable = (HashSet)hashtable.get(principal);
        synchronized (cloneable2) {
            ((HashSet)cloneable).add(principal2);
        }
    }

    private void removeKey(Hashtable hashtable, Principal principal) {
        hashtable.remove(principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeValue(Hashtable hashtable, Principal principal) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            HashSet hashSet;
            HashSet hashSet2 = hashSet = (HashSet)enumeration.nextElement();
            synchronized (hashSet2) {
                hashSet.remove(principal);
            }
        }
    }

    private void removeValueFromSetWithKey(Hashtable hashtable, Object object, Object object2) {
        Set set = (Set)hashtable.get(object);
        if (set != null) {
            set.remove(object2);
            if (set.isEmpty()) {
                hashtable.remove(object);
            }
        }
    }

    public void unassignRole(Role role) {
        this.removeKey(this.roleTable, role);
        this.removeValue(this.prinTable, role);
    }

    public void unassignAllRoles() {
        this.roleTable.clear();
        this.prinTable.clear();
    }

    public void unassignPrincipalFromRole(Role role, Principal principal) {
        this.removeValueFromSetWithKey(this.prinTable, principal, role);
        this.removeValueFromSetWithKey(this.roleTable, role, principal);
    }

    private void unassignPrincipalFromRole(Hashtable hashtable, Role role, Principal principal) {
    }

    private Iterator getRoles(Principal principal) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, this.toString());
            _logger.log(Level.FINEST, "In roleMapper.getRoles(" + principal + ")");
        }
        HashSet hashSet = (HashSet)this.prinTable.get(principal);
        if (debug) {
            _logger.log(Level.FINEST, "Set of roles = " + hashSet);
        }
        if (hashSet != null) {
            return hashSet.iterator();
        }
        return null;
    }

    public boolean hasRole(Principal principal, String string) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "PRINCIPAL : " + principal + " hasRole?: " + string);
            _logger.log(Level.FINEST, "PRINCIPAL TABLE: " + this.prinTable);
        }
        if (string != null && string.equals(defaultRoleName)) {
            return true;
        }
        HashSet hashSet = (HashSet)this.prinTable.get(principal);
        if (debug) {
            _logger.log(Level.FINEST, "For principal: " + principal + ", set of roles= " + hashSet);
        }
        Role role = new Role(string);
        if (hashSet != null && hashSet.contains(role)) {
            return true;
        }
        return this.arePrincipalsGroupsInRole(principal.getName(), role);
    }

    private Enumeration getGroupsForPrincipal(String string) {
        try {
            Realm realm = Realm.getInstance(Realm.getDefaultRealm());
            Enumeration enumeration = realm.getGroupNames(string);
            return enumeration;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "java_security.retrieving_group_membership_exception", new Object[]{string, exception.toString()});
            Vector vector = new Vector();
            return vector.elements();
        }
    }

    private boolean arePrincipalsGroupsInRole(String string, Role role) {
        Enumeration enumeration = this.getGroupsForPrincipal(string);
        HashSet hashSet = (HashSet)this.roleTable.get(role);
        if (hashSet == null) {
            return false;
        }
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            PrincipalImpl principalImpl = new PrincipalImpl(string2);
            if (!hashSet.contains(principalImpl)) continue;
            return true;
        }
        return false;
    }

    public Enumeration getRoles() {
        return this.roleTable.keys();
    }

    public Enumeration getGroupsAssignedTo(Role role) {
        Vector vector = new Vector();
        HashSet hashSet = (HashSet)this.roleTable.get(role);
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Group)) continue;
                vector.add(e);
            }
        }
        return vector.elements();
    }

    public Enumeration getUsersAssignedTo(Role role) {
        Vector vector = new Vector();
        HashSet hashSet = (HashSet)this.roleTable.get(role);
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Group) continue;
                vector.add(e);
            }
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector computeCurrentRoles() {
        StringBuffer stringBuffer;
        if (debug) {
            _logger.log(Level.FINE, "Within roleMapper.getCurrentRoles()");
        }
        Vector<Role> vector = new Vector<Role>();
        SecurityContext securityContext = SecurityContext.getCurrent();
        if (debug) {
            _logger.log(Level.FINE, "roleMapper.SecurityContext=" + securityContext);
        }
        if (RoleMapper.getDefaultRole() != null) {
            if (debug) {
                _logger.log(Level.FINE, "roleMapper.adding the default role=" + RoleMapper.getDefaultRole());
            }
            vector.add(RoleMapper.getDefaultRole());
        }
        if (securityContext == null) {
            return vector;
        }
        try {
            try {
                Credentials credentials = securityContext.getCredentials();
                if (debug) {
                    _logger.log(Level.FINE, "roleMapper.credential = " + credentials);
                }
                if (debug) {
                    // empty if block
                }
                AuthenticationInfo[] authenticationInfoArray = credentials.getAuthenticationInfo();
                if (debug) {
                    _logger.log(Level.FINE, "AuthInfoList = " + authenticationInfoArray.length);
                }
                for (int i = 0; i < authenticationInfoArray.length; ++i) {
                    AuthenticationInfo authenticationInfo = authenticationInfoArray[i];
                    if (debug) {
                        _logger.log(Level.FINE, "AuthInfo = " + authenticationInfo);
                    }
                    if (!authenticationInfo.isAuthenticated()) continue;
                    PrincipalImpl principalImpl = new PrincipalImpl(authenticationInfo.getPrincipalName());
                    Iterator iterator = this.getRoles(principalImpl);
                    if (iterator != null) {
                        while (iterator.hasNext()) {
                            vector.add((Role)iterator.next());
                        }
                    }
                    Privilege[] privilegeArray = authenticationInfo.getAttribute("Groups");
                    for (int j = 0; j < privilegeArray.length; ++j) {
                        Group group = new Group(privilegeArray[j].getName());
                        iterator = this.getRoles(group);
                        if (iterator == null) continue;
                        while (iterator.hasNext()) {
                            vector.add((Role)iterator.next());
                        }
                    }
                }
                Object var13_13 = null;
                if (!_logger.isLoggable(Level.FINER)) return vector;
                stringBuffer = new StringBuffer();
                stringBuffer.append("Current principal has roles:");
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "java_security.credential_exception", exception);
                Object var13_14 = null;
                if (!_logger.isLoggable(Level.FINER)) return vector;
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("Current principal has roles:");
                int i = 0;
                while (true) {
                    if (i >= vector.size()) {
                        _logger.finer(stringBuffer2.toString());
                        return vector;
                    }
                    stringBuffer2.append(" ");
                    stringBuffer2.append(vector.get(i).toString());
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (!_logger.isLoggable(Level.FINER)) return vector;
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("Current principal has roles:");
            int i = 0;
            while (true) {
                if (i >= vector.size()) {
                    _logger.finer(stringBuffer2.toString());
                    return vector;
                }
                stringBuffer2.append(" ");
                stringBuffer2.append(vector.get(i).toString());
                ++i;
            }
        }
        int i = 0;
        while (true) {
            if (i >= vector.size()) {
                _logger.finer(stringBuffer.toString());
                return vector;
            }
            stringBuffer.append(" ");
            stringBuffer.append(vector.get(i).toString());
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getCurrentRoles() {
        SecurityContext securityContext = SecurityContext.getCurrent();
        Vector vector = securityContext.getUserRolesByApp(this.appName);
        if (vector == null) {
            SecurityContext securityContext2 = securityContext;
            synchronized (securityContext2) {
                vector = this.computeCurrentRoles();
                securityContext.setUserRolesByApp(this.appName, vector);
            }
        }
        return vector.elements();
    }

    public String toString() {
        String string = "RoleMapper";
        Enumeration enumeration = this.getRoles();
        while (enumeration.hasMoreElements()) {
            Role role = (Role)enumeration.nextElement();
            Enumeration enumeration2 = null;
            string = string + " : " + role + "(";
            enumeration2 = this.getGroupsAssignedTo(role);
            while (enumeration2.hasMoreElements()) {
                string = string + enumeration2.nextElement();
                if (!enumeration2.hasMoreElements()) continue;
                string = string + ",";
            }
            string = string + ")(";
            enumeration2 = this.getUsersAssignedTo(role);
            while (enumeration2.hasMoreElements()) {
                string = string + enumeration2.nextElement();
                if (!enumeration2.hasMoreElements()) continue;
                string = string + ",";
            }
            string = string + ")";
        }
        return string;
    }

    static {
        $assertionsDisabled = !RoleMapper.class.desiredAssertionStatus();
        debug = false;
        roleMaps = new Hashtable();
        defaultRole = null;
        defaultRoleName = null;
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    }
}

