/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.LoginDialog;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public final class TextLoginDialog
implements LoginDialog {
    private static Logger _logger = null;
    private String username = null;
    private String password = null;
    private static LocalStringManagerImpl localStrings;

    public TextLoginDialog() {
        if (this.username == null || this.password == null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            do {
                System.out.print(localStrings.getLocalString("enterprise.security.login.username", "User Name: "));
                try {
                    this.username = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            } while (this.username == null || this.username.trim().length() == 0);
            do {
                System.out.print(localStrings.getLocalString("enterprise.security.login.password", "Password: "));
                try {
                    this.password = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            } while (this.password == null || this.password.trim().length() == 0);
        }
    }

    public TextLoginDialog(Callback[] callbackArray) {
        try {
            for (int i = 0; i < callbackArray.length; ++i) {
                String string;
                Object object;
                String string2;
                Callback callback;
                if (callbackArray[i] instanceof NameCallback) {
                    callback = (NameCallback)callbackArray[i];
                    System.err.print(((NameCallback)callback).getPrompt());
                    System.err.flush();
                    ((NameCallback)callback).setName(new BufferedReader(new InputStreamReader(System.in)).readLine());
                    continue;
                }
                if (callbackArray[i] instanceof PasswordCallback) {
                    callback = (PasswordCallback)callbackArray[i];
                    System.err.print(((PasswordCallback)callback).getPrompt());
                    System.err.flush();
                    string2 = new BufferedReader(new InputStreamReader(System.in)).readLine();
                    ((PasswordCallback)callback).setPassword(string2.toCharArray());
                    continue;
                }
                if (!(callbackArray[i] instanceof ChoiceCallback)) continue;
                callback = (ChoiceCallback)callbackArray[i];
                string2 = localStrings.getLocalString("enterprise.security.keystore", "Enter the KeyStore Password ");
                String string3 = SSLUtils.getKeyStorePass();
                System.out.println(string2 + " : (max 3 tries)");
                int n = 0;
                for (n = 0; n < 3; ++n) {
                    System.out.println(string2 + " : ");
                    object = new BufferedReader(new InputStreamReader(System.in)).readLine();
                    if (((String)object).equals(string3)) break;
                    string = localStrings.getLocalString("enterprise.security.IncorrectKeystorePassword", "Incorrect Keystore Password");
                    System.err.println(string);
                }
                if (n >= 3) {
                    ((ChoiceCallback)callback).setSelectedIndex(-1);
                    continue;
                }
                System.err.println(((ChoiceCallback)callback).getPrompt());
                System.err.flush();
                object = ((ChoiceCallback)callback).getChoices();
                for (int j = 0; j < ((String[])object).length; ++j) {
                    System.err.print("[" + j + "] ");
                    System.err.println((String)object[j]);
                }
                string = new BufferedReader(new InputStreamReader(System.in)).readLine();
                int n2 = new Integer(string);
                ((ChoiceCallback)callback).setSelectedIndex(n2);
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "java_security.name_password_entry_exception", exception);
        }
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        localStrings = new LocalStringManagerImpl(TextLoginDialog.class);
    }
}

