/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.serverbeans.SecurityService;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.server.ApplicationServer;
import com.sun.enterprise.security.AbstractSecurityContext;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.auth.Credentials;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.logging.LogDomains;
import java.security.Principal;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class SecurityContext
extends AbstractSecurityContext {
    private static Logger _logger;
    private HashMap roleTable;
    private static InheritableThreadLocal currentSecCtx;
    private static SecurityContext defaultSecurityContext;
    private boolean SERVER_GENERATED_SECURITY_CONTEXT = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SecurityContext(String string, Credentials credentials, Subject subject) {
        this.initiator = new PrincipalImpl(string);
        this.credentials = credentials;
        this.subject = subject;
        this.roleTable = new HashMap();
    }

    public static SecurityContext init() {
        SecurityContext securityContext = SecurityContext.getCurrent();
        if (securityContext == null) {
            if (defaultSecurityContext == null) {
                SecurityContext.generateDefaultSecurityContext();
            }
            SecurityContext.setCurrent(defaultSecurityContext);
            return defaultSecurityContext;
        }
        return securityContext;
    }

    public static void setUnauthenticatedContext() {
        if (defaultSecurityContext == null) {
            SecurityContext.generateDefaultSecurityContext();
        }
        SecurityContext.setCurrent(defaultSecurityContext);
    }

    private static void generateDefaultSecurityContext() {
        String string = null;
        try {
            ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
            if (!$assertionsDisabled && configContext == null) {
                throw new AssertionError();
            }
            Server server = ServerBeansFactory.getServerBean(configContext);
            if (!$assertionsDisabled && server == null) {
                throw new AssertionError();
            }
            SecurityService securityService = server.getSecurityService();
            if (!$assertionsDisabled && securityService == null) {
                throw new AssertionError();
            }
            string = securityService.getDefaultPrincipal();
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "java_security.principal_configuration_exception");
        }
        if (string == null) {
            string = "ANONYMOUS";
        }
        _logger.log(Level.FINE, "Default principal set to: " + string);
        try {
            LoginContextDriver.loginPrincipal(string);
            defaultSecurityContext = SecurityContext.getCurrent();
            defaultSecurityContext.setServerGeneratedCredentials();
            SecurityContext.setCurrent(null);
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "java_security.default_user_login_Exception", exception);
        }
    }

    public static void reset(SecurityContext securityContext) {
        SecurityContext.setCurrent(securityContext);
    }

    public static SecurityContext getCurrent() {
        return (SecurityContext)currentSecCtx.get();
    }

    public static void setCurrent(SecurityContext securityContext) {
        currentSecCtx.set(securityContext);
    }

    public boolean didServerGenerateCredentials() {
        return this.SERVER_GENERATED_SECURITY_CONTEXT;
    }

    private void setServerGeneratedCredentials() {
        this.SERVER_GENERATED_SECURITY_CONTEXT = true;
    }

    public Principal getCallerPrincipal() {
        return this.initiator;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Vector getUserRolesByApp(String string) {
        return (Vector)this.roleTable.get(string);
    }

    public void setUserRolesByApp(String string, Vector vector) {
        this.roleTable.put(string, vector);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("In security context, roles in application [" + string + "] for principal [" + this.initiator + "] are: " + vector);
        }
    }

    public String toString() {
        return "SecurityContext[ Initiator: " + this.initiator + " Credentials " + this.credentials + "Subject " + this.subject + " ]";
    }

    static {
        $assertionsDisabled = !SecurityContext.class.desiredAssertionStatus();
        _logger = null;
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        currentSecCtx = new InheritableThreadLocal();
        defaultSecurityContext = null;
    }
}

