/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.GUIErrorDialog;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

class PassphraseDialog
extends JDialog {
    private NameCallback nameCallback = null;
    private PasswordCallback passwordCallback = null;
    private ChoiceCallback choiceCallback = null;
    private JTextField userField;
    private JPasswordField passField;
    private JList choiceList;
    private JFrame frame;
    private JButton okButton;
    private JButton cancelButton;
    private JButton okForKP;
    private JButton cancelForKP;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PassphraseDialog.class);
    String username = new String();
    String passphrase = new String();
    private JPasswordField keystorePassword;
    private JLabel lbl;
    private String passKPFromUser;
    private String keystorePass;
    private JPanel pnl = new JPanel(new GridLayout(2, 0));
    private JPanel bpanel = new JPanel(new FlowLayout());
    private JPanel kpPanel = new JPanel(new FlowLayout());
    private final String pnlKeyStorePassword = "Keystore Password Box";
    private final String pnlCertificateList = "Cerificate Chooser";
    private JPanel pnl2 = new JPanel();

    protected PassphraseDialog(JFrame jFrame, String string) {
        super(jFrame, string, true);
        this.frame = jFrame;
        super.dialogInit();
        this.initbox();
    }

    protected PassphraseDialog(JFrame jFrame, String string, Callback[] callbackArray) {
        super(jFrame, string, true);
        this.frame = jFrame;
        super.dialogInit();
        for (int i = 0; i < callbackArray.length; ++i) {
            if (callbackArray[i] instanceof NameCallback) {
                this.nameCallback = (NameCallback)callbackArray[i];
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                this.passwordCallback = (PasswordCallback)callbackArray[i];
                continue;
            }
            if (!(callbackArray[i] instanceof ChoiceCallback)) continue;
            this.choiceCallback = (ChoiceCallback)callbackArray[i];
        }
        this.initbox();
    }

    private void initbox() {
        Object object;
        JComponent jComponent;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.pnl2.setLayout(gridBagLayout);
        this.getContentPane().setLayout(new CardLayout());
        int n = 0;
        int n2 = 0;
        this.passField = new JPasswordField(20);
        this.userField = new JTextField(20);
        this.choiceList = new JList();
        if (this.nameCallback != null) {
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(20, 10, 10, 2);
            jComponent = new JLabel(this.nameCallback.getPrompt());
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            this.pnl2.add(jComponent);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(20, 3, 10, 10);
            gridBagLayout.setConstraints(this.userField, gridBagConstraints);
            this.pnl2.add(this.userField);
        }
        if (this.passwordCallback != null) {
            n = 0;
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(20, 10, 10, 2);
            jComponent = new JLabel(this.passwordCallback.getPrompt());
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            this.pnl2.add(jComponent);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(20, 3, 10, 10);
            gridBagLayout.setConstraints(this.passField, gridBagConstraints);
            this.pnl2.add(this.passField);
        }
        if (this.choiceCallback != null) {
            this.lbl = new JLabel(localStrings.getLocalString("enterprise.security.keystore", "Enter the KeyStore Password "));
            this.keystorePassword = new JPasswordField(20);
            this.kpPanel.add(this.lbl);
            this.kpPanel.add(this.keystorePassword);
            this.keystorePass = SSLUtils.getKeyStorePass();
            this.okForKP = new JButton(localStrings.getLocalString("enterprise.security.ok", " OK "));
            this.okForKP.setActionCommand("ok");
            this.okForKP.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PassphraseDialog.this.passKPFromUser = new String(PassphraseDialog.this.keystorePassword.getPassword());
                    if (PassphraseDialog.this.keystorePass.equals(PassphraseDialog.this.passKPFromUser)) {
                        PassphraseDialog.this.okForKP.setEnabled(false);
                        PassphraseDialog.this.cancelForKP.setEnabled(false);
                        PassphraseDialog.this.keystorePassword.setEditable(false);
                        CardLayout cardLayout = (CardLayout)PassphraseDialog.this.getContentPane().getLayout();
                        cardLayout.show(PassphraseDialog.this.getContentPane(), "Cerificate Chooser");
                    } else {
                        String string = localStrings.getLocalString("enterprise.security.IncorrectKeystorePassword", "Incorrect Keystore Password");
                        GUIErrorDialog gUIErrorDialog = new GUIErrorDialog(string);
                        gUIErrorDialog.show();
                    }
                }
            });
            this.cancelForKP = new JButton(localStrings.getLocalString("enterprise.security.cancel", "Cancel"));
            this.cancelForKP.setActionCommand("cancel");
            this.cancelForKP.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (PassphraseDialog.this.choiceCallback != null) {
                        PassphraseDialog.this.choiceCallback.setSelectedIndex(-1);
                    }
                    PassphraseDialog.this.dispose();
                }
            });
            this.bpanel.add(this.okForKP);
            this.bpanel.add(this.cancelForKP);
            this.pnl.add(this.kpPanel);
            this.pnl.add(this.bpanel);
            n = 0;
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(20, 10, 10, 2);
            jComponent = new JLabel(this.choiceCallback.getPrompt());
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            this.pnl2.add(jComponent);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(20, 3, 10, 10);
            object = this.choiceCallback.getChoices();
            this.choiceList.setListData((E[])object);
            gridBagLayout.setConstraints(this.choiceList, gridBagConstraints);
            this.pnl2.add(this.choiceList);
        }
        this.okButton = new JButton(localStrings.getLocalString("enterprise.security.ok", " OK "));
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                PassphraseDialog.this.username = PassphraseDialog.this.userField.getText();
                if (PassphraseDialog.this.username.trim().length() > 0) {
                    PassphraseDialog.this.nameCallback.setName(PassphraseDialog.this.username);
                }
                if (PassphraseDialog.this.passwordCallback != null) {
                    PassphraseDialog.this.passphrase = new String(PassphraseDialog.this.passField.getPassword());
                    if (PassphraseDialog.this.passphrase.trim().length() > 0) {
                        PassphraseDialog.this.passwordCallback.setPassword(PassphraseDialog.this.passphrase.toCharArray());
                    }
                }
                if (PassphraseDialog.this.choiceCallback != null && (n = PassphraseDialog.this.choiceList.getSelectedIndex()) != -1) {
                    PassphraseDialog.this.choiceCallback.setSelectedIndex(n);
                }
                PassphraseDialog.this.dispose();
            }
        });
        this.cancelButton = new JButton(localStrings.getLocalString("enterprise.security.cancel", "Cancel"));
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PassphraseDialog.this.choiceCallback != null) {
                    PassphraseDialog.this.choiceCallback.setSelectedIndex(-1);
                } else {
                    PassphraseDialog.this.username = null;
                    PassphraseDialog.this.passphrase = null;
                    PassphraseDialog.this.dispose();
                }
            }
        });
        super.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (PassphraseDialog.this.choiceCallback != null) {
                    PassphraseDialog.this.choiceCallback.setSelectedIndex(-1);
                }
                PassphraseDialog.this.dispose();
            }
        });
        jComponent = new JPanel();
        jComponent.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 0, 5, 15);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        jComponent.add(this.okButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(5, 15, 5, 0);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        jComponent.add(this.cancelButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.pnl2.add(jComponent);
        this.getContentPane().add((Component)this.pnl, "Keystore Password Box");
        this.getContentPane().add((Component)this.pnl2, "Cerificate Chooser");
        object = (CardLayout)this.getContentPane().getLayout();
        if (this.choiceCallback != null) {
            ((CardLayout)object).show(this.getContentPane(), "Keystore Password Box");
        } else {
            ((CardLayout)object).show(this.getContentPane(), "Cerificate Chooser");
        }
        this.pack();
        this.setSize(this.getPreferredSize());
    }
}

